/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartMap;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.CenterLookup;
import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IConnectableBlockEntity
extends IBlockEventBlockEntity,
IConnectable {
    default public BlockPos posOfInternal() {
        return this.getBlockPosition();
    }

    default public BlockPos posOfStraight(int s) {
        return this.getBlockPosition().relative(Direction.values()[s]);
    }

    default public BlockPos posOfCorner(int s, int edgeRot) {
        return this.getBlockPosition().relative(Direction.values()[s]).relative(Direction.values()[Rotation.rotateSide((int)(s ^ 1), (int)edgeRot)]);
    }

    default public int rotFromStraight(int s, int edgeRot) {
        return Rotation.rotationTo((int)Rotation.rotateSide((int)(s ^ 1), (int)edgeRot), (int)(s ^ 1));
    }

    default public int rotFromCorner(int s, int edgeRot) {
        return Rotation.rotationTo((int)(s ^ 1), (int)(Rotation.rotateSide((int)(s ^ 1), (int)edgeRot) ^ 1));
    }

    default public void notifyStraight(int s) {
        BlockPos pos = this.posOfStraight(s);
        this.getBlockLevel().neighborChanged(pos, this.getBlockLevel().getBlockState(pos).getBlock(), this.posOfInternal());
    }

    default public void notifyCorner(int s, int edgeRot) {
        BlockPos pos = this.posOfCorner(s, edgeRot);
        this.getBlockLevel().neighborChanged(pos, this.getBlockLevel().getBlockState(pos).getBlock(), this.posOfInternal());
    }

    default public void notifyConnectedExternals() {
        int smask = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            smask |= 1 << s;
        }
        this.notifyExternals(smask);
    }

    default public void notifyExternals(int mask) {
        int smask = 0;
        for (int s = 0; s < 6; ++s) {
            if ((mask & 1 << s) == 0) continue;
            BlockPos pos = this.posOfStraight(s);
            BlockState state = this.getBlockLevel().getBlockState(pos);
            this.getBlockLevel().neighborChanged(pos, state.getBlock(), this.posOfInternal());
            for (int s2 = 0; s2 < 6; ++s2) {
                BlockPos pos2 = pos.relative(Direction.values()[s2]);
                BlockState state2 = this.getBlockLevel().getBlockState(pos2);
                if (s2 == (s ^ 1) || (smask & 1 << s2) != 0) continue;
                this.getBlockLevel().neighborChanged(pos2, state2.getBlock(), pos);
            }
            smask |= 1 << s;
        }
    }

    @Nullable
    default public MultiPart getStraightCenter(int s) {
        BlockPos pos = this.posOfStraight(s);
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)this.getBlockLevel(), (BlockPos)pos);
        if (tile == null) {
            return null;
        }
        return tile.getSlottedPart(6);
    }

    @Nullable
    default public MultiPart getStraight(int s, int edgeRot) {
        BlockPos pos = this.posOfStraight(s);
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)this.getBlockLevel(), (BlockPos)pos);
        if (tile == null) {
            return null;
        }
        return tile.getSlottedPart(Rotation.rotateSide((int)(s ^ 1), (int)edgeRot));
    }

    @Nullable
    default public MultiPart getCorner(int s, int edgeRot) {
        BlockPos pos = this.posOfCorner(s, edgeRot);
        TileMultipart tile = BlockMultipart.getTile((BlockGetter)this.getBlockLevel(), (BlockPos)pos);
        if (tile == null) {
            return null;
        }
        return tile.getSlottedPart(s ^ 1);
    }

    public long getConnMap();

    public void setConnMap(long var1);

    default public boolean maskConnects(int s) {
        return (this.getConnMap() & (0xF0000000FL << s * 4 | 0x1000000L << s)) != 0L;
    }

    default public boolean maskConnectsStraightCenter(int s) {
        return (this.getConnMap() & 0x1000000L << s) != 0L;
    }

    default public boolean maskConnectsStraight(int s, int edgeRot) {
        return (this.getConnMap() & 1L << edgeRot << s * 4) != 0L;
    }

    default public boolean maskConnectsCorner(int s, int edgeRot) {
        return (this.getConnMap() & 0x100000000L << s * 4 << edgeRot) != 0L;
    }

    default public boolean outsideCornerEdgeOpen(int s, int edgeRot) {
        BlockPos pos = this.posOfInternal().relative(Direction.values()[s]);
        if (this.getBlockLevel().isEmptyBlock(pos)) {
            return true;
        }
        int side1 = s ^ 1;
        int side2 = Rotation.rotateSide((int)(s ^ 1), (int)edgeRot);
        TileMultipart t = BlockMultipart.getTile((BlockGetter)this.getBlockLevel(), (BlockPos)pos);
        if (t == null) {
            return false;
        }
        return t.getSlottedPart(side1) == null && t.getSlottedPart(side2) == null && t.getSlottedPart(PartMap.edgeBetween((int)side1, (int)side2)) == null;
    }

    default public boolean discoverStraightCenter(int s) {
        MultiPart p = this.getStraightCenter(s);
        if (p instanceof IConnectable) {
            IConnectable connectable = (IConnectable)p;
            return this.canConnectPart(connectable, s, -1) && connectable.connectStraight((IConnectable)this, s ^ 1, -1);
        }
        return this.discoverStraightCenterOverride(s);
    }

    default public boolean discoverStraight(int s, int edgeRot) {
        MultiPart p = this.getStraight(s, edgeRot);
        if (p instanceof IConnectable) {
            IConnectable connectable = (IConnectable)p;
            return this.canConnectPart(connectable, s, edgeRot) && connectable.connectStraight((IConnectable)this, this.rotFromStraight(s, edgeRot), -1);
        }
        return false;
    }

    default public boolean discoverCorner(int s, int edgeRot) {
        MultiPart p = this.getCorner(s, edgeRot);
        if (p instanceof IConnectable) {
            IConnectable connectable = (IConnectable)p;
            return this.canConnectPart(connectable, s, edgeRot) && this.outsideCornerEdgeOpen(s, edgeRot) && connectable.connectCorner((IConnectable)this, this.rotFromCorner(s, edgeRot), -1);
        }
        return false;
    }

    default public boolean discoverStraightCenterOverride(int s) {
        CenterLookup lookup = CenterLookup.lookupStraightCenter(this.getBlockLevel(), this.getBlockPosition(), s);
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof IConnectable) {
            IConnectable connectable = (IConnectable)blockEntity;
            return this.canConnectPart(connectable, s, -1) && connectable.connectStraight((IConnectable)this, s ^ 1, -1);
        }
        return false;
    }

    default public boolean updateExternals() {
        long connMap = 0L;
        for (int s = 0; s < 6; ++s) {
            int edgeRot;
            if (this.discoverStraightCenter(s)) {
                connMap |= 0x1000000L << s;
            }
            for (edgeRot = 0; edgeRot < 4; ++edgeRot) {
                if (!this.discoverStraight(s, edgeRot)) continue;
                connMap |= 1L << edgeRot << s * 4;
            }
            for (edgeRot = 0; edgeRot < 4; ++edgeRot) {
                if (!this.discoverCorner(s, edgeRot)) continue;
                connMap |= 0x100000000L << edgeRot << s * 4;
            }
        }
        if (connMap != this.getConnMap()) {
            this.setConnMap(connMap);
            this.onMaskChanged();
            return true;
        }
        return false;
    }

    default public boolean connectStraight(IConnectable part, int s, int edgeRot) {
        if (this.canConnectPart(part, s, edgeRot)) {
            long connMap = this.getConnMap();
            connMap = edgeRot > -1 ? (connMap |= 1L << edgeRot << s * 4) : (connMap |= 0x1000000L << s * 4);
            if (connMap != this.getConnMap()) {
                this.setConnMap(connMap);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    default public boolean connectCorner(IConnectable part, int s, int edgeRot) {
        if (this.canConnectPart(part, s, edgeRot)) {
            long connMap = this.getConnMap();
            if ((connMap |= 0x100000000L << edgeRot << s * 4) != this.getConnMap()) {
                this.setConnMap(connMap);
                this.onMaskChanged();
            }
            return true;
        }
        return false;
    }

    default public boolean connectInternal(IConnectable part, int r) {
        return false;
    }

    default public boolean canConnectCorner(int r) {
        return false;
    }

    default public void onMaskChanged() {
    }

    public boolean canConnectPart(IConnectable var1, int var2, int var3);
}

