/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.multipart.api.MultipartType;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import mrtjp.projectred.compatibility.ComputerCraftCompatibility;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.CoreNetwork;
import mrtjp.projectred.core.data.CoreBlockStateModelProvider;
import mrtjp.projectred.core.data.CoreBlockTagsProvider;
import mrtjp.projectred.core.data.CoreItemModelProvider;
import mrtjp.projectred.core.data.CoreItemTagsProvider;
import mrtjp.projectred.core.data.CoreLanguageProvider;
import mrtjp.projectred.core.data.CoreLootTableProvider;
import mrtjp.projectred.core.data.CoreRecipeProvider;
import mrtjp.projectred.core.init.CoreBlocks;
import mrtjp.projectred.core.init.CoreClientInit;
import mrtjp.projectred.core.init.CoreCreativeModeTabs;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.init.CoreMenus;
import mrtjp.projectred.core.init.CoreParts;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="projectred_core")
public class ProjectRedCore {
    public static final String MOD_ID = "projectred_core";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_core");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"projectred_core");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"projectred_core");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"projectred_core");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"projectred_core");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"projectred_core");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceKey)MultipartType.MULTIPART_TYPES, (String)"projectred_core");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"projectred_core");
    @Nullable
    private static ModContainer container;

    public ProjectRedCore(ModContainer container, IEventBus modEventBus) {
        ProjectRedCore.container = container;
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configurator.serverSpec, "projectred-server.toml");
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Configurator.clientSpec, "projectred-client.toml");
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        modEventBus.addListener(Configurator::onLoad);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        modEventBus.addListener(this::onRegisterCaps);
        if (FMLEnvironment.dist.isClient()) {
            CoreClientInit.init(modEventBus);
        }
        CoreNetwork.init(modEventBus);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        PART_TYPES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
    }

    public static ModContainer getContainer() {
        return Objects.requireNonNull(container);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModList.get().getModContainerById("computercraft").ifPresent(mod -> ComputerCraftCompatibility.init(mod));
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new CoreBlockStateModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new CoreItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new CoreLanguageProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new CoreRecipeProvider(registries, output));
        generator.addProvider(event.includeServer(), (DataProvider)new CoreLootTableProvider(output, registries));
        CoreBlockTagsProvider blockTagsProvider = new CoreBlockTagsProvider(output, registries, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CoreItemTagsProvider(output, registries, blockTagsProvider.contentsGetter(), fileHelper));
    }

    public void onRegisterCaps(RegisterCapabilitiesEvent event) {
        CoreBlocks.registerCaps(event);
    }

    static {
        CoreBlocks.register();
        CoreItems.register();
        CoreMenus.register();
        CoreParts.register();
        CoreCreativeModeTabs.register();
    }
}

