/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import java.util.LinkedList;
import java.util.List;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BaseConnectableBlockEntity;
import mrtjp.projectred.core.tile.IPoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BasePoweredBlockEntity
extends BaseConnectableBlockEntity
implements IPoweredBlockEntity {
    private final List<PowerConductor> connectedConductors = new LinkedList<PowerConductor>();
    private boolean cacheInvalid = true;

    public BasePoweredBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void invalidateConductorCache() {
        this.cacheInvalid = true;
    }

    @Override
    public void onMaskChanged() {
        super.onMaskChanged();
        this.cacheInvalid = true;
    }

    @Override
    public void onNeighborBlockChanged(BlockPos neighborPos) {
        super.onNeighborBlockChanged(neighborPos);
        this.cacheInvalid = true;
    }

    @Override
    public long getTime() {
        return this.level.getGameTime();
    }

    @Override
    public List<PowerConductor> getConnectedConductors() {
        if (this.cacheInvalid) {
            this.recacheConductors();
            this.cacheInvalid = false;
        }
        return this.connectedConductors;
    }

    private void recacheConductors() {
        int s;
        this.connectedConductors.clear();
        for (s = 0; s < 6; ++s) {
            for (int r = 0; r < 4; ++r) {
                PowerConductor c = IPoweredBlockEntity.getExternalConductorForFaceConn(this, s, r);
                if (c == null) continue;
                this.connectedConductors.add(c);
            }
        }
        for (s = 0; s < 6; ++s) {
            PowerConductor c = IPoweredBlockEntity.getExternalConductorForCenterConn(this, s);
            if (c == null) continue;
            this.connectedConductors.add(c);
        }
    }

    public abstract int getConductorCharge();

    public abstract int getConductorFlow();

    public abstract boolean canConductorWork();
}

