/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.compatibility;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.redstone.BundledRedstoneProvider;
import javax.annotation.Nonnull;
import mrtjp.projectred.api.IBundledTileInteraction;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.ProjectRedCore;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class ComputerCraftCompatibility {
    public static void init(Object ccModObject) {
        if (ProjectRedAPI.transmissionAPI != null) {
            ProjectRedCore.LOGGER.info("Loading Project Red ComputerCraft Compatibility Module");
            ComputerCraftAPI.registerBundledRedstoneProvider((BundledRedstoneProvider)new CCPRBundledRedstoneProvider());
            ProjectRedAPI.transmissionAPI.registerBundledTileInteraction((IBundledTileInteraction)new PRCCBundledTileInteraction());
        }
    }

    private static class CCPRBundledRedstoneProvider
    implements BundledRedstoneProvider {
        private CCPRBundledRedstoneProvider() {
        }

        public int getBundledRedstoneOutput(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Direction side) {
            assert (ProjectRedAPI.transmissionAPI != null);
            byte[] signal = ProjectRedAPI.transmissionAPI.getBundledInput(world, pos.relative(side), side.getOpposite());
            return BundledSignalsLib.packDigital(signal);
        }
    }

    private static class PRCCBundledTileInteraction
    implements IBundledTileInteraction {
        private PRCCBundledTileInteraction() {
        }

        public boolean isValidInteractionFor(Level world, BlockPos pos, Direction side) {
            return ComputerCraftAPI.getBundledRedstoneOutput((Level)world, (BlockPos)pos, (Direction)side) != -1;
        }

        public boolean canConnectBundled(Level world, BlockPos pos, Direction side) {
            return true;
        }

        public byte[] getBundledSignal(Level world, BlockPos pos, Direction side) {
            int signal = ComputerCraftAPI.getBundledRedstoneOutput((Level)world, (BlockPos)pos, (Direction)side);
            return BundledSignalsLib.unpackDigital(null, signal);
        }
    }
}

