/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.config.ConfigCategory;
import codechicken.lib.config.ConfigFile;
import codechicken.lib.config.ConfigValue;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Configurator {
    private static final Logger LOGGER = LogManager.getLogger();
    static final ModConfigSpec serverSpec;
    public static final Server SERVER;
    static final ModConfigSpec clientSpec;
    public static final Client CLIENT;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        IConfigSpec loadedSpec = configEvent.getConfig().getSpec();
        if (loadedSpec != serverSpec && loadedSpec != clientSpec) {
            return;
        }
        try {
            Path oldConfigPath = Paths.get("config", "ProjectRed.cfg");
            if (!Files.exists(oldConfigPath, new LinkOption[0])) {
                LOGGER.debug("ProjectRed config migration: No legacy config found, skipping migration...");
                return;
            }
            LOGGER.debug("ProjectRed config migration: Legacy config found, attempting migration...");
            ConfigFile legacyConfig = new ConfigFile("projectred_core").path(oldConfigPath);
            ConfigCategory root = legacyConfig.load();
            ConfigCategory migrationCategory = root.getCategory("neoforge_config_migration").setComment("Records migration from legacy ProjectRed.cfg to NeoForge Config toml config");
            ConfigValue migrationValue = migrationCategory.getValue(loadedSpec == serverSpec ? "server_migrated" : "client_migrated").setDefaultBoolean(false);
            if (migrationValue.getBoolean()) {
                LOGGER.debug("Legacy config indicates already migrated ({}). Skipping...", (Object)migrationValue.getName());
                return;
            }
            LOGGER.info("Migrating server settings {} -> {}", (Object)oldConfigPath.getFileName(), (Object)configEvent.getConfig().getFileName());
            if (loadedSpec == serverSpec) {
                Configurator.migrateLegacyServerValues(root);
                serverSpec.save();
            } else {
                Configurator.migrateLegacyClientValues(root);
                clientSpec.save();
            }
            migrationValue.setBoolean(true);
            migrationCategory.save();
        }
        catch (Exception e) {
            LOGGER.error("Failed to migrate legacy config, using defaults", (Throwable)e);
        }
    }

    private static void migrateLegacyServerValues(ConfigCategory root) {
        ConfigCategory general = root.getCategory("general");
        Configurator.SERVER.logicGateSounds.set((Object)general.getValue("gate_sounds").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.logicGateLights.set((Object)general.getValue("gate_lights").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.minTimerTicks.set((Object)general.getValue("gate_min_timer_ticks").setDefaultInt(4).getInt());
        Configurator.SERVER.unbreakableScrewdriver.set((Object)general.getValue("infinite_screwdriver").setDefaultBoolean(false).getBoolean());
        ConfigCategory machines = root.getCategory("machines");
        Configurator.SERVER.frameMoveLimit.set((Object)machines.getValue("frame_move_limit").setDefaultInt(1024).getInt());
        ConfigCategory gen = root.getCategory("world_gen");
        Configurator.SERVER.generateRubyOres.set((Object)gen.getValue("ruby_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generateSapphireOres.set((Object)gen.getValue("sapphire_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generatePeridotOres.set((Object)gen.getValue("peridot_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generateTinOres.set((Object)gen.getValue("tin_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generateSilverOres.set((Object)gen.getValue("silver_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generateElectrotineOres.set((Object)gen.getValue("electrotine_ore").setDefaultBoolean(true).getBoolean());
        Configurator.SERVER.generateMarbleCaves.set((Object)gen.getValue("marble_cave").setDefaultBoolean(true).getBoolean());
        ConfigCategory fab = root.getCategory("fabrication");
        Configurator.SERVER.autoCompileTileLimit.set((Object)fab.getValue("auto_compile_tile_limit").setDefaultInt(20).getInt());
    }

    private static void migrateLegacyClientValues(ConfigCategory root) {
        ConfigCategory rendering = root.getCategory("rendering");
        Configurator.CLIENT.logicwires3D.set((Object)rendering.getValue("gate_3d_wires").setDefaultBoolean(true).getBoolean());
        Configurator.CLIENT.staticWires.set((Object)rendering.getValue("static_wire_renderer").setDefaultBoolean(true).getBoolean());
        Configurator.CLIENT.staticGates.set((Object)rendering.getValue("static_gate_renderer").setDefaultBoolean(true).getBoolean());
        Configurator.CLIENT.lightHaloMax.set((Object)rendering.getValue("max_lights").setDefaultInt(-1).getInt());
        Configurator.CLIENT.fabulousLights.set((Object)rendering.getValue("fabulous_lights").setDefaultBoolean(true).getBoolean());
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Server::new);
        serverSpec = (ModConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Server {
        public static final String RUBY_ORE_KEY = "ruby_ore";
        public static final String SAPPHIRE_ORE_KEY = "sapphire_ore";
        public static final String PERIDOT_ORE_KEY = "peridot_ore";
        public static final String TIN_ORE_KEY = "tin_ore";
        public static final String SILVER_ORE_KEY = "silver_ore";
        public static final String ELECTROTINE_ORE_KEY = "electrotine_ore";
        public static final String MARBLE_CAVE_KEY = "marble_cave";
        public final ModConfigSpec.BooleanValue logicGateSounds;
        public final ModConfigSpec.BooleanValue unbreakableScrewdriver;
        public final ModConfigSpec.BooleanValue logicGateLights;
        public final ModConfigSpec.IntValue minTimerTicks;
        public final ModConfigSpec.IntValue frameMoveLimit;
        public final ModConfigSpec.IntValue autoCompileTileLimit;
        public final ModConfigSpec.BooleanValue generateRubyOres;
        public final ModConfigSpec.BooleanValue generateSapphireOres;
        public final ModConfigSpec.BooleanValue generatePeridotOres;
        public final ModConfigSpec.BooleanValue generateTinOres;
        public final ModConfigSpec.BooleanValue generateSilverOres;
        public final ModConfigSpec.BooleanValue generateElectrotineOres;
        public final ModConfigSpec.BooleanValue generateMarbleCaves;
        private final Map<String, ModConfigSpec.BooleanValue> worldFeatures = new HashMap<String, ModConfigSpec.BooleanValue>();

        private Server(ModConfigSpec.Builder builder) {
            builder.comment("Settings that effect gameplay, balance, progression, etc.").push("gameplay");
            this.unbreakableScrewdriver = builder.comment("If set to true, the basic screwdriver will not take damage").define("infinite_screwdriver", false);
            this.logicGateSounds = builder.comment("If set to false, logic gates will not make sounds").define("gate_sounds", true);
            builder.pop();
            builder.comment("Settings that effect performance").push("performance");
            this.logicGateLights = builder.comment("If set to false, logic gates will not emit light. Can help reduce light updates on particularly large and fast-updating redstone circuits.").define("gate_lights", true);
            this.minTimerTicks = builder.comment("Minimum amount of ticks the timer gates can be set to (min 4). Can be used to enforce lower update rates.").defineInRange("gate_min_timer_ticks", 4, 4, Integer.MAX_VALUE);
            this.frameMoveLimit = builder.comment("Max blocks in a moving frame structure. Limiting this can improve performance on servers where lots of structures are being moved.").defineInRange("frame_move_limit", 1024, 1, 4096);
            this.autoCompileTileLimit = builder.comment("Max number of tiles allowed in IC Workbench before auto-compile becomes disallowed (-1 to always allow, 0 to never allow). Recommended to keep this very low on servers.").defineInRange("auto_compile_tile_limit", 20, -1, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("World generation settings").push("world_gen");
            this.generateRubyOres = this.defineAndStoreFeature(builder, RUBY_ORE_KEY, true);
            this.generateSapphireOres = this.defineAndStoreFeature(builder, SAPPHIRE_ORE_KEY, true);
            this.generatePeridotOres = this.defineAndStoreFeature(builder, PERIDOT_ORE_KEY, true);
            this.generateTinOres = this.defineAndStoreFeature(builder, TIN_ORE_KEY, true);
            this.generateSilverOres = this.defineAndStoreFeature(builder, SILVER_ORE_KEY, true);
            this.generateElectrotineOres = this.defineAndStoreFeature(builder, ELECTROTINE_ORE_KEY, true);
            this.generateMarbleCaves = this.defineAndStoreFeature(builder, MARBLE_CAVE_KEY, true);
            builder.pop();
        }

        private ModConfigSpec.BooleanValue defineAndStoreFeature(ModConfigSpec.Builder builder, String key, boolean defaultValue) {
            ModConfigSpec.BooleanValue value = builder.define(key, defaultValue);
            this.worldFeatures.put(key, value);
            return value;
        }

        public boolean isWorldFeatureEnabled(String key) {
            if (!this.worldFeatures.containsKey(key)) {
                LOGGER.warn("Requested world feature with unknown config key: {}", (Object)key);
                return false;
            }
            return (Boolean)this.worldFeatures.get(key).get();
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue logicwires3D;
        public final ModConfigSpec.BooleanValue staticWires;
        public final ModConfigSpec.BooleanValue staticGates;
        public final ModConfigSpec.IntValue lightHaloMax;
        public final ModConfigSpec.BooleanValue fabulousLights;

        private Client(ModConfigSpec.Builder builder) {
            builder.comment("Render settings").push("rendering");
            this.logicwires3D = builder.comment("If set to false, flat wire textures will be used for logic gates. Significant performance improvement").define("gate_3d_wires", true);
            this.staticWires = builder.comment("If set to false, wires will be rendered in the TESR rather than the WorldRenderer").define("static_wire_renderer", true);
            this.staticGates = builder.comment("If set to false, gates will be rendered in the TESR rather than the WorldRenderer").define("static_gate_renderer", true);
            builder.pop();
            builder.comment("Lighting settings").push("lighting");
            this.lightHaloMax = builder.comment("Max lights on screen at a time, -1 for unlimited. This limits the number of light halos that can be rendered around ProjectRed light sources. Lower values improve performance. ").defineInRange("max_lights", -1, -1, 1024);
            this.fabulousLights = builder.comment("Use fabulous shader pipeline for lights when on Fabulous Graphics mode. This creates a screenspaceblooming effect when looking towards ProjectRed light sources.").define("fabulous_lights", true);
            builder.pop();
        }
    }
}

