/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FaceLookup {
    public final Level world;
    public final BlockPos pos;
    public final int side;
    public final int r;
    public final int dir;
    public final BlockState state;
    public final Block block;
    @Nullable
    public final BlockEntity tile;
    @Nullable
    public final MultiPart part;
    public final BlockPos otherPos;
    public final int otherSide;
    public final int otherRotation;
    public final int otherDir;

    public FaceLookup(Level world, BlockPos pos, int side, int r, BlockState state, @Nullable BlockEntity tile, @Nullable MultiPart part, BlockPos otherPos, int otherSide, int otherRotation) {
        this.world = world;
        this.pos = pos;
        this.side = side;
        this.r = r;
        this.dir = r == -1 ? side ^ 1 : Rotation.rotateSide((int)side, (int)r);
        this.state = state;
        this.block = state.getBlock();
        this.tile = tile;
        this.part = part;
        this.otherPos = otherPos;
        this.otherSide = otherSide;
        this.otherRotation = otherRotation;
        this.otherDir = otherSide == -1 ? otherRotation : Rotation.rotateSide((int)otherSide, (int)otherRotation);
    }

    public static FaceLookup lookupCorner(Level world, BlockPos pos, int side, int r) {
        MultiPart multiPart;
        BlockState state;
        int absDir = Rotation.rotateSide((int)side, (int)r);
        int otherSide = absDir ^ 1;
        int otherRotation = Rotation.rotationTo((int)(absDir ^ 1), (int)(side ^ 1));
        BlockPos pos2 = pos.relative(Direction.values()[absDir]).relative(Direction.values()[side]);
        BlockEntity tile = FaceLookup.getBlockEntityForState(world, pos2, state = world.getBlockState(pos2));
        if (tile instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)tile;
            multiPart = tmp.getSlottedPart(otherSide);
        } else {
            multiPart = null;
        }
        MultiPart part = multiPart;
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupStraight(Level world, BlockPos pos, int side, int r) {
        MultiPart multiPart;
        BlockState state;
        int otherSide = side;
        int otherRotation = (r + 2) % 4;
        BlockPos pos2 = pos.relative(Direction.values()[Rotation.rotateSide((int)side, (int)r)]);
        BlockEntity tile = FaceLookup.getBlockEntityForState(world, pos2, state = world.getBlockState(pos2));
        if (tile instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)tile;
            multiPart = tmp.getSlottedPart(otherSide);
        } else {
            multiPart = null;
        }
        MultiPart part = multiPart;
        return new FaceLookup(world, pos, side, r, state, tile, part, pos2, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideFace(Level world, BlockPos pos, int side, int r) {
        MultiPart multiPart;
        int absDir;
        int otherSide = absDir = Rotation.rotateSide((int)side, (int)r);
        int otherRotation = Rotation.rotationTo((int)absDir, (int)side);
        BlockState state = world.getBlockState(pos);
        BlockEntity tile = FaceLookup.getBlockEntityForState(world, pos, state);
        if (tile instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)tile;
            multiPart = tmp.getSlottedPart(otherSide);
        } else {
            multiPart = null;
        }
        MultiPart part = multiPart;
        return new FaceLookup(world, pos, side, r, state, tile, part, pos, otherSide, otherRotation);
    }

    public static FaceLookup lookupInsideCenter(Level world, BlockPos pos, int side) {
        MultiPart multiPart;
        int otherSide = -1;
        int otherRotation = side;
        BlockState state = world.getBlockState(pos);
        BlockEntity tile = FaceLookup.getBlockEntityForState(world, pos, state);
        if (tile instanceof TileMultipart) {
            TileMultipart tmp = (TileMultipart)tile;
            multiPart = tmp.getSlottedPart(6);
        } else {
            multiPart = null;
        }
        MultiPart part = multiPart;
        return new FaceLookup(world, pos, side, -1, state, tile, part, pos, otherSide, otherRotation);
    }

    @Nullable
    static BlockEntity getBlockEntityForState(Level level, BlockPos pos, BlockState state) {
        TileMultipart tmp;
        if (!state.hasBlockEntity()) {
            return null;
        }
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile == null || tile.isRemoved()) {
            return null;
        }
        if (tile instanceof TileMultipart && (tmp = (TileMultipart)tile).getPartList().isEmpty()) {
            return null;
        }
        return tile;
    }
}

