/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.block;

import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectRedBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty SIDE = IntegerProperty.create((String)"side", (int)0, (int)5);
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final BooleanProperty CHARGED = BooleanProperty.create((String)"charged");
    public static final BooleanProperty WORKING = BooleanProperty.create((String)"working");
    public static final BooleanProperty ACTIVE = BooleanProperty.create((String)"active");
    public static final BlockBehaviour.Properties WOODEN_MACHINE_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.5f).sound(SoundType.WOOD);
    public static final BlockBehaviour.Properties STONE_MACHINE_PROPERTIES = BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(3.5f).sound(SoundType.STONE);

    public ProjectRedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != this.getBlockEntityType()) {
            return null;
        }
        return (level1, pos, state1, tile) -> {
            if (tile instanceof IBlockEventBlockEntity) {
                IBlockEventBlockEntity t = (IBlockEventBlockEntity)tile;
                t.tick();
            }
        };
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onNeighborBlockChanged(neighbor);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onNeighborTileChanged(neighbor);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            return ((IBlockEventBlockEntity)tile).useItemOn(stack, player, hand, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            return ((IBlockEventBlockEntity)tile).useWithoutItem(player, hit);
        }
        return InteractionResult.PASS;
    }

    public void onRemove(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            if (oldState.is(newState.getBlock())) {
                ((IBlockEventBlockEntity)tile).onBlockStateReplaced(newState);
            } else {
                ((IBlockEventBlockEntity)tile).onBlockRemoved();
            }
        }
        super.onRemove(oldState, world, pos, newState, isMoving);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity player, ItemStack stack) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEventBlockEntity) {
            ((IBlockEventBlockEntity)tile).onBlockPlaced(player, stack);
        }
    }
}

