/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.lib;

import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryLib {
    public static void injectItemStack(Container inventory, ItemStack stack, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, 0, inventory.getContainerSize(), reverse);
    }

    public static void injectItemStack(Container inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, true);
        if (!stack.isEmpty()) {
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse, false);
        }
    }

    public static boolean injectAllItemStacks(Container inventory, NonNullList<ItemStack> stacks, boolean reverse) {
        return InventoryLib.injectAllItemStacks(inventory, stacks, 0, inventory.getContainerSize(), reverse);
    }

    public static boolean injectAllItemStacks(Container inventory, NonNullList<ItemStack> stacks, int startIndex, int endIndex, boolean reverse) {
        boolean allInjected = true;
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            InventoryLib.injectItemStack(inventory, stack, startIndex, endIndex, reverse);
            if (stack.isEmpty()) {
                stacks.set(i, (Object)ItemStack.EMPTY);
                continue;
            }
            allInjected = false;
        }
        return allInjected;
    }

    private static void injectItemStack(Container inventory, ItemStack stack, int startIndex, int endIndex, boolean reverse, boolean mergeOnly) {
        for (int i = startIndex; i < endIndex; ++i) {
            int index = reverse ? endIndex - i - 1 : i;
            ItemStack stackInSlot = inventory.getItem(index);
            if (stackInSlot.isEmpty()) {
                if (mergeOnly) continue;
                inventory.setItem(index, stack.copy());
                stack.setCount(0);
            } else if (InventoryLib.areStackable(stack, stackInSlot)) {
                int maxStackSize = Math.min(inventory.getMaxStackSize(), stackInSlot.getMaxStackSize());
                int spaceRemaining = Math.max(0, maxStackSize - stackInSlot.getCount());
                int amountToInsert = Math.min(spaceRemaining, stack.getCount());
                stack.shrink(amountToInsert);
                stackInSlot.grow(amountToInsert);
                inventory.setItem(index, stackInSlot);
            }
            if (stack.isEmpty()) break;
        }
    }

    public static boolean injectWorldly(WorldlyContainer container, ItemStack stack, int side, boolean simulate) {
        int[] slots;
        Direction insertDir = Direction.values()[side];
        for (int s : slots = container.getSlotsForFace(insertDir)) {
            if (!container.canPlaceItemThroughFace(s, stack, insertDir)) continue;
            ItemStack stackInSlot = container.getItem(s).copy();
            if (stackInSlot.isEmpty()) {
                if (!simulate) {
                    container.setItem(s, stack.copy());
                }
                stack.setCount(0);
                return true;
            }
            if (!InventoryLib.areStackable(stack, stackInSlot)) continue;
            int remainingSpace = Math.max(0, stackInSlot.getMaxStackSize() - stackInSlot.getCount());
            int amountToInsert = Math.min(remainingSpace, stack.getCount());
            stack.shrink(amountToInsert);
            stackInSlot.grow(amountToInsert);
            if (!simulate) {
                container.setItem(s, stackInSlot);
            }
            if (!stack.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean injectItemHandler(IItemHandler handler, ItemStack stack, boolean simulate) {
        for (int s = 0; s < handler.getSlots(); ++s) {
            if (!handler.isItemValid(s, stack)) continue;
            ItemStack remainingStack = handler.insertItem(s, stack.copy(), simulate);
            if (remainingStack.isEmpty()) {
                stack.setCount(0);
                return true;
            }
            stack.setCount(remainingStack.getCount());
        }
        return false;
    }

    public static boolean areStackable(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) && a.getMaxStackSize() > 1 && b.getMaxStackSize() > 1;
    }

    public static void addPlayerInventory(Inventory playerInventory, int x, int y, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((Container)playerInventory, 9, x, y, 9, 3, slotConsumer);
        InventoryLib.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1, slotConsumer);
    }

    public static void addPlayerInventory(Inventory playerInventory, int x, int y, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory((Container)playerInventory, 9, x, y, 9, 3, slotFactory, slotConsumer);
        InventoryLib.addInventory((Container)playerInventory, 0, x, y + 58, 9, 1, slotFactory, slotConsumer);
    }

    public static void addInventory(Container inventory, int i, int x, int y, int columns, int rows, Consumer<Slot> slotConsumer) {
        InventoryLib.addInventory(inventory, i, x, y, columns, rows, Slot::new, slotConsumer);
    }

    public static void addInventory(Container inventory, int i, int x, int y, int columns, int rows, SlotFactory slotFactory, Consumer<Slot> slotConsumer) {
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < columns; ++c) {
                slotConsumer.accept(slotFactory.createSlot(inventory, i + (r * columns + c), x + c * 18, y + r * 18));
            }
        }
    }

    @FunctionalInterface
    public static interface SlotFactory {
        public Slot createSlot(Container var1, int var2, int var3, int var4);
    }
}

