/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.api.CleanerXAPI;
import pl.syntaxdevteam.cleanerx.api.CleanerXApiImpl;
import pl.syntaxdevteam.cleanerx.base.SwearCounter;
import pl.syntaxdevteam.cleanerx.base.WordFilter;
import pl.syntaxdevteam.cleanerx.commands.CommandManager;
import pl.syntaxdevteam.cleanerx.common.ConfigHandler;
import pl.syntaxdevteam.cleanerx.common.Logger;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;
import pl.syntaxdevteam.cleanerx.common.PluginManager;
import pl.syntaxdevteam.cleanerx.common.StatsCollector;
import pl.syntaxdevteam.cleanerx.common.UUIDManager;
import pl.syntaxdevteam.cleanerx.common.UpdateChecker;
import pl.syntaxdevteam.cleanerx.eventhandler.CleanerXChat;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u000203H\u0002J\b\u00106\u001a\u000203H\u0002J\b\u00107\u001a\u000203H\u0002J\b\u00108\u001a\u000203H\u0002J\u0006\u00109\u001a\u000203J\b\u0010:\u001a\u000203H\u0002J\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u000203H\u0016J\b\u0010>\u001a\u000203H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u0006?"}, d2={"Lpl/syntaxdevteam/cleanerx/CleanerX;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "config", "Lorg/bukkit/configuration/file/FileConfiguration;", "logger", "Lpl/syntaxdevteam/cleanerx/common/Logger;", "getLogger", "()Lpl/syntaxdevteam/cleanerx/common/Logger;", "setLogger", "(Lpl/syntaxdevteam/cleanerx/common/Logger;)V", "pluginsManager", "Lpl/syntaxdevteam/cleanerx/common/PluginManager;", "getPluginsManager", "()Lpl/syntaxdevteam/cleanerx/common/PluginManager;", "setPluginsManager", "(Lpl/syntaxdevteam/cleanerx/common/PluginManager;)V", "statsCollector", "Lpl/syntaxdevteam/cleanerx/common/StatsCollector;", "messageHandler", "Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "getMessageHandler", "()Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "setMessageHandler", "(Lpl/syntaxdevteam/cleanerx/common/MessageHandler;)V", "updateChecker", "Lpl/syntaxdevteam/cleanerx/common/UpdateChecker;", "wordFilter", "Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "getWordFilter", "()Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "fullCensorship", "", "swearCounter", "Lpl/syntaxdevteam/cleanerx/base/SwearCounter;", "commandManager", "Lpl/syntaxdevteam/cleanerx/commands/CommandManager;", "configHandler", "Lpl/syntaxdevteam/cleanerx/common/ConfigHandler;", "uuidManager", "Lpl/syntaxdevteam/cleanerx/common/UUIDManager;", "getUuidManager", "()Lpl/syntaxdevteam/cleanerx/common/UUIDManager;", "value", "Lpl/syntaxdevteam/cleanerx/api/CleanerXAPI;", "api", "getApi", "()Lpl/syntaxdevteam/cleanerx/api/CleanerXAPI;", "onEnable", "", "setupConfig", "setupHandlers", "registerCommands", "registerEvents", "checkForUpdates", "restartMyTask", "updateCleanerX", "getPluginFile", "Ljava/io/File;", "onDisable", "resetAllSwearCounts", "CleanerX-Spigot"})
public final class CleanerX
extends JavaPlugin
implements Listener {
    @NotNull
    private final FileConfiguration config;
    @NotNull
    private Logger logger;
    public PluginManager pluginsManager;
    private StatsCollector statsCollector;
    public MessageHandler messageHandler;
    private UpdateChecker updateChecker;
    @NotNull
    private final WordFilter wordFilter;
    private final boolean fullCensorship;
    @NotNull
    private final SwearCounter swearCounter;
    private CommandManager commandManager;
    @NotNull
    private ConfigHandler configHandler;
    @NotNull
    private final UUIDManager uuidManager;
    private CleanerXAPI api;

    public CleanerX() {
        FileConfiguration fileConfiguration = this.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.config = fileConfiguration;
        this.logger = new Logger(this, this.config.getBoolean("debug"));
        this.wordFilter = new WordFilter(this);
        this.fullCensorship = this.config.getBoolean("fullCensorship");
        this.swearCounter = new SwearCounter(this);
        this.configHandler = new ConfigHandler(this);
        this.uuidManager = new UUIDManager(this);
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(logger, "<set-?>");
        this.logger = logger;
    }

    @NotNull
    public final PluginManager getPluginsManager() {
        PluginManager pluginManager = this.pluginsManager;
        if (pluginManager != null) {
            return pluginManager;
        }
        Intrinsics.throwUninitializedPropertyAccessException("pluginsManager");
        return null;
    }

    public final void setPluginsManager(@NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter(pluginManager, "<set-?>");
        this.pluginsManager = pluginManager;
    }

    @NotNull
    public final MessageHandler getMessageHandler() {
        MessageHandler messageHandler = this.messageHandler;
        if (messageHandler != null) {
            return messageHandler;
        }
        Intrinsics.throwUninitializedPropertyAccessException("messageHandler");
        return null;
    }

    public final void setMessageHandler(@NotNull MessageHandler messageHandler) {
        Intrinsics.checkNotNullParameter(messageHandler, "<set-?>");
        this.messageHandler = messageHandler;
    }

    @NotNull
    public final WordFilter getWordFilter() {
        return this.wordFilter;
    }

    @NotNull
    public final UUIDManager getUuidManager() {
        return this.uuidManager;
    }

    @NotNull
    public final CleanerXAPI getApi() {
        CleanerXAPI cleanerXAPI = this.api;
        if (cleanerXAPI != null) {
            return cleanerXAPI;
        }
        Intrinsics.throwUninitializedPropertyAccessException("api");
        return null;
    }

    public void onEnable() {
        this.setupConfig();
        this.setupHandlers();
        this.registerEvents();
        this.registerCommands();
        this.checkForUpdates();
        this.registerCommands();
        this.resetAllSwearCounts();
        this.api = new CleanerXApiImpl(this);
        this.getServer().getServicesManager().register(CleanerXAPI.class, (Object)this.getApi(), (Plugin)this, ServicePriority.Normal);
    }

    private final void setupConfig() {
        this.saveDefaultConfig();
        this.configHandler.verifyAndUpdateConfig();
    }

    private final void setupHandlers() {
        this.setMessageHandler(new MessageHandler(this));
        this.setPluginsManager(new PluginManager(this));
    }

    private final void registerCommands() {
        this.commandManager = new CommandManager(this);
        CommandManager commandManager = this.commandManager;
        if (commandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            commandManager = null;
        }
        commandManager.registerCommands();
    }

    private final void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new CleanerXChat(this, this.wordFilter, this.fullCensorship, this.swearCounter), (Plugin)this);
    }

    private final void checkForUpdates() {
        this.statsCollector = new StatsCollector(this);
        this.updateChecker = new UpdateChecker(this);
        UpdateChecker updateChecker = this.updateChecker;
        if (updateChecker == null) {
            Intrinsics.throwUninitializedPropertyAccessException("updateChecker");
            updateChecker = null;
        }
        updateChecker.checkForUpdates();
    }

    public final void restartMyTask() {
        this.reloadConfig();
        try {
            this.getMessageHandler().reloadMessages();
        }
        catch (Exception e) {
            this.logger.err(MessageHandler.getMessage$default(this.getMessageHandler(), "error", "reload", null, 4, null) + " " + e.getMessage());
        }
        try {
        }
        catch (Exception e) {
            this.logger.err("An error occurred while reloading the configuration: " + e.getMessage());
        }
        try {
            this.updateCleanerX();
        }
        catch (Exception ee) {
            this.logger.err("An error occurred while reloading the configuration: " + ee.getMessage());
        }
    }

    private final void updateCleanerX() {
        this.getServer().getPluginManager().registerEvents((Listener)new CleanerXChat(this, this.wordFilter, this.fullCensorship, this.swearCounter), (Plugin)this);
        this.resetAllSwearCounts();
    }

    @NotNull
    public final File getPluginFile() {
        File file = this.getFile();
        Intrinsics.checkNotNullExpressionValue(file, "getFile(...)");
        return file;
    }

    public void onDisable() {
        this.resetAllSwearCounts();
        CommandManager commandManager = this.commandManager;
        if (commandManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException("commandManager");
            commandManager = null;
        }
        commandManager.shutdown();
        this.logger.err(this.getDescription().getName() + " " + this.getDescription().getVersion() + " has been disabled \u2639\ufe0f");
    }

    private final void resetAllSwearCounts() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            Intrinsics.checkNotNull(player);
            this.swearCounter.resetSwearCount(player);
        }
    }
}

