/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.commands;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lpl/syntaxdevteam/cleanerx/commands/CleanerXCommand;", "Lorg/bukkit/command/CommandExecutor;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "audiences", "Lnet/kyori/adventure/platform/bukkit/BukkitAudiences;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Lnet/kyori/adventure/platform/bukkit/BukkitAudiences;)V", "mH", "Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "pdf", "Lorg/bukkit/plugin/PluginDescriptionFile;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "CleanerX-Spigot"})
public final class CleanerXCommand
implements CommandExecutor {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final BukkitAudiences audiences;
    @NotNull
    private final MessageHandler mH;
    @NotNull
    private final PluginDescriptionFile pdf;

    public CleanerXCommand(@NotNull CleanerX plugin, @NotNull BukkitAudiences audiences) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(audiences, "audiences");
        this.plugin = plugin;
        this.audiences = audiences;
        this.mH = this.plugin.getMessageHandler();
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue(pluginDescriptionFile, "getDescription(...)");
        this.pdf = pluginDescriptionFile;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        Audience audience = this.audiences.sender(sender);
        Intrinsics.checkNotNullExpressionValue(audience, "sender(...)");
        Audience audience2 = audience;
        if (!sender.hasPermission("cleanerx.cmd.crx")) {
            audience2.sendMessage(MessageHandler.getMessage$default(this.mH, "error", "no_permission", null, 4, null));
            return true;
        }
        if (args.length == 0) {
            audience2.sendMessage(MessageHandler.getMessage$default(this.mH, "error", "unknown_command", null, 4, null));
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "help": {
                audience2.sendMessage(this.mH.miniMessageFormat(StringsKt.trimIndent("\n                <gray>+-------------------------------------------------\n                |  \n                |  <gold>Available commands for " + this.pdf.getName() + ":\n                <gray>|\n                |  <gold>/crx help <gray>- <white>Displays this prompt.\n                <gray>|  <gold>/blacklistx <add/remove/list> <word> \n                <gray>|                      <gray>- <white>Adds a word to the blacklist.\n                <gray>|  <gold>/whitelistx <add/remove/list> <word> \n                <gray>|                      <gray>- <white>Adds a word to the whitelist.\n                <gray>|  <gold>/cleanx <gray>- <white>Clears the chat window.\n                <gray>|  <gold>/crx version <gray>- <white>Shows plugin info. \n                <gray>|  <gold>/crx reload <gray>- <white>Reloads the configuration file\n                |\n                <gray>+-------------------------------------------------\n            ")));
                break;
            }
            case "version": {
                String string2 = this.pdf.getName();
                List list = this.pdf.getAuthors();
                Intrinsics.checkNotNullExpressionValue(list, "getAuthors(...)");
                audience2.sendMessage(this.mH.miniMessageFormat(StringsKt.trimIndent("\n                <gray>-------------------------------------------------\n                <gray>|\n                <gray>|   <gold>\u2192 <bold>" + string2 + "</bold> \u2190\n                <gray>|   <white>Author: <bold><gold>" + CollectionsKt.joinToString$default(list, null, null, null, 0, null, null, 63, null) + "</gold></bold>\n                <gray>|   <white>Website: <bold><gold><click:open_url:'" + this.pdf.getWebsite() + "'>" + this.pdf.getWebsite() + "</click></gold></bold>\n                <gray>|   <white>Version: <bold><gold>" + this.pdf.getVersion() + "</gold></bold>\n                <gray>|\n                <gray>-------------------------------------------------\n            ")));
                break;
            }
            case "reload": {
                this.plugin.restartMyTask();
                audience2.sendMessage(MessageHandler.getMessage$default(this.mH, "reload", "success", null, 4, null));
                break;
            }
            default: {
                audience2.sendMessage(MessageHandler.getMessage$default(this.mH, "error", "unknown_command", null, 4, null));
            }
        }
        return true;
    }
}

