/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.eventhandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.base.SwearCounter;
import pl.syntaxdevteam.cleanerx.base.WordFilter;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lpl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "wordFilter", "Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "fullCensorship", "", "swearCounter", "Lpl/syntaxdevteam/cleanerx/base/SwearCounter;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Lpl/syntaxdevteam/cleanerx/base/WordFilter;ZLpl/syntaxdevteam/cleanerx/base/SwearCounter;)V", "linkRegex", "Lkotlin/text/Regex;", "blockLinks", "usePunishment", "onChat", "", "event", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "CleanerX-Spigot"})
public final class CleanerXChat
implements Listener {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final WordFilter wordFilter;
    private final boolean fullCensorship;
    @NotNull
    private final SwearCounter swearCounter;
    @NotNull
    private final Regex linkRegex;
    private final boolean blockLinks;
    private final boolean usePunishment;

    public CleanerXChat(@NotNull CleanerX plugin, @NotNull WordFilter wordFilter, boolean fullCensorship, @NotNull SwearCounter swearCounter) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(wordFilter, "wordFilter");
        Intrinsics.checkNotNullParameter(swearCounter, "swearCounter");
        this.plugin = plugin;
        this.wordFilter = wordFilter;
        this.fullCensorship = fullCensorship;
        this.swearCounter = swearCounter;
        this.linkRegex = new Regex("(https?://\\S+|www\\.\\S+|\\b\\w+\\.(com|net|org|pl|co|gov|edu|info|biz|ru|uk|us|de|fr|cn|es|it|au|nl|ca|in|jp|se|ch|br|za|pt|tv|me|xyz|tech|online|store|site|live|app|io|ai|dev|ly|digital|agency|solutions|global|world|studio|cloud|media|network|works)\\b)");
        this.blockLinks = this.plugin.getConfig().getBoolean("block-links", false);
        this.usePunishment = this.plugin.getConfig().getBoolean("use-punishment", false);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            String string = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
            String message = string;
            if (this.blockLinks && this.linkRegex.containsMatchIn(message)) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), "error", "no_link", null, 4, null));
                return;
            }
            int swearWordCount = 0;
            CharSequence charSequence = message;
            Regex regex = new Regex("\\s+");
            int n = 0;
            List<String> words = regex.split(charSequence, n);
            for (String word : words) {
                if (!this.wordFilter.containsBannedWord(word)) continue;
                ++swearWordCount;
            }
            if (swearWordCount > 0) {
                message = this.wordFilter.censorMessage(message, this.fullCensorship);
                event.setMessage(message);
                if (this.usePunishment) {
                    Player player = event.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                    this.swearCounter.incrementSwearCount(player, swearWordCount);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Critical error! Send a message to the plugin author with the subject \"Error in onChat\" and the content: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

