/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.base;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.util.SchedulerAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\t\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/cleanerx/base/SwearCounter;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "playerSwearCounts", "", "Lorg/bukkit/entity/Player;", "", "thresholds", "", "", "Lorg/jetbrains/annotations/Nullable;", "incrementSwearCount", "", "player", "swearCount", "resetSwearCount", "CleanerX-Paper"})
@SourceDebugExtension(value={"SMAP\nSwearCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwearCounter.kt\npl/syntaxdevteam/cleanerx/base/SwearCounter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,53:1\n1222#2,2:54\n1252#2,4:56\n216#3,2:60\n*S KotlinDebug\n*F\n+ 1 SwearCounter.kt\npl/syntaxdevteam/cleanerx/base/SwearCounter\n*L\n17#1:54,2\n17#1:56,4\n31#1:60,2\n*E\n"})
public final class SwearCounter {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final Map<Player, Integer> playerSwearCounts;
    @NotNull
    private final Map<Integer, String> thresholds;

    /*
     * WARNING - void declaration
     */
    public SwearCounter(@NotNull CleanerX plugin) {
        Map map;
        Set set;
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.playerSwearCounts = new LinkedHashMap();
        SwearCounter swearCounter = this;
        ConfigurationSection configurationSection = this.plugin.getConfig().getConfigurationSection("swear-word-thresholds");
        if (configurationSection != null && (set = configurationSection.getKeys(false)) != null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = set;
            SwearCounter swearCounter2 = swearCounter;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            void var7_8 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                String string;
                String it;
                String string2 = (String)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                it = (String)element$iv$iv;
                Integer n = Integer.parseInt(it);
                boolean bl2 = false;
                Intrinsics.checkNotNull(this.plugin.getConfig().getString("swear-word-thresholds." + it));
                map2.put(n, string);
            }
            map = destination$iv$iv;
            swearCounter = swearCounter2;
        } else {
            map = MapsKt.emptyMap();
        }
        swearCounter.thresholds = map;
    }

    public final void incrementSwearCount(@NotNull Player player, int swearCount) {
        Intrinsics.checkNotNullParameter(player, "player");
        int count = ((Number)this.playerSwearCounts.getOrDefault(player, 0)).intValue() + swearCount;
        this.playerSwearCounts.put(player, count);
        Map<Integer, String> $this$forEach$iv = this.thresholds;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Integer, String> element$iv;
            Map.Entry<Integer, String> entry = element$iv = iterator2.next();
            boolean bl = false;
            int threshold = ((Number)entry.getKey()).intValue();
            String command = entry.getValue();
            if (count != threshold) continue;
            String string = player.getName();
            Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
            String formattedCommand = StringsKt.replace$default(command, "{player}", string, false, 4, null);
            SchedulerAdapter.INSTANCE.runSync(this.plugin, () -> SwearCounter.incrementSwearCount$lambda$0$0(this, formattedCommand));
        }
    }

    public final void resetSwearCount(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        this.plugin.getLogger().debug("The words counted have been reset");
        this.playerSwearCounts.remove(player);
    }

    private static final Unit incrementSwearCount$lambda$0$0(SwearCounter this$0, String $formattedCommand) {
        this$0.plugin.getLogger().debug("Attempting to send command: " + $formattedCommand);
        this$0.plugin.getServer().dispatchCommand((CommandSender)this$0.plugin.getServer().getConsoleSender(), $formattedCommand);
        return Unit.INSTANCE;
    }
}

