/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.eventhandler;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.base.SwearCounter;
import pl.syntaxdevteam.cleanerx.base.WordFilter;
import pl.syntaxdevteam.cleanerx.eventhandler.RegexUrlDetector;
import pl.syntaxdevteam.cleanerx.eventhandler.UriUrlDetector;
import pl.syntaxdevteam.cleanerx.eventhandler.UrlDetector;
import pl.syntaxdevteam.message.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "wordFilter", "Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "fullCensorship", "", "swearCounter", "Lpl/syntaxdevteam/cleanerx/base/SwearCounter;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Lpl/syntaxdevteam/cleanerx/base/WordFilter;ZLpl/syntaxdevteam/cleanerx/base/SwearCounter;)V", "blockLinks", "usePunishment", "urlDetectors", "", "Lpl/syntaxdevteam/cleanerx/eventhandler/UrlDetector;", "onChat", "", "event", "Lio/papermc/paper/event/player/AsyncChatEvent;", "CleanerX-Paper"})
@SourceDebugExtension(value={"SMAP\nCleanerXChat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanerXChat.kt\npl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1761#2,3:69\n1788#2,4:72\n*S KotlinDebug\n*F\n+ 1 CleanerXChat.kt\npl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat\n*L\n41#1:69,3\n51#1:72,4\n*E\n"})
public final class CleanerXChat
implements Listener {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final WordFilter wordFilter;
    private final boolean fullCensorship;
    @NotNull
    private final SwearCounter swearCounter;
    private final boolean blockLinks;
    private final boolean usePunishment;
    @NotNull
    private final List<UrlDetector> urlDetectors;

    public CleanerXChat(@NotNull CleanerX plugin, @NotNull WordFilter wordFilter, boolean fullCensorship, @NotNull SwearCounter swearCounter) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(wordFilter, "wordFilter");
        Intrinsics.checkNotNullParameter(swearCounter, "swearCounter");
        this.plugin = plugin;
        this.wordFilter = wordFilter;
        this.fullCensorship = fullCensorship;
        this.swearCounter = swearCounter;
        this.blockLinks = this.plugin.getConfig().getBoolean("block-links", true);
        this.usePunishment = this.plugin.getConfig().getBoolean("use-punishment", false);
        UrlDetector[] urlDetectorArray = new UrlDetector[]{new UriUrlDetector(), new RegexUrlDetector()};
        this.urlDetectors = CollectionsKt.listOf(urlDetectorArray);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onChat(@NotNull AsyncChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            int swearCount;
            MessageHandler messageHandler = this.plugin.getMessageHandler();
            Component component = event.originalMessage();
            Intrinsics.checkNotNullExpressionValue(component, "originalMessage(...)");
            String message = messageHandler.getPlainText(component);
            if (this.blockLinks) {
                boolean bl;
                block12: {
                    Iterable $this$any$iv = this.urlDetectors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UrlDetector it = (UrlDetector)element$iv;
                            boolean bl2 = false;
                            if (!it.containsUrl(message)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    event.setCancelled(true);
                    event.getPlayer().sendMessage(MessageHandler.stringMessageToComponent$default((MessageHandler)this.plugin.getMessageHandler(), (String)"error", (String)"no-link", null, (int)4, null));
                    return;
                }
            }
            CharSequence $i$f$any = message;
            Regex regex = new Regex("\\s+");
            int element$iv = 0;
            List<String> words = regex.split($i$f$any, element$iv);
            Iterable $this$count$iv = words;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    if (!this.wordFilter.containsBannedWord(it) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v3 = swearCount = count$iv;
            }
            if (swearCount > 0) {
                event.message((Component)Component.text((String)this.wordFilter.censorMessage(message, this.fullCensorship)));
                if (this.usePunishment) {
                    Player player = event.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                    this.swearCounter.incrementSwearCount(player, swearCount);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Critical error in onChat: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

