/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.loader;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.api.CleanerXAPI;
import pl.syntaxdevteam.cleanerx.api.CleanerXApiImpl;
import pl.syntaxdevteam.cleanerx.base.SwearCounter;
import pl.syntaxdevteam.cleanerx.base.WordFilter;
import pl.syntaxdevteam.cleanerx.commands.CommandManager;
import pl.syntaxdevteam.cleanerx.common.BannedWordsSynchronizer;
import pl.syntaxdevteam.cleanerx.common.ConfigHandler;
import pl.syntaxdevteam.cleanerx.eventhandler.CleanerXChat;
import pl.syntaxdevteam.cleanerx.eventhandler.PlayerJoinListener;
import pl.syntaxdevteam.cleanerx.loader.VersionChecker;
import pl.syntaxdevteam.core.SyntaxCore;
import pl.syntaxdevteam.message.SyntaxMessages;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0006\u0010\r\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/syntaxdevteam/cleanerx/loader/PluginInitializer;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "onEnable", "", "onDisable", "setUpLogger", "setupConfig", "setupHandlers", "registerCommands", "registerEvents", "checkForUpdates", "resetAllSwearCounts", "CleanerX-Paper"})
public final class PluginInitializer {
    @NotNull
    private final CleanerX plugin;

    public PluginInitializer(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    public final void onEnable() {
        this.setUpLogger();
        this.setupConfig();
        this.setupHandlers();
        this.registerEvents();
        this.registerCommands();
        this.checkForUpdates();
    }

    public final void onDisable() {
        this.plugin.getLogger().err(this.plugin.getPluginMeta().getName() + " " + this.plugin.getPluginMeta().getVersion() + " has been disabled \u2639\ufe0f");
    }

    private final void setUpLogger() {
        FileConfiguration fileConfiguration = this.plugin.getConfig();
        Intrinsics.checkNotNullExpressionValue(fileConfiguration, "getConfig(...)");
        this.plugin.setPluginConfig(fileConfiguration);
        this.plugin.setLogger(SyntaxCore.INSTANCE.getLogger());
    }

    private final void setupConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.setConfigHandler(new ConfigHandler(this.plugin));
        this.plugin.getConfigHandler().verifyAndUpdateConfig();
    }

    private final void setupHandlers() {
        SyntaxMessages.initialize$default((JavaPlugin)this.plugin, null, (int)2, null);
        this.plugin.setMessageHandler(SyntaxMessages.INSTANCE.getMessages());
        this.plugin.setPluginsManager(SyntaxCore.INSTANCE.getPluginManagerx());
        this.plugin.setVersionChecker(new VersionChecker(this.plugin));
        this.plugin.setWordFilter(new WordFilter(this.plugin));
        this.plugin.setSwearCounter(new SwearCounter(this.plugin));
        this.plugin.setBannedWordsSynchronizer(new BannedWordsSynchronizer(this.plugin));
        this.plugin.getBannedWordsSynchronizer().synchronize(arg_0 -> PluginInitializer.setupHandlers$lambda$0(this, arg_0));
    }

    private final void registerCommands() {
        this.plugin.setCommandManager(new CommandManager(this.plugin));
        this.plugin.getCommandManager().registerCommands();
    }

    public final void registerEvents() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new CleanerXChat(this.plugin, this.plugin.getWordFilter(), this.plugin.getConfig().getBoolean("fullCensorship"), this.plugin.getSwearCounter()), (Plugin)this.plugin);
        this.resetAllSwearCounts();
        this.plugin.setApi(new CleanerXApiImpl(this.plugin));
        this.plugin.getServer().getServicesManager().register(CleanerXAPI.class, (Object)this.plugin.getApi(), (Plugin)this.plugin, ServicePriority.Normal);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.plugin), (Plugin)this.plugin);
    }

    private final void checkForUpdates() {
        this.plugin.setStatsCollector(SyntaxCore.INSTANCE.getStatsCollector());
        SyntaxCore.INSTANCE.getUpdateChecker().checkAsync();
    }

    public final void resetAllSwearCounts() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            SwearCounter swearCounter = this.plugin.getSwearCounter();
            Intrinsics.checkNotNull(player);
            swearCounter.resetSwearCount(player);
        }
    }

    private static final Unit setupHandlers$lambda$0(PluginInitializer this$0, List words) {
        Intrinsics.checkNotNullParameter(words, "words");
        this$0.plugin.getWordFilter().updateBannedWords(words);
        return Unit.INSTANCE;
    }
}

