/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.base;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\bJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J\b\u0010\u001a\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "bannedWords", "", "", "whitelistWords", "loadBannedWords", "", "loadWhitelistWords", "containsBannedWord", "", "message", "censorMessage", "fullCensorship", "addBannedWord", "word", "removeBannedWord", "addWhitelistWord", "removeWhitelistWord", "getBannedWords", "", "getWhitelistWords", "saveBannedWords", "saveWhitelistWords", "CleanerX-Paper"})
@SourceDebugExtension(value={"SMAP\nWordFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordFilter.kt\npl/syntaxdevteam/cleanerx/base/WordFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,185:1\n1563#2:186\n1634#2,3:187\n1563#2:190\n1634#2,3:191\n1761#2,3:194\n*S KotlinDebug\n*F\n+ 1 WordFilter.kt\npl/syntaxdevteam/cleanerx/base/WordFilter\n*L\n37#1:186\n37#1:187,3\n50#1:190\n50#1:191,3\n61#1:194,3\n*E\n"})
public final class WordFilter {
    @NotNull
    private final JavaPlugin plugin;
    @NotNull
    private List<String> bannedWords;
    @NotNull
    private List<String> whitelistWords;

    public WordFilter(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        this.plugin = plugin;
        this.bannedWords = new ArrayList();
        this.whitelistWords = new ArrayList();
        this.loadBannedWords();
        this.loadWhitelistWords();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadBannedWords() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File file = new File(this.plugin.getDataFolder(), "banned_words.yml");
        if (!file.exists()) {
            this.plugin.saveResource("banned_words.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        List list = config.getStringList("bannedWords");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        WordFilter wordFilter = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            void var12_13 = it;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = var12_13.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            collection.add(string2);
        }
        wordFilter.bannedWords = CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadWhitelistWords() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File file = new File(this.plugin.getDataFolder(), "whitelist_words.yml");
        if (!file.exists()) {
            this.plugin.saveResource("whitelist_words.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        List list = config.getStringList("whitelistWords");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        WordFilter wordFilter = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            void var12_13 = it;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
            String string2 = var12_13.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            collection.add(string2);
        }
        wordFilter.whitelistWords = CollectionsKt.toMutableList((List)destination$iv$iv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsBannedWord(@NotNull String message) {
        boolean bl;
        Intrinsics.checkNotNullParameter(message, "message");
        String string = message;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerMessage = string2;
        Iterable $this$any$iv = this.bannedWords;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (StringsKt.contains$default((CharSequence)lowerMessage, it, false, 2, null)) {
                String word;
                Iterable $this$any$iv2 = this.whitelistWords;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    return true;
                }
                Iterator iterator3 = $this$any$iv2.iterator();
                do {
                    if (!iterator3.hasNext()) return true;
                    Object element$iv2 = iterator3.next();
                    word = (String)element$iv2;
                    boolean bl3 = false;
                } while (!StringsKt.contains$default((CharSequence)lowerMessage, word, false, 2, null));
                boolean bl4 = true;
                if (!bl4) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @NotNull
    public final String censorMessage(@NotNull String message, boolean fullCensorship) {
        Intrinsics.checkNotNullParameter(message, "message");
        CharSequence charSequence = message;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List words = CollectionsKt.toMutableList((Collection)regex.split(charSequence, n));
        int n2 = ((Collection)words).size();
        for (int i = 0; i < n2; ++i) {
            for (String bannedWord : this.bannedWords) {
                Object object;
                String string = (String)words.get(i);
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)string2, bannedWord, false, 2, null)) continue;
                string = (String)words.get(i);
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
                if (this.whitelistWords.contains(string3)) continue;
                if (fullCensorship) {
                    object = StringsKt.repeat("*", ((String)words.get(i)).length());
                } else {
                    String string4 = ((String)words.get(i)).substring(0, 2);
                    Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                    object = string4 + StringsKt.repeat("*", ((String)words.get(i)).length() - 2);
                }
                String replacement = object;
                words.set(i, replacement);
            }
        }
        return CollectionsKt.joinToString$default(words, " ", null, null, 0, null, null, 62, null);
    }

    public final void addBannedWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (!this.bannedWords.contains(lowerWord)) {
            this.bannedWords.add(lowerWord);
            this.saveBannedWords();
            this.plugin.getLogger().info("Word " + word + " added to banned words list.");
        }
    }

    public final boolean removeBannedWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (this.bannedWords.contains(lowerWord)) {
            this.bannedWords.remove(lowerWord);
            this.saveBannedWords();
            this.plugin.getLogger().info("Word " + word + " removed from banned words list.");
            return true;
        }
        this.plugin.getLogger().warning("Word " + word + " not found in banned words list.");
        return false;
    }

    public final void addWhitelistWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (!this.whitelistWords.contains(lowerWord)) {
            this.whitelistWords.add(lowerWord);
            this.saveWhitelistWords();
            this.plugin.getLogger().info("Word " + word + " added to whitelist.");
        }
    }

    public final boolean removeWhitelistWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (this.whitelistWords.contains(lowerWord)) {
            this.whitelistWords.remove(lowerWord);
            this.saveWhitelistWords();
            this.plugin.getLogger().info("Word " + word + " removed from whitelist.");
            return true;
        }
        this.plugin.getLogger().warning("Word " + word + " not found in whitelist.");
        return false;
    }

    @NotNull
    public final List<String> getBannedWords() {
        return this.bannedWords;
    }

    @NotNull
    public final List<String> getWhitelistWords() {
        return this.whitelistWords;
    }

    private final void saveBannedWords() {
        File file = new File(this.plugin.getDataFolder(), "banned_words.yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("bannedWords", this.bannedWords);
        config.save(file);
    }

    private final void saveWhitelistWords() {
        File file = new File(this.plugin.getDataFolder(), "whitelist_words.yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("whitelistWords", this.whitelistWords);
        config.save(file);
    }
}

