/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/cleanerx/commands/WhiteListCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "mH", "Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "CleanerX-Paper"})
public final class WhiteListCommand
implements BasicCommand {
    @NotNull
    private CleanerX plugin;
    @NotNull
    private final MessageHandler mH;

    public WhiteListCommand(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mH = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!stack.getSender().hasPermission("cleanerx.cmd.whitelist")) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "error", "no_permission", null, 4, null));
            return;
        }
        if (args.length == 0) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "whitelist", "usage", null, 4, null));
            return;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "add": {
                if (args.length > 1) {
                    String newWord = args[1];
                    this.plugin.getWordFilter().addWhitelistWord(newWord);
                    this.plugin.restartMyTask();
                    stack.getSender().sendMessage(this.mH.getMessage("word", "word_added", MapsKt.mapOf(TuplesKt.to("word", newWord))));
                    break;
                }
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "word", "no_word_provided", null, 4, null));
                break;
            }
            case "remove": {
                if (args.length > 1) {
                    String wordToRemove = args[1];
                    if (this.plugin.getWordFilter().removeWhitelistWord(wordToRemove)) {
                        this.plugin.restartMyTask();
                        stack.getSender().sendMessage(this.mH.getMessage("word", "word_removed", MapsKt.mapOf(TuplesKt.to("word", wordToRemove))));
                        break;
                    }
                    stack.getSender().sendMessage(this.mH.getMessage("word", "word_not_found", MapsKt.mapOf(TuplesKt.to("word", wordToRemove))));
                    break;
                }
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "word", "no_word_provided", null, 4, null));
                break;
            }
            case "list": {
                List<String> whitelistWords = this.plugin.getWordFilter().getWhitelistWords();
                String formattedList = CollectionsKt.joinToString$default(whitelistWords, ", ", null, null, 0, null, null, 62, null);
                stack.getSender().sendMessage(this.mH.miniMessageFormat(this.mH.getPrefix() + " <green>Whitelist words: <white>" + formattedList));
                break;
            }
            default: {
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.plugin.getMessageHandler(), "word", "usage", null, 4, null));
            }
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List<String> list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!stack.getSender().hasPermission("cleanerx.cmd.whitelist")) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            String[] stringArray = new String[]{"list", "add", "remove"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

