/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.base;

import java.io.File;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.cleanerx.CleanerX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 22\u00020\u0001:\u0003012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\bJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0014\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\b\u0010\u001f\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u000fH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\bH\u0002J\u0010\u0010%\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000b2\u0006\u0010*\u001a\u00020'H\u0002J\u001e\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020)0\u000bH\u0002J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "bannedWords", "", "", "whitelistWords", "bannedPatterns", "", "Lpl/syntaxdevteam/cleanerx/base/WordFilter$FilterPattern;", "whitelistPatterns", "loadBannedWords", "", "loadWhitelistWords", "containsBannedWord", "", "message", "censorMessage", "fullCensorship", "addBannedWord", "word", "removeBannedWord", "addWhitelistWord", "removeWhitelistWord", "getBannedWords", "updateBannedWords", "words", "getWhitelistWords", "saveBannedWords", "saveWhitelistWords", "toFilterPattern", "buildFuzzyRegex", "Lkotlin/text/Regex;", "normalizedWord", "normalizeWord", "buildNormalizedMessage", "Lpl/syntaxdevteam/cleanerx/base/WordFilter$NormalizedMessage;", "collectWhitelistRanges", "Lkotlin/ranges/IntRange;", "normalizedMessage", "isRangeWhitelisted", "range", "whitelistedRanges", "stripDiacritics", "value", "FilterPattern", "NormalizedMessage", "Companion", "CleanerX-Spigot"})
@SourceDebugExtension(value={"SMAP\nWordFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WordFilter.kt\npl/syntaxdevteam/cleanerx/base/WordFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,435:1\n1563#2:436\n1634#2,3:437\n1617#2,9:440\n1869#2:449\n1870#2:451\n1626#2:452\n1374#2:453\n1460#2,5:454\n1869#2,2:459\n1869#2,2:461\n1617#2,9:463\n1869#2:472\n1870#2:474\n1626#2:475\n1617#2,9:476\n1869#2:485\n1870#2:487\n1626#2:488\n1563#2:489\n1634#2,3:490\n1617#2,9:493\n1869#2:502\n1870#2:504\n1626#2:505\n1011#2,2:524\n1761#2,3:526\n1#3:450\n1#3:473\n1#3:486\n1#3:503\n1188#4,3:506\n1179#4:509\n1179#4:510\n1179#4,2:511\n1180#4:513\n1180#4:514\n1188#4,2:515\n1179#4:517\n1179#4,2:518\n1180#4:520\n1190#4:521\n1321#5,2:522\n*S KotlinDebug\n*F\n+ 1 WordFilter.kt\npl/syntaxdevteam/cleanerx/base/WordFilter\n*L\n53#1:436\n53#1:437,3\n55#1:440,9\n55#1:449\n55#1:451\n55#1:452\n108#1:453\n108#1:454,5\n119#1:459,2\n126#1:461,2\n152#1:463,9\n152#1:472\n152#1:474\n152#1:475\n185#1:476,9\n185#1:485\n185#1:487\n185#1:488\n225#1:489\n225#1:490,3\n227#1:493,9\n227#1:502\n227#1:504\n227#1:505\n343#1:524,2\n364#1:526,3\n55#1:450\n152#1:473\n185#1:486\n227#1:503\n271#1:506,3\n287#1:509\n289#1:510\n291#1:511,2\n289#1:513\n287#1:514\n306#1:515,2\n309#1:517\n314#1:518,2\n309#1:520\n306#1:521\n336#1:522,2\n*E\n"})
public final class WordFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private List<String> bannedWords;
    @NotNull
    private List<String> whitelistWords;
    @NotNull
    private List<FilterPattern> bannedPatterns;
    @NotNull
    private List<FilterPattern> whitelistPatterns;
    @NotNull
    private static final Regex NON_SPACING_MARKS_REGEX = new Regex("\\p{Mn}+");
    @NotNull
    private static final Map<Character, String> CHARACTER_REPLACEMENTS;

    public WordFilter(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.bannedWords = new ArrayList();
        this.whitelistWords = new ArrayList();
        this.bannedPatterns = CollectionsKt.emptyList();
        this.whitelistPatterns = CollectionsKt.emptyList();
        this.loadBannedWords();
        this.loadWhitelistWords();
    }

    private final void loadBannedWords() {
        File file = new File(this.plugin.getDataFolder(), "banned_words.yml");
        if (!file.exists()) {
            this.plugin.saveResource("banned_words.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        List list = config.getStringList("bannedWords");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        this.updateBannedWords(list);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadWhitelistWords() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        File file = new File(this.plugin.getDataFolder(), "whitelist_words.yml");
        if (!file.exists()) {
            this.plugin.saveResource("whitelist_words.yml", false);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration config = yamlConfiguration;
        List list = config.getStringList("whitelistWords");
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        Iterable iterable = list;
        WordFilter wordFilter = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            void var12_15 = it;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
            String string = var12_15.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add(string);
        }
        wordFilter.whitelistWords = CollectionsKt.toMutableList((List)destination$iv$iv);
        $this$map$iv = this.whitelistWords;
        wordFilter = this;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            FilterPattern it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.toFilterPattern(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        wordFilter.whitelistPatterns = (List)destination$iv$iv;
    }

    public final boolean containsBannedWord(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (StringsKt.isBlank(message) || this.bannedPatterns.isEmpty()) {
            return false;
        }
        NormalizedMessage normalizedMessage = this.buildNormalizedMessage(message);
        List<IntRange> whitelistedRanges = this.collectWhitelistRanges(normalizedMessage);
        for (FilterPattern pattern : this.bannedPatterns) {
            Sequence matches = Regex.findAll$default(pattern.getPattern(), normalizedMessage.getNormalized(), 0, 2, null);
            Iterator iterator2 = matches.iterator();
            while (iterator2.hasNext()) {
                MatchResult match = (MatchResult)iterator2.next();
                if (this.isRangeWhitelisted(match.getRange(), whitelistedRanges)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String censorMessage(@NotNull String message, boolean fullCensorship) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (((CharSequence)message).length() == 0 || this.bannedPatterns.isEmpty()) {
            return message;
        }
        NormalizedMessage normalizedMessage = this.buildNormalizedMessage(message);
        List<IntRange> whitelistedRanges = this.collectWhitelistRanges(normalizedMessage);
        char[] cArray = message.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        char[] chars = cArray;
        for (FilterPattern pattern : this.bannedPatterns) {
            Sequence matches = Regex.findAll$default(pattern.getPattern(), normalizedMessage.getNormalized(), 0, 2, null);
            Iterator iterator2 = matches.iterator();
            while (iterator2.hasNext()) {
                int element$iv$iv;
                Iterator $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                MatchResult match = (MatchResult)iterator2.next();
                if (this.isRangeWhitelisted(match.getRange(), whitelistedRanges)) continue;
                Iterable iterable = match.getRange();
                boolean $i$f$flatMap = false;
                void var14_16 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator3 = $this$flatMapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    Integer originalIndex;
                    int normalizedIndex = element$iv$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl = false;
                    Integer n = originalIndex = ArraysKt.getOrNull(normalizedMessage.getIndexMap(), normalizedIndex);
                    Iterable list$iv$iv = n != null ? CollectionsKt.listOf(n) : CollectionsKt.emptyList();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                SortedSet indices = CollectionsKt.toSortedSet((List)destination$iv$iv);
                if (indices.isEmpty()) continue;
                if (fullCensorship) {
                    Iterable $this$forEach$iv = indices;
                    boolean $i$f$forEach = false;
                    $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$flatMapTo$iv$iv.hasNext()) {
                        Object element$iv = $this$flatMapTo$iv$iv.next();
                        Integer index = (Integer)element$iv;
                        boolean bl = false;
                        element$iv$iv = chars.length;
                        Intrinsics.checkNotNull(index);
                        int n = index;
                        boolean bl2 = 0 <= n ? n < element$iv$iv : false;
                        if (!bl2 || CharsKt.isWhitespace(chars[index])) continue;
                        chars[index.intValue()] = 42;
                    }
                    continue;
                }
                int remainingVisible = 0;
                remainingVisible = 2;
                Iterable $this$forEach$iv = indices;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Integer index = (Integer)element$iv;
                    boolean bl = false;
                    int n = chars.length;
                    Intrinsics.checkNotNull(index);
                    int n2 = index;
                    boolean bl3 = 0 <= n2 ? n2 < n : false;
                    if (!bl3 || CharsKt.isWhitespace(chars[index])) continue;
                    if (remainingVisible > 0) {
                        n = remainingVisible;
                        remainingVisible = n + -1;
                        continue;
                    }
                    chars[index.intValue()] = 42;
                }
            }
        }
        return new String(chars);
    }

    /*
     * WARNING - void declaration
     */
    public final void addBannedWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        Object object = word;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String lowerWord = string;
        if (!this.bannedWords.contains(lowerWord)) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            this.bannedWords.add(lowerWord);
            object = this.bannedWords;
            WordFilter wordFilter = this;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FilterPattern it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.toFilterPattern(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            wordFilter.bannedPatterns = (List)destination$iv$iv;
            this.saveBannedWords();
            this.plugin.getLogger().info("Word " + word + " added to banned words list.");
        }
    }

    public final boolean removeBannedWord(@NotNull String word) {
        boolean bl;
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (this.bannedWords.contains(lowerWord)) {
            this.bannedWords.remove(lowerWord);
            this.saveBannedWords();
            this.plugin.getLogger().info("Word " + word + " removed from banned words list.");
            bl = true;
        } else {
            this.plugin.getLogger().warning("Word " + word + " not found in banned words list.");
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void addWhitelistWord(@NotNull String word) {
        Intrinsics.checkNotNullParameter(word, "word");
        Object object = word;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string = ((String)object).toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String lowerWord = string;
        if (!this.whitelistWords.contains(lowerWord)) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            this.whitelistWords.add(lowerWord);
            object = this.whitelistWords;
            WordFilter wordFilter = this;
            boolean $i$f$mapNotNull = false;
            void var5_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FilterPattern it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (this.toFilterPattern(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            wordFilter.whitelistPatterns = (List)destination$iv$iv;
            this.saveWhitelistWords();
            this.plugin.getLogger().info("Word " + word + " added to whitelist.");
        }
    }

    public final boolean removeWhitelistWord(@NotNull String word) {
        boolean bl;
        Intrinsics.checkNotNullParameter(word, "word");
        String string = word;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        String lowerWord = string2;
        if (this.whitelistWords.contains(lowerWord)) {
            this.whitelistWords.remove(lowerWord);
            this.saveWhitelistWords();
            this.plugin.getLogger().info("Word " + word + " removed from whitelist.");
            bl = true;
        } else {
            this.plugin.getLogger().warning("Word " + word + " not found in whitelist.");
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<String> getBannedWords() {
        return this.bannedWords;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateBannedWords(@NotNull List<String> words) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(words, "words");
        Iterable iterable = words;
        WordFilter wordFilter = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var11_14 = it;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
            String string = var11_14.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            collection.add(string);
        }
        wordFilter.bannedWords = CollectionsKt.toMutableList((List)destination$iv$iv);
        $this$map$iv = this.bannedWords;
        wordFilter = this;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            FilterPattern it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this.toFilterPattern(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        wordFilter.bannedPatterns = (List)destination$iv$iv;
    }

    @NotNull
    public final List<String> getWhitelistWords() {
        return this.whitelistWords;
    }

    private final void saveBannedWords() {
        File file = new File(this.plugin.getDataFolder(), "banned_words.yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("bannedWords", this.bannedWords);
        config.save(file);
    }

    private final void saveWhitelistWords() {
        File file = new File(this.plugin.getDataFolder(), "whitelist_words.yml");
        YamlConfiguration config = new YamlConfiguration();
        config.set("whitelistWords", this.whitelistWords);
        config.save(file);
    }

    private final FilterPattern toFilterPattern(String word) {
        String normalized = this.normalizeWord(word);
        if (((CharSequence)normalized).length() == 0) {
            return null;
        }
        return new FilterPattern(word, normalized, this.buildFuzzyRegex(normalized));
    }

    /*
     * WARNING - void declaration
     */
    private final Regex buildFuzzyRegex(String normalizedWord) {
        StringBuilder builder = new StringBuilder();
        builder.append("(?<![a-z])");
        CharSequence $this$forEachIndexed$iv = normalizedWord;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void character;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            builder.append(Regex.Companion.escape(String.valueOf((char)character)));
            if (index >= StringsKt.getLastIndex(normalizedWord)) continue;
            builder.append("[^a-z]*");
        }
        builder.append("(?![a-z])");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new Regex(string);
    }

    private final String normalizeWord(String word) {
        if (StringsKt.isBlank(word)) {
            return "";
        }
        StringBuilder normalizedBuilder = new StringBuilder();
        String string = word;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        CharSequence $this$forEach$iv = string2;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char character = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            String string3 = CHARACTER_REPLACEMENTS.get(Character.valueOf(character));
            if (string3 == null) {
                string3 = String.valueOf(character);
            }
            String replacement = string3;
            CharSequence $this$forEach$iv2 = replacement;
            boolean $i$f$forEach2 = false;
            for (int j = 0; j < $this$forEach$iv2.length(); ++j) {
                char element$iv2;
                char replacementChar = element$iv2 = $this$forEach$iv2.charAt(j);
                boolean bl2 = false;
                String normalized = this.stripDiacritics(String.valueOf(Character.toLowerCase(replacementChar)));
                CharSequence $this$forEach$iv3 = normalized;
                boolean $i$f$forEach3 = false;
                for (int k = 0; k < $this$forEach$iv3.length(); ++k) {
                    char element$iv3;
                    char normalizedChar = element$iv3 = $this$forEach$iv3.charAt(k);
                    boolean bl3 = false;
                    boolean bl4 = 'a' <= normalizedChar ? normalizedChar < '{' : false;
                    if (!bl4) continue;
                    normalizedBuilder.append(normalizedChar);
                }
            }
        }
        String string4 = normalizedBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    private final NormalizedMessage buildNormalizedMessage(String message) {
        StringBuilder normalizedBuilder = new StringBuilder();
        List indexMap = new ArrayList();
        CharSequence $this$forEachIndexed$iv = message;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (int i = 0; i < $this$forEachIndexed$iv.length(); ++i) {
            void rawChar;
            char item$iv = $this$forEachIndexed$iv.charAt(i);
            int n = index$iv++;
            char c = item$iv;
            int index = n;
            boolean bl = false;
            char lowerChar = Character.toLowerCase((char)rawChar);
            String string = CHARACTER_REPLACEMENTS.get(Character.valueOf(lowerChar));
            if (string == null) {
                string = String.valueOf(lowerChar);
            }
            String replacement = string;
            CharSequence $this$forEach$iv = replacement;
            boolean $i$f$forEach = false;
            for (int j = 0; j < $this$forEach$iv.length(); ++j) {
                char element$iv;
                char replacementChar = element$iv = $this$forEach$iv.charAt(j);
                boolean bl2 = false;
                String normalized = this.stripDiacritics(String.valueOf(Character.toLowerCase(replacementChar)));
                if (((CharSequence)normalized).length() == 0) continue;
                CharSequence $this$forEach$iv2 = normalized;
                boolean $i$f$forEach2 = false;
                for (int k = 0; k < $this$forEach$iv2.length(); ++k) {
                    char element$iv2;
                    char normalizedChar = element$iv2 = $this$forEach$iv2.charAt(k);
                    boolean bl3 = false;
                    char finalChar = ('A' <= normalizedChar ? normalizedChar < '[' : false) ? Character.toLowerCase(normalizedChar) : normalizedChar;
                    normalizedBuilder.append(finalChar);
                    indexMap.add(index);
                }
            }
        }
        String string = normalizedBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return new NormalizedMessage(string, CollectionsKt.toIntArray(indexMap));
    }

    private final List<IntRange> collectWhitelistRanges(NormalizedMessage normalizedMessage) {
        if (this.whitelistPatterns.isEmpty() || ((CharSequence)normalizedMessage.getNormalized()).length() == 0) {
            return CollectionsKt.emptyList();
        }
        List ranges = new ArrayList();
        for (FilterPattern pattern : this.whitelistPatterns) {
            Sequence matches;
            Sequence $this$forEach$iv = matches = Regex.findAll$default(pattern.getPattern(), normalizedMessage.getNormalized(), 0, 2, null);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                MatchResult it = (MatchResult)element$iv;
                boolean bl = false;
                ranges.add(it.getRange());
            }
        }
        if (ranges.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List $this$sortBy$iv = ranges;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    IntRange it = (IntRange)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getFirst());
                    it = (IntRange)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getFirst());
                }
            });
        }
        List mergedRanges = new ArrayList();
        IntRange current = (IntRange)CollectionsKt.first(ranges);
        for (IntRange range : CollectionsKt.drop(ranges, 1)) {
            IntRange intRange;
            if (range.getFirst() <= current.getLast() + 1) {
                intRange = new IntRange(current.getFirst(), Math.max(current.getLast(), range.getLast()));
            } else {
                mergedRanges.add(current);
                intRange = range;
            }
            current = intRange;
        }
        mergedRanges.add(current);
        return mergedRanges;
    }

    private final boolean isRangeWhitelisted(IntRange range, List<IntRange> whitelistedRanges) {
        boolean bl;
        block4: {
            if (whitelistedRanges.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = whitelistedRanges;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IntRange whitelistRange = (IntRange)element$iv;
                    boolean bl2 = false;
                    if (!(range.getFirst() >= whitelistRange.getFirst() && range.getLast() <= whitelistRange.getLast())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String stripDiacritics(String value) {
        String string = Normalizer.normalize(value, Normalizer.Form.NFD);
        Intrinsics.checkNotNullExpressionValue(string, "normalize(...)");
        return NON_SPACING_MARKS_REGEX.replace((CharSequence)string, "");
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Character.valueOf('4'), "a"), TuplesKt.to(Character.valueOf('@'), "a"), TuplesKt.to(Character.valueOf('\u00e1'), "a"), TuplesKt.to(Character.valueOf('\u00e0'), "a"), TuplesKt.to(Character.valueOf('\u00e4'), "a"), TuplesKt.to(Character.valueOf('\u00e2'), "a"), TuplesKt.to(Character.valueOf('\u00e5'), "a"), TuplesKt.to(Character.valueOf('\u00e6'), "ae"), TuplesKt.to(Character.valueOf('\u00df'), "ss"), TuplesKt.to(Character.valueOf('3'), "e"), TuplesKt.to(Character.valueOf('\u20ac'), "e"), TuplesKt.to(Character.valueOf('1'), "i"), TuplesKt.to(Character.valueOf('!'), "i"), TuplesKt.to(Character.valueOf('|'), "i"), TuplesKt.to(Character.valueOf('0'), "o"), TuplesKt.to(Character.valueOf('\u00f6'), "o"), TuplesKt.to(Character.valueOf('\u00f4'), "o"), TuplesKt.to(Character.valueOf('\u00f2'), "o"), TuplesKt.to(Character.valueOf('\u00f3'), "o"), TuplesKt.to(Character.valueOf('\u00f8'), "o"), TuplesKt.to(Character.valueOf('5'), "s"), TuplesKt.to(Character.valueOf('$'), "s"), TuplesKt.to(Character.valueOf('\u0161'), "s"), TuplesKt.to(Character.valueOf('\u00a7'), "s"), TuplesKt.to(Character.valueOf('7'), "t"), TuplesKt.to(Character.valueOf('+'), "t"), TuplesKt.to(Character.valueOf('2'), "z"), TuplesKt.to(Character.valueOf('\u017e'), "z")};
        CHARACTER_REPLACEMENTS = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/syntaxdevteam/cleanerx/base/WordFilter$Companion;", "", "<init>", "()V", "NON_SPACING_MARKS_REGEX", "Lkotlin/text/Regex;", "CHARACTER_REPLACEMENTS", "", "", "", "CleanerX-Spigot"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lpl/syntaxdevteam/cleanerx/base/WordFilter$FilterPattern;", "", "original", "", "normalized", "pattern", "Lkotlin/text/Regex;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;)V", "getOriginal", "()Ljava/lang/String;", "getNormalized", "getPattern", "()Lkotlin/text/Regex;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "CleanerX-Spigot"})
    private static final class FilterPattern {
        @NotNull
        private final String original;
        @NotNull
        private final String normalized;
        @NotNull
        private final Regex pattern;

        public FilterPattern(@NotNull String original, @NotNull String normalized, @NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter(original, "original");
            Intrinsics.checkNotNullParameter(normalized, "normalized");
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            this.original = original;
            this.normalized = normalized;
            this.pattern = pattern;
        }

        @NotNull
        public final String getOriginal() {
            return this.original;
        }

        @NotNull
        public final String getNormalized() {
            return this.normalized;
        }

        @NotNull
        public final Regex getPattern() {
            return this.pattern;
        }

        @NotNull
        public final String component1() {
            return this.original;
        }

        @NotNull
        public final String component2() {
            return this.normalized;
        }

        @NotNull
        public final Regex component3() {
            return this.pattern;
        }

        @NotNull
        public final FilterPattern copy(@NotNull String original, @NotNull String normalized, @NotNull Regex pattern) {
            Intrinsics.checkNotNullParameter(original, "original");
            Intrinsics.checkNotNullParameter(normalized, "normalized");
            Intrinsics.checkNotNullParameter(pattern, "pattern");
            return new FilterPattern(original, normalized, pattern);
        }

        public static /* synthetic */ FilterPattern copy$default(FilterPattern filterPattern, String string, String string2, Regex regex, int n, Object object) {
            if ((n & 1) != 0) {
                string = filterPattern.original;
            }
            if ((n & 2) != 0) {
                string2 = filterPattern.normalized;
            }
            if ((n & 4) != 0) {
                regex = filterPattern.pattern;
            }
            return filterPattern.copy(string, string2, regex);
        }

        @NotNull
        public String toString() {
            return "FilterPattern(original=" + this.original + ", normalized=" + this.normalized + ", pattern=" + this.pattern + ")";
        }

        public int hashCode() {
            int result = this.original.hashCode();
            result = result * 31 + this.normalized.hashCode();
            result = result * 31 + this.pattern.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilterPattern)) {
                return false;
            }
            FilterPattern filterPattern = (FilterPattern)other;
            if (!Intrinsics.areEqual(this.original, filterPattern.original)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.normalized, filterPattern.normalized)) {
                return false;
            }
            return Intrinsics.areEqual(this.pattern, filterPattern.pattern);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/cleanerx/base/WordFilter$NormalizedMessage;", "", "normalized", "", "indexMap", "", "<init>", "(Ljava/lang/String;[I)V", "getNormalized", "()Ljava/lang/String;", "getIndexMap", "()[I", "equals", "", "other", "hashCode", "", "component1", "component2", "copy", "toString", "CleanerX-Spigot"})
    private static final class NormalizedMessage {
        @NotNull
        private final String normalized;
        @NotNull
        private final int[] indexMap;

        public NormalizedMessage(@NotNull String normalized, @NotNull int[] indexMap) {
            Intrinsics.checkNotNullParameter(normalized, "normalized");
            Intrinsics.checkNotNullParameter(indexMap, "indexMap");
            this.normalized = normalized;
            this.indexMap = indexMap;
        }

        @NotNull
        public final String getNormalized() {
            return this.normalized;
        }

        @NotNull
        public final int[] getIndexMap() {
            return this.indexMap;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Object object2 = other;
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type pl.syntaxdevteam.cleanerx.base.WordFilter.NormalizedMessage");
            NormalizedMessage cfr_ignored_0 = (NormalizedMessage)object2;
            if (!Intrinsics.areEqual(this.normalized, ((NormalizedMessage)other).normalized)) {
                return false;
            }
            return Arrays.equals(this.indexMap, ((NormalizedMessage)other).indexMap);
        }

        public int hashCode() {
            int result = this.normalized.hashCode();
            result = 31 * result + Arrays.hashCode(this.indexMap);
            return result;
        }

        @NotNull
        public final String component1() {
            return this.normalized;
        }

        @NotNull
        public final int[] component2() {
            return this.indexMap;
        }

        @NotNull
        public final NormalizedMessage copy(@NotNull String normalized, @NotNull int[] indexMap) {
            Intrinsics.checkNotNullParameter(normalized, "normalized");
            Intrinsics.checkNotNullParameter(indexMap, "indexMap");
            return new NormalizedMessage(normalized, indexMap);
        }

        public static /* synthetic */ NormalizedMessage copy$default(NormalizedMessage normalizedMessage, String string, int[] nArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = normalizedMessage.normalized;
            }
            if ((n & 2) != 0) {
                nArray = normalizedMessage.indexMap;
            }
            return normalizedMessage.copy(string, nArray);
        }

        @NotNull
        public String toString() {
            return "NormalizedMessage(normalized=" + this.normalized + ", indexMap=" + Arrays.toString(this.indexMap) + ")";
        }
    }
}

