/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.commands;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J9\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lpl/syntaxdevteam/cleanerx/commands/BlackListCommand;", "Lorg/bukkit/command/CommandExecutor;", "Lorg/bukkit/command/TabCompleter;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "audiences", "Lnet/kyori/adventure/platform/bukkit/BukkitAudiences;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Lnet/kyori/adventure/platform/bukkit/BukkitAudiences;)V", "mH", "Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "onCommand", "", "sender", "Lorg/bukkit/command/CommandSender;", "command", "Lorg/bukkit/command/Command;", "label", "", "args", "", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Z", "onTabComplete", "", "alias", "(Lorg/bukkit/command/CommandSender;Lorg/bukkit/command/Command;Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "sendMessage", "", "component", "Lnet/kyori/adventure/text/Component;", "CleanerX-Spigot"})
public final class BlackListCommand
implements CommandExecutor,
TabCompleter {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final BukkitAudiences audiences;
    @NotNull
    private final MessageHandler mH;

    public BlackListCommand(@NotNull CleanerX plugin, @NotNull BukkitAudiences audiences) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(audiences, "audiences");
        this.plugin = plugin;
        this.audiences = audiences;
        this.mH = this.plugin.getMessageHandler();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("cleanerx.cmd.blacklist")) {
            this.sendMessage(sender, MessageHandler.getMessage$default(this.mH, "error", "no_permission", null, 4, null));
            return true;
        }
        if (args.length == 0) {
            this.sendMessage(sender, MessageHandler.getMessage$default(this.mH, "word", "usage", null, 4, null));
            return true;
        }
        String string = args[0].toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        switch (string) {
            case "add": {
                if (args.length > 1) {
                    String newWord = args[1];
                    this.plugin.getWordFilter().addBannedWord(newWord);
                    this.plugin.restartMyTask();
                    this.sendMessage(sender, this.mH.getMessage("word", "word_added", MapsKt.mapOf(TuplesKt.to("word", newWord))));
                    break;
                }
                this.sendMessage(sender, MessageHandler.getMessage$default(this.mH, "word", "no_word_provided", null, 4, null));
                break;
            }
            case "remove": {
                if (args.length > 1) {
                    String wordToRemove = args[1];
                    if (this.plugin.getWordFilter().removeBannedWord(wordToRemove)) {
                        this.plugin.restartMyTask();
                        this.sendMessage(sender, this.mH.getMessage("word", "word_removed", MapsKt.mapOf(TuplesKt.to("word", wordToRemove))));
                        break;
                    }
                    this.sendMessage(sender, this.mH.getMessage("word", "word_not_found", MapsKt.mapOf(TuplesKt.to("word", wordToRemove))));
                    break;
                }
                this.sendMessage(sender, MessageHandler.getMessage$default(this.mH, "word", "no_word_provided", null, 4, null));
                break;
            }
            case "list": {
                List<String> bannedWords = this.plugin.getWordFilter().getBannedWords();
                String formattedList = CollectionsKt.joinToString$default(bannedWords, ", ", null, null, 0, null, null, 62, null);
                this.sendMessage(sender, this.mH.miniMessageFormat(this.mH.getPrefix() + " <red>Banned words: <white>" + formattedList));
                break;
            }
            default: {
                this.sendMessage(sender, MessageHandler.getMessage$default(this.mH, "word", "usage", null, 4, null));
            }
        }
        return true;
    }

    @NotNull
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        List<String> list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(alias, "alias");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!sender.hasPermission("cleanerx.cmd.blacklist")) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            String[] stringArray = new String[]{"list", "add", "remove"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void sendMessage(CommandSender sender, Component component) {
        if (sender instanceof Player) {
            this.audiences.player((Player)sender).sendMessage(component);
        } else {
            sender.sendMessage(LegacyComponentSerializer.legacySection().serialize(component));
        }
    }
}

