/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ \u0010\u0017\u001a\u00020\u000e2\u0018\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001a0\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lpl/syntaxdevteam/cleanerx/common/Logger;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "debugMode", "", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Z)V", "plName", "", "plVer", "serverVersion", "serverName", "clear", "", "s", "success", "info", "warning", "err", "severe", "log", "debug", "pluginStart", "pluginsByPriority", "", "Lkotlin/Pair;", "CleanerX-Spigot"})
public final class Logger {
    private final boolean debugMode;
    @NotNull
    private final String plName;
    @NotNull
    private final String plVer;
    @NotNull
    private final String serverVersion;
    @NotNull
    private final String serverName;

    public Logger(@NotNull CleanerX plugin, boolean debugMode) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.debugMode = debugMode;
        String string = plugin.getDescription().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        this.plName = string;
        String string2 = plugin.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
        this.plVer = string2;
        String string3 = plugin.getServer().getVersion();
        Intrinsics.checkNotNullExpressionValue(string3, "getVersion(...)");
        this.serverVersion = string3;
        String string4 = plugin.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
        this.serverName = string4;
    }

    private final void clear(String s) {
        ConsoleCommandSender consoleCommandSender = Bukkit.getConsoleSender();
        String string = s;
        Intrinsics.checkNotNull(string);
        consoleCommandSender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)string));
    }

    public final void success(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] &a&l" + s + "&r")));
    }

    public final void info(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] " + s)));
    }

    public final void warning(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] &6" + s + "&r")));
    }

    public final void err(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] &c" + s + "&r")));
    }

    public final void severe(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] &c&l" + s + "&r")));
    }

    public final void log(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] " + s)));
    }

    public final void debug(@NotNull String s) {
        Intrinsics.checkNotNullParameter(s, "s");
        if (this.debugMode) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("[" + this.plName + "] [DEBUG] &e&l" + s)));
        }
    }

    public final void pluginStart(@NotNull List<Pair<String, String>> pluginsByPriority) {
        Intrinsics.checkNotNullParameter(pluginsByPriority, "pluginsByPriority");
        this.clear("");
        this.clear("&9    __                   __        ___            ");
        this.clear("&9   (_      _  |_  _     |  \\  _     |   _  _   _  ");
        this.clear("&9   __) \\/ | ) |_ (_| )( |__/ (- \\/  |  (- (_| ||| ");
        this.clear("&9       /                                          ");
        this.clear("&9           ... is proud to present and enable:");
        this.clear("&9                     &f * &f&l" + this.plName + " v" + this.plVer);
        for (Pair<String, String> pair : pluginsByPriority) {
            String pluginName = pair.component1();
            String pluginVersion = pair.component2();
            this.clear("&9                     &f * " + pluginName + " v" + pluginVersion);
        }
        this.clear("&9                 utilizing all the optimizations of your server " + this.serverName + " " + this.serverVersion + "!         ");
        this.clear("");
        this.clear("&c    Join our Discord! &6&lhttps://discord.gg/Zk6mxv7eMh");
        this.clear("");
        this.clear("");
    }
}

