/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.eventhandler;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.base.SwearCounter;
import pl.syntaxdevteam.cleanerx.base.WordFilter;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;
import pl.syntaxdevteam.cleanerx.eventhandler.RegexUrlDetector;
import pl.syntaxdevteam.cleanerx.eventhandler.UriUrlDetector;
import pl.syntaxdevteam.cleanerx.eventhandler.UrlDetector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lpl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat;", "Lorg/bukkit/event/Listener;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "wordFilter", "Lpl/syntaxdevteam/cleanerx/base/WordFilter;", "fullCensorship", "", "swearCounter", "Lpl/syntaxdevteam/cleanerx/base/SwearCounter;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;Lpl/syntaxdevteam/cleanerx/base/WordFilter;ZLpl/syntaxdevteam/cleanerx/base/SwearCounter;)V", "blockLinks", "usePunishment", "urlDetectors", "", "Lpl/syntaxdevteam/cleanerx/eventhandler/UrlDetector;", "onChat", "", "event", "Lorg/bukkit/event/player/AsyncPlayerChatEvent;", "CleanerX-Spigot"})
@SourceDebugExtension(value={"SMAP\nCleanerXChat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanerXChat.kt\npl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1761#2,3:67\n*S KotlinDebug\n*F\n+ 1 CleanerXChat.kt\npl/syntaxdevteam/cleanerx/eventhandler/CleanerXChat\n*L\n34#1:67,3\n*E\n"})
public final class CleanerXChat
implements Listener {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final WordFilter wordFilter;
    private final boolean fullCensorship;
    @NotNull
    private final SwearCounter swearCounter;
    private final boolean blockLinks;
    private final boolean usePunishment;
    @NotNull
    private final List<UrlDetector> urlDetectors;

    public CleanerXChat(@NotNull CleanerX plugin, @NotNull WordFilter wordFilter, boolean fullCensorship, @NotNull SwearCounter swearCounter) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        Intrinsics.checkNotNullParameter(wordFilter, "wordFilter");
        Intrinsics.checkNotNullParameter(swearCounter, "swearCounter");
        this.plugin = plugin;
        this.wordFilter = wordFilter;
        this.fullCensorship = fullCensorship;
        this.swearCounter = swearCounter;
        this.blockLinks = this.plugin.getConfig().getBoolean("block-links", false);
        this.usePunishment = this.plugin.getConfig().getBoolean("use-punishment", false);
        UrlDetector[] urlDetectorArray = new UrlDetector[]{new UriUrlDetector(), new RegexUrlDetector()};
        this.urlDetectors = CollectionsKt.listOf(urlDetectorArray);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public final void onChat(@NotNull AsyncPlayerChatEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        try {
            Regex element$iv2;
            String message = null;
            String string = event.getMessage();
            Intrinsics.checkNotNullExpressionValue(string, "getMessage(...)");
            message = string;
            if (this.blockLinks) {
                boolean bl;
                block10: {
                    Iterable $this$any$iv = this.urlDetectors;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Regex element$iv2 : $this$any$iv) {
                            UrlDetector it = (UrlDetector)((Object)element$iv2);
                            boolean bl2 = false;
                            if (!it.containsUrl(message)) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    event.setCancelled(true);
                    event.getPlayer().sendMessage(MessageHandler.getCleanMessage$default(this.plugin.getMessageHandler(), "error", "no-link", null, 4, null));
                    return;
                }
            }
            int swearWordCount = 0;
            Iterator<String> iterator2 = message;
            element$iv2 = new Regex("\\s+");
            int n = 0;
            List<String> words = element$iv2.split((CharSequence)((Object)iterator2), n);
            for (String word : words) {
                if (!this.wordFilter.containsBannedWord(word)) continue;
                ++swearWordCount;
            }
            if (swearWordCount > 0) {
                message = this.wordFilter.censorMessage(message, this.fullCensorship);
                event.setMessage(message);
                if (this.usePunishment) {
                    Player player = event.getPlayer();
                    Intrinsics.checkNotNullExpressionValue(player, "getPlayer(...)");
                    this.swearCounter.incrementSwearCount(player, swearWordCount);
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Critical error! Send a message to the plugin author with the subject \"Error in onChat\" and the content: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

