/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.MessageHandler;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\b\u0001\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/cleanerx/commands/CleanerXCommand;", "Lio/papermc/paper/command/brigadier/BasicCommand;", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "mH", "Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "execute", "", "stack", "Lio/papermc/paper/command/brigadier/CommandSourceStack;", "args", "", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)V", "suggest", "", "(Lio/papermc/paper/command/brigadier/CommandSourceStack;[Ljava/lang/String;)Ljava/util/List;", "CleanerX-Paper"})
public final class CleanerXCommand
implements BasicCommand {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final MessageHandler mH;

    public CleanerXCommand(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.mH = this.plugin.getMessageHandler();
    }

    public void execute(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!stack.getSender().hasPermission("cleanerx.cmd.crx")) {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "error", "no_permission", null, 4, null));
            return;
        }
        CleanerX cleanerX = this.plugin;
        Intrinsics.checkNotNull((Object)cleanerX, "null cannot be cast to non-null type io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner");
        PluginMeta pluginMeta = ((LifecycleEventOwner)cleanerX).getPluginMeta();
        Intrinsics.checkNotNullExpressionValue(pluginMeta, "getPluginMeta(...)");
        PluginMeta pluginMeta2 = pluginMeta;
        PluginDescriptionFile pluginDescriptionFile = this.plugin.getDescription();
        Intrinsics.checkNotNullExpressionValue(pluginDescriptionFile, "getDescription(...)");
        PluginDescriptionFile pdf = pluginDescriptionFile;
        if (!(args.length == 0)) {
            if (StringsKt.equals(args[0], "help", true)) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat(" <gray>+-------------------------------------------------\n |\n |  <gold>Available commands for " + pluginMeta2.getName() + ":\n <gray>|\n |  <gold>/crx help <gray>- <white>Displays this prompt.<gray>\n <gray>|  <gold>/blacklistx <add/remove/list> <word> \n <gray>|                      <gray>- <white>Adds a word to the blacklist.\n <gray>|  <gold>/whitelistx <add/remove/list> <word> \n <gray>|                      <gray>- <white>Adds a word to the whitelist.\n <gray>|  <gold>/cleanx <gray>- <white>Clears the chat window.\n <gray>|  <gold>/crx version <gray>- <white>Shows plugin info. \n <gray>|  <gold>/crx reload <gray>- <white>Reloads the configuration file\n |\n <gray>|\n<gray>+-------------------------------------------------"));
            } else if (StringsKt.equals(args[0], "version", true)) {
                stack.getSender().sendMessage(this.mH.miniMessageFormat("\n<gray>-------------------------------------------------\n <gray>|\n <gray>|   <gold>\u2192 <bold>" + pluginMeta2.getName() + "</bold> \u2190\n <gray>|   <white>Author: <bold><gold>" + pdf.getAuthors() + "</gold></bold>\n <gray>|   <white>Website: <bold><gold><click:open_url:'" + pdf.getWebsite() + "'>" + pdf.getWebsite() + "</click></gold></bold>\n <gray>|   <white>Version: <bold><gold>" + pluginMeta2.getVersion() + "</gold></bold>\n <gray>|\n-------------------------------------------------"));
            } else if (StringsKt.equals(args[0], "reload", true)) {
                this.plugin.restartMyTask();
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "reload", "success", null, 4, null));
            } else {
                stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "error", "unknown_command", null, 4, null));
            }
        } else {
            stack.getSender().sendMessage(MessageHandler.getMessage$default(this.mH, "error", "unknown_command", null, 4, null));
        }
    }

    @NotNull
    public List<String> suggest(@NotNull CommandSourceStack stack, @NotNull String[] args) {
        List<String> list;
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(args, "args");
        if (!stack.getSender().hasPermission("cleanerx.cmd.crx")) {
            return CollectionsKt.emptyList();
        }
        if (args.length == 1) {
            String[] stringArray = new String[]{"help", "version", "reload"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

