/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.common;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\u0007J,\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J,\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J2\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\b\u0002\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0017J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001c2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010\"\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0013J\u000e\u0010%\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0013J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0018\u0010+\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lpl/syntaxdevteam/cleanerx/common/MessageHandler;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "language", "", "Lorg/jetbrains/annotations/Nullable;", "messages", "Lorg/bukkit/configuration/file/FileConfiguration;", "initial", "", "copyDefaultMessages", "updateLanguageFile", "loadMessages", "reloadMessages", "getPrefix", "getMessage", "Lnet/kyori/adventure/text/Component;", "category", "key", "placeholders", "", "getSimpleMessage", "getCleanMessage", "getLogMessage", "getComplexMessage", "", "getReasons", "formatLegacyText", "message", "formatLegacyTextBukkit", "formatHexAndLegacyText", "miniMessageFormat", "getANSIText", "component", "getPlainText", "convertLegacyToMiniMessage", "convertSectionSignToMiniMessage", "convertHexToMiniMessage", "convertUnicodeEscapeSequences", "input", "formatMixedTextToMiniMessage", "resolver", "Lnet/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "CleanerX-Paper"})
@SourceDebugExtension(value={"SMAP\nMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/cleanerx/common/MessageHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,431:1\n1803#2,3:432\n1803#2,3:435\n1803#2,3:438\n1803#2,3:441\n1563#2:444\n1634#2,2:445\n1803#2,3:447\n1636#2:450\n*S KotlinDebug\n*F\n+ 1 MessageHandler.kt\npl/syntaxdevteam/cleanerx/common/MessageHandler\n*L\n101#1:432,3\n122#1:435,3\n141#1:438,3\n160#1:441,3\n180#1:444\n180#1:445,2\n181#1:447,3\n180#1:450\n*E\n"})
public final class MessageHandler {
    @NotNull
    private final CleanerX plugin;
    @NotNull
    private final String language;
    @NotNull
    private FileConfiguration messages;

    public MessageHandler(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        String string = this.plugin.getConfig().getString("language");
        if (string == null) {
            string = "EN";
        }
        this.language = string;
        this.copyDefaultMessages();
        this.updateLanguageFile();
        this.messages = this.loadMessages();
    }

    public final void initial() {
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        String author = switch (string) {
            case "pl" -> "WieszczY";
            case "en" -> "Syntaxerr";
            case "nl" -> "LegacyHeaven";
            default -> "OpenAI ChatGPT-4o";
        };
        this.plugin.getLogger().log("<gray>Loaded \"" + this.language + "\" language file by: <white><b>" + author + "</b></white>");
    }

    private final void copyDefaultMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File messageFile = new File(file, "lang/messages_" + string + ".yml");
        if (!messageFile.exists()) {
            messageFile.getParentFile().mkdirs();
            String string2 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            this.plugin.saveResource("lang/messages_" + string2 + ".yml", false);
        }
    }

    private final void updateLanguageFile() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        String string2 = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        InputStream defaultLangStream = this.plugin.getResource("lang/messages_" + string2 + ".yml");
        if (defaultLangStream == null) {
            this.plugin.getLogger().err("Default language file for " + this.language + " not found in plugin resources!");
            return;
        }
        InputStream inputStream = defaultLangStream;
        Charset charset = Charsets.UTF_8;
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(inputStream, charset));
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        YamlConfiguration defaultConfig = yamlConfiguration;
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration2, "loadConfiguration(...)");
        YamlConfiguration currentConfig = yamlConfiguration2;
        Ref.BooleanRef updated = new Ref.BooleanRef();
        MessageHandler.updateLanguageFile$synchronizeSections(updated, (ConfigurationSection)defaultConfig, (ConfigurationSection)currentConfig);
        if (updated.element) {
            Logger logger = this.plugin.getLogger();
            String string3 = this.language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            logger.success("Updating language file: messages_" + string3 + ".yml with missing entries.");
            currentConfig.save(langFile);
        }
    }

    private final FileConfiguration loadMessages() {
        File file = this.plugin.getDataFolder();
        String string = this.language.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        File langFile = new File(file, "lang/messages_" + string + ".yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)langFile);
        Intrinsics.checkNotNullExpressionValue(yamlConfiguration, "loadConfiguration(...)");
        return (FileConfiguration)yamlConfiguration;
    }

    public final void reloadMessages() {
        this.messages = this.loadMessages();
    }

    @NotNull
    public final String getPrefix() {
        Object object = this.messages.getString("prefix");
        if (object == null) {
            object = "[" + this.plugin.getPluginMeta().getName() + "]";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Component getMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String prefix = this.getPrefix();
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getMessage_u24lambda_u240 = this;
            boolean bl = false;
            $this$getMessage_u24lambda_u240.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        String mixMessage = prefix + " " + formattedMessage;
        return this.formatMixedTextToMiniMessage(mixMessage, TagResolver.empty());
    }

    public static /* synthetic */ Component getMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getSimpleMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String prefix = this.getPrefix();
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getSimpleMessage_u24lambda_u242 = this;
            boolean bl = false;
            $this$getSimpleMessage_u24lambda_u242.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return prefix + " " + formattedMessage;
    }

    public static /* synthetic */ String getSimpleMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getSimpleMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getCleanMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getCleanMessage_u24lambda_u244 = this;
            boolean bl = false;
            $this$getCleanMessage_u24lambda_u244.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return formattedMessage;
    }

    public static /* synthetic */ String getCleanMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getCleanMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Component getLogMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        String string = this.messages.getString(category + "." + key);
        if (string == null) {
            MessageHandler $this$getLogMessage_u24lambda_u246 = this;
            boolean bl = false;
            $this$getLogMessage_u24lambda_u246.plugin.getLogger().err("There was an error loading the message " + key + " from category " + category);
            string = "Message not found. Check console...";
        }
        String message = string;
        Iterable iterable = placeholders.entrySet();
        String initial$iv = message;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)element$iv;
            String acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = StringsKt.replace$default(acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
        }
        String formattedMessage = accumulator$iv;
        return this.formatMixedTextToMiniMessage(formattedMessage, TagResolver.empty());
    }

    public static /* synthetic */ Component getLogMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getLogMessage(string, string2, map);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Component> getComplexMessage(@NotNull String category, @NotNull String key, @NotNull Map<String, String> placeholders) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(placeholders, "placeholders");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        List messageList = list;
        if (messageList.isEmpty()) {
            this.plugin.getLogger().err("There was an error loading the message list " + key + " from category " + category);
            return CollectionsKt.listOf(Component.text((String)"Message list not found. Check console..."));
        }
        Iterable $this$map$iv = messageList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$fold$iv;
            void message;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = placeholders.entrySet();
            void initial$iv = message;
            boolean $i$f$fold = false;
            String accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void entry;
                Map.Entry entry2 = (Map.Entry)element$iv;
                void acc = accumulator$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(acc);
                accumulator$iv = StringsKt.replace$default((String)acc, "{" + entry.getKey() + "}", (String)entry.getValue(), false, 4, null);
            }
            void formattedMessage = accumulator$iv;
            Intrinsics.checkNotNull(formattedMessage);
            collection.add(this.formatMixedTextToMiniMessage((String)formattedMessage, TagResolver.empty()));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getComplexMessage$default(MessageHandler messageHandler, String string, String string2, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return messageHandler.getComplexMessage(string, string2, map);
    }

    @NotNull
    public final List<String> getReasons(@NotNull String category, @NotNull String key) {
        Intrinsics.checkNotNullParameter(category, "category");
        Intrinsics.checkNotNullParameter(key, "key");
        List list = this.messages.getStringList(category + "." + key);
        Intrinsics.checkNotNullExpressionValue(list, "getStringList(...)");
        return list;
    }

    @NotNull
    public final Component formatLegacyText(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        TextComponent textComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(message);
        Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
        return (Component)textComponent;
    }

    @NotNull
    public final String formatLegacyTextBukkit(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        String string = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Intrinsics.checkNotNullExpressionValue(string, "translateAlternateColorCodes(...)");
        return string;
    }

    @NotNull
    public final Component formatHexAndLegacyText(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        CharSequence charSequence = message;
        Regex regex = new Regex("&#([a-fA-F0-9]{6})");
        Function1<MatchResult, CharSequence> function1 = MessageHandler::formatHexAndLegacyText$lambda$10;
        String hexFormatted = regex.replace(charSequence, function1);
        TextComponent textComponent = LegacyComponentSerializer.legacySection().deserialize(hexFormatted);
        Intrinsics.checkNotNullExpressionValue(textComponent, "deserialize(...)");
        return (Component)textComponent;
    }

    @NotNull
    public final Component miniMessageFormat(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Component component = MiniMessage.miniMessage().deserialize((Object)message);
        Intrinsics.checkNotNullExpressionValue(component, "deserialize(...)");
        return component;
    }

    @NotNull
    public final String getANSIText(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        Object object = ANSIComponentSerializer.ansi().serialize(component);
        Intrinsics.checkNotNullExpressionValue(object, "serialize(...)");
        return (String)object;
    }

    @NotNull
    public final String getPlainText(@NotNull Component component) {
        Intrinsics.checkNotNullParameter(component, "component");
        String string = PlainTextComponentSerializer.plainText().serialize(component);
        Intrinsics.checkNotNullExpressionValue(string, "serialize(...)");
        return string;
    }

    private final String convertLegacyToMiniMessage(String message) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("&0", "<black>"), TuplesKt.to("&1", "<dark_blue>"), TuplesKt.to("&2", "<dark_green>"), TuplesKt.to("&3", "<dark_aqua>"), TuplesKt.to("&4", "<dark_red>"), TuplesKt.to("&5", "<dark_purple>"), TuplesKt.to("&6", "<gold>"), TuplesKt.to("&7", "<gray>"), TuplesKt.to("&8", "<dark_gray>"), TuplesKt.to("&9", "<blue>"), TuplesKt.to("&a", "<green>"), TuplesKt.to("&b", "<aqua>"), TuplesKt.to("&c", "<red>"), TuplesKt.to("&d", "<light_purple>"), TuplesKt.to("&e", "<yellow>"), TuplesKt.to("&f", "<white>"), TuplesKt.to("&k", "<obfuscated>"), TuplesKt.to("&l", "<bold>"), TuplesKt.to("&m", "<strikethrough>"), TuplesKt.to("&n", "<underlined>"), TuplesKt.to("&o", "<italic>"), TuplesKt.to("&r", "<reset>")};
        Map<String, String> legacyMap = MapsKt.mapOf(pairArray);
        Regex pattern = new Regex("(<[^>]+>|\\{[^}]+})");
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        Iterator iterator2 = Regex.findAll$default(pattern, message, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            MatchResult match = (MatchResult)iterator2.next();
            int start = match.getRange().getFirst();
            if (start > lastIndex) {
                String nonTag;
                Intrinsics.checkNotNullExpressionValue(message.substring(lastIndex, start), "substring(...)");
                result.append(MessageHandler.convertLegacyToMiniMessage$processLegacy(legacyMap, nonTag));
            }
            result.append(match.getValue());
            lastIndex = match.getRange().getLast() + 1;
        }
        if (lastIndex < message.length()) {
            String string = message.substring(lastIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            result.append(MessageHandler.convertLegacyToMiniMessage$processLegacy(legacyMap, string));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String convertSectionSignToMiniMessage(String message) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("\u00a70", "<black>"), TuplesKt.to("\u00a71", "<dark_blue>"), TuplesKt.to("\u00a72", "<dark_green>"), TuplesKt.to("\u00a73", "<dark_aqua>"), TuplesKt.to("\u00a74", "<dark_red>"), TuplesKt.to("\u00a75", "<dark_purple>"), TuplesKt.to("\u00a76", "<gold>"), TuplesKt.to("\u00a77", "<gray>"), TuplesKt.to("\u00a78", "<dark_gray>"), TuplesKt.to("\u00a79", "<blue>"), TuplesKt.to("\u00a7a", "<green>"), TuplesKt.to("\u00a7b", "<aqua>"), TuplesKt.to("\u00a7c", "<red>"), TuplesKt.to("\u00a7d", "<light_purple>"), TuplesKt.to("\u00a7e", "<yellow>"), TuplesKt.to("\u00a7f", "<white>"), TuplesKt.to("\u00a7k", "<obfuscated>"), TuplesKt.to("\u00a7l", "<bold>"), TuplesKt.to("\u00a7m", "<strikethrough>"), TuplesKt.to("\u00a7n", "<underlined>"), TuplesKt.to("\u00a7o", "<italic>"), TuplesKt.to("\u00a7r", "<reset>")};
        Map<String, String> sectionMap = MapsKt.mapOf(pairArray);
        Regex pattern = new Regex("(<[^>]+>|\\{[^}]+})");
        StringBuilder result = new StringBuilder();
        int lastIndex = 0;
        Iterator iterator2 = Regex.findAll$default(pattern, message, 0, 2, null).iterator();
        while (iterator2.hasNext()) {
            MatchResult match = (MatchResult)iterator2.next();
            int start = match.getRange().getFirst();
            if (start > lastIndex) {
                String nonTag;
                Intrinsics.checkNotNullExpressionValue(message.substring(lastIndex, start), "substring(...)");
                result.append(MessageHandler.convertSectionSignToMiniMessage$processSection(sectionMap, nonTag));
            }
            result.append(match.getValue());
            lastIndex = match.getRange().getLast() + 1;
        }
        if (lastIndex < message.length()) {
            String string = message.substring(lastIndex);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            result.append(MessageHandler.convertSectionSignToMiniMessage$processSection(sectionMap, string));
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    private final String convertHexToMiniMessage(String message) {
        CharSequence charSequence = message;
        Regex regex = new Regex("&#([a-fA-F0-9]{6})");
        Function1<MatchResult, CharSequence> function1 = MessageHandler::convertHexToMiniMessage$lambda$13;
        return regex.replace(charSequence, function1);
    }

    private final String convertUnicodeEscapeSequences(String input) {
        CharSequence charSequence = input;
        Regex regex = new Regex("\\\\u([0-9A-Fa-f]{4})");
        Function1<MatchResult, CharSequence> function1 = MessageHandler::convertUnicodeEscapeSequences$lambda$14;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public final Component formatMixedTextToMiniMessage(@NotNull String message, @Nullable TagResolver resolver) {
        Component component;
        Intrinsics.checkNotNullParameter(message, "message");
        this.plugin.getLogger().debug("Formatting mixed text to MiniMessage: " + message);
        String formattedMessage = this.convertSectionSignToMiniMessage(message);
        this.plugin.getLogger().debug("After converting section signs: " + formattedMessage);
        formattedMessage = this.convertLegacyToMiniMessage(formattedMessage);
        this.plugin.getLogger().debug("After converting legacy: " + formattedMessage);
        formattedMessage = this.convertHexToMiniMessage(formattedMessage);
        this.plugin.getLogger().debug("After converting hex: " + formattedMessage);
        formattedMessage = this.convertUnicodeEscapeSequences(formattedMessage);
        this.plugin.getLogger().debug("After converting Unicode escape sequences: " + formattedMessage);
        if (resolver != null) {
            Component component2 = MiniMessage.miniMessage().deserialize(formattedMessage, resolver);
            Intrinsics.checkNotNull(component2);
            component = component2;
        } else {
            Component component3 = MiniMessage.miniMessage().deserialize((Object)formattedMessage);
            Intrinsics.checkNotNull(component3);
            component = component3;
        }
        return component;
    }

    private static final void updateLanguageFile$synchronizeSections(Ref.BooleanRef updated, ConfigurationSection defaultSection, ConfigurationSection currentSection) {
        for (String key : defaultSection.getKeys(false)) {
            if (!currentSection.contains(key)) {
                currentSection.set(key, defaultSection.get(key));
                updated.element = true;
                continue;
            }
            if (!defaultSection.isConfigurationSection(key)) continue;
            ConfigurationSection configurationSection = defaultSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection);
            ConfigurationSection configurationSection2 = currentSection.getConfigurationSection(key);
            Intrinsics.checkNotNull(configurationSection2);
            MessageHandler.updateLanguageFile$synchronizeSections(updated, configurationSection, configurationSection2);
        }
    }

    private static final CharSequence formatHexAndLegacyText$lambda$10(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String hex = it.getGroupValues().get(1);
        return "\u00a7x\u00a7" + hex.charAt(0) + "\u00a7" + hex.charAt(1) + "\u00a7" + hex.charAt(2) + "\u00a7" + hex.charAt(3) + "\u00a7" + hex.charAt(4) + "\u00a7" + hex.charAt(5);
    }

    private static final CharSequence convertLegacyToMiniMessage$processLegacy$lambda$11(Map $legacyMap, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        String string = (String)$legacyMap.get("&" + matchResult.getGroupValues().get(1));
        return string != null ? (CharSequence)string : (CharSequence)matchResult.getValue();
    }

    private static final String convertLegacyToMiniMessage$processLegacy(Map<String, String> legacyMap, String segment) {
        CharSequence charSequence = segment;
        Regex regex = new Regex("&([0-9a-fklmnor])");
        Function1<MatchResult, CharSequence> function1 = arg_0 -> MessageHandler.convertLegacyToMiniMessage$processLegacy$lambda$11(legacyMap, arg_0);
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence convertSectionSignToMiniMessage$processSection$lambda$12(Map $sectionMap, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        String string = (String)$sectionMap.get("\u00a7" + matchResult.getGroupValues().get(1));
        return string != null ? (CharSequence)string : (CharSequence)matchResult.getValue();
    }

    private static final String convertSectionSignToMiniMessage$processSection(Map<String, String> sectionMap, String segment) {
        CharSequence charSequence = segment;
        Regex regex = new Regex("\u00a7([0-9a-fklmnor])");
        Function1<MatchResult, CharSequence> function1 = arg_0 -> MessageHandler.convertSectionSignToMiniMessage$processSection$lambda$12(sectionMap, arg_0);
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence convertHexToMiniMessage$lambda$13(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String hex = it.getGroupValues().get(1);
        return "<#" + hex + ">";
    }

    private static final CharSequence convertUnicodeEscapeSequences$lambda$14(MatchResult matchResult) {
        Intrinsics.checkNotNullParameter(matchResult, "matchResult");
        int codePoint = Integer.parseInt(matchResult.getGroupValues().get(1), CharsKt.checkRadix(16));
        char[] cArray = Character.toChars(codePoint);
        Intrinsics.checkNotNullExpressionValue(cArray, "toChars(...)");
        char[] cArray2 = cArray;
        return new String(cArray2);
    }
}

