/*
 * Decompiled with CFR 0.152.
 */
package pl.syntaxdevteam.cleanerx.common;

import java.io.Closeable;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import pl.syntaxdevteam.cleanerx.CleanerX;
import pl.syntaxdevteam.cleanerx.common.PluginManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lpl/syntaxdevteam/cleanerx/common/StatsCollector;", "", "plugin", "Lpl/syntaxdevteam/cleanerx/CleanerX;", "<init>", "(Lpl/syntaxdevteam/cleanerx/CleanerX;)V", "serverIP", "", "serverPort", "", "serverVersion", "Lorg/jetbrains/annotations/NotNull;", "serverName", "statsUrl", "pluginName", "pluginUUID", "sendPing", "", "getExternalIP", "CleanerX-Paper"})
public final class StatsCollector {
    @NotNull
    private CleanerX plugin;
    @NotNull
    private final String serverIP;
    private final int serverPort;
    @NotNull
    private final String serverVersion;
    @NotNull
    private final String serverName;
    @NotNull
    private final String statsUrl;
    @NotNull
    private final String pluginName;
    @NotNull
    private final String pluginUUID;

    public StatsCollector(@NotNull CleanerX plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
        this.serverIP = this.getExternalIP();
        this.serverPort = this.plugin.getServer().getPort();
        String string = this.plugin.getServer().getVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getVersion(...)");
        this.serverVersion = string;
        String string2 = this.plugin.getServer().getName();
        Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        this.serverName = string2;
        this.statsUrl = "https://syntaxdevteam.pl/ping.php";
        this.pluginName = this.plugin.getName() + " " + this.plugin.getPluginMeta().getVersion();
        PluginManager pluginManager = this.plugin.getPluginsManager();
        String string3 = this.plugin.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "getName(...)");
        String string4 = pluginManager.getPluginUUID(string3);
        if (string4 == null) {
            string4 = "unknown";
        }
        this.pluginUUID = string4;
        if (this.plugin.getConfig().getBoolean("stats.enabled")) {
            this.sendPing();
        } else {
            this.plugin.getLogger().warning("StatsCollector is disabled in the configuration.");
        }
    }

    private final void sendPing() {
        CompletableFuture.runAsync(() -> StatsCollector.sendPing$lambda$3(this));
    }

    private final String getExternalIP() {
        String[] stringArray = new String[]{"https://api.ipify.org", "https://ifconfig.me/ip"};
        List<String> apis = CollectionsKt.listOf(stringArray);
        for (String api : apis) {
            try {
                URL uRL = new URI(api).toURL();
                Intrinsics.checkNotNullExpressionValue(uRL, "toURL(...)");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes(uRL2);
                return new String(byArray, charset);
            }
            catch (Exception e) {
                this.plugin.getLogger().debug("Failed to fetch IP from " + api + ": " + e.getMessage());
            }
        }
        return "unknown";
    }

    private static final CharSequence sendPing$lambda$3$lambda$2$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getKey() + "=" + it.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void sendPing$lambda$3(StatsCollector this$0) {
        try {
            URI uri = new URI(this$0.statsUrl);
            URLConnection uRLConnection = uri.toURL().openConnection();
            Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection $this$sendPing_u24lambda_u243_u24lambda_u242 = (HttpURLConnection)uRLConnection;
            boolean bl = false;
            $this$sendPing_u24lambda_u243_u24lambda_u242.setRequestMethod("POST");
            $this$sendPing_u24lambda_u243_u24lambda_u242.setDoOutput(true);
            $this$sendPing_u24lambda_u243_u24lambda_u242.setConnectTimeout(5000);
            $this$sendPing_u24lambda_u243_u24lambda_u242.setReadTimeout(5000);
            Object object = new Pair[]{TuplesKt.to("pluginName", this$0.pluginName), TuplesKt.to("serverIP", this$0.serverIP), TuplesKt.to("serverPort", String.valueOf(this$0.serverPort)), TuplesKt.to("serverVersion", this$0.serverVersion), TuplesKt.to("serverName", this$0.serverName), TuplesKt.to("pluginUUID", this$0.pluginUUID)};
            String data = CollectionsKt.joinToString$default(MapsKt.mapOf(object).entrySet(), "&", null, null, 0, null, StatsCollector::sendPing$lambda$3$lambda$2$lambda$0, 30, null);
            object = $this$sendPing_u24lambda_u243_u24lambda_u242.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)object;
                boolean bl2 = false;
                byte[] byArray = data.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue(byArray, "getBytes(...)");
                it.write(byArray);
                it.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            int responseCode = $this$sendPing_u24lambda_u243_u24lambda_u242.getResponseCode();
            boolean bl3 = 200 <= responseCode ? responseCode < 300 : false;
            if (bl3) {
                this$0.plugin.getLogger().debug("Stats sent successfully.");
            } else {
                this$0.plugin.getLogger().debug("Failed to send stats. Response code: " + responseCode + ".");
            }
        }
        catch (Exception e) {
            this$0.plugin.getLogger().warning("An error occurred while sending stats: " + e.getMessage());
        }
    }
}

