/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.eneryleen.attackIndicator.ConfigManager;
import org.eneryleen.attackIndicator.DamageListener;
import org.eneryleen.attackIndicator.LangManager;
import org.eneryleen.attackIndicator.PlayerToggleManager;
import org.eneryleen.attackIndicator.ReloadCommand;
import org.eneryleen.attackIndicator.UpdateChecker;
import org.eneryleen.attackIndicator.bstats.bukkit.Metrics;
import org.eneryleen.attackIndicator.indicator.IndicatorFactory;
import org.eneryleen.attackIndicator.indicator.IndicatorSpawner;

public final class AttackIndicator
extends JavaPlugin {
    private static AttackIndicator instance;
    private ConfigManager configManager;
    private LangManager langManager;
    private IndicatorSpawner indicatorManager;
    private PlayerToggleManager toggleManager;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.configManager.loadConfig();
        this.langManager = new LangManager(this);
        this.langManager.loadLanguage(this.configManager.getLanguage());
        this.toggleManager = new PlayerToggleManager(this);
        this.indicatorManager = IndicatorFactory.createIndicatorManager(this);
        this.getServer().getPluginManager().registerEvents((Listener)new DamageListener(this), (Plugin)this);
        ReloadCommand reloadCommand = new ReloadCommand(this);
        this.getCommand("attackindicator").setExecutor((CommandExecutor)reloadCommand);
        this.getCommand("attackindicator").setTabCompleter((TabCompleter)reloadCommand);
        int pluginId = 27487;
        new Metrics(this, pluginId);
        UpdateChecker updateChecker = new UpdateChecker(this);
        updateChecker.checkForUpdates();
        this.getLogger().info("AttackIndicator v" + this.getDescription().getVersion() + " enabled!");
    }

    public void onDisable() {
        if (this.indicatorManager != null) {
            this.indicatorManager.cleanup();
        }
        this.getLogger().info("AttackIndicator disabled!");
    }

    public static AttackIndicator getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LangManager getLangManager() {
        return this.langManager;
    }

    public IndicatorSpawner getIndicatorManager() {
        return this.indicatorManager;
    }

    public PlayerToggleManager getToggleManager() {
        return this.toggleManager;
    }
}

