/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.eneryleen.attackIndicator.AttackIndicator;

public class ConfigManager {
    private final AttackIndicator plugin;
    private FileConfiguration config;
    private String language;
    private String indicatorFormat;
    private int displayDuration;
    private double upwardSpeed;
    private double verticalOffset;
    private boolean randomOffsetEnabled;
    private double randomOffsetX;
    private double yOffset;
    private double randomOffsetZ;
    private DisplayMode displayMode;
    private Set<String> disabledWorlds;
    private boolean entityFilterWhitelist;
    private Set<EntityType> entityFilter;
    private boolean showOnPlayers;
    private float indicatorScale;

    public ConfigManager(AttackIndicator plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.language = this.config.getString("language", "en");
        this.indicatorFormat = this.config.getString("indicator-format", "<#ff5555>\u2764\ufe0f -{damage}");
        this.displayDuration = this.config.getInt("display-duration", 40);
        this.upwardSpeed = this.config.getDouble("upward-speed", 0.03);
        this.verticalOffset = this.config.getDouble("vertical-offset", 0.5);
        this.randomOffsetEnabled = this.config.getBoolean("random-offset.enabled", true);
        this.randomOffsetX = this.config.getDouble("random-offset.x", 0.5);
        this.yOffset = this.config.getDouble("random-offset.y", 0.5);
        this.randomOffsetZ = this.config.getDouble("random-offset.z", 0.5);
        String mode = this.config.getString("display-mode", "PLAYER_ONLY");
        try {
            this.displayMode = DisplayMode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid display-mode: " + mode + ", using PLAYER_ONLY");
            this.displayMode = DisplayMode.PLAYER_ONLY;
        }
        this.disabledWorlds = new HashSet<String>(this.config.getStringList("disabled-worlds"));
        this.showOnPlayers = this.config.getBoolean("show-on-players", false);
        this.indicatorScale = (float)this.config.getDouble("indicator-scale", 1.5);
        this.entityFilterWhitelist = this.config.getBoolean("entity-filter.whitelist-mode", false);
        this.entityFilter = new HashSet<EntityType>();
        List entityList = this.config.getStringList("entity-filter.entities");
        for (String entityName : entityList) {
            try {
                EntityType type = EntityType.valueOf((String)entityName.toUpperCase());
                this.entityFilter.add(type);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid entity type: " + entityName);
            }
        }
    }

    public String getLanguage() {
        return this.language;
    }

    public String getIndicatorFormat() {
        return this.indicatorFormat;
    }

    public int getDisplayDuration() {
        return this.displayDuration;
    }

    public double getUpwardSpeed() {
        return this.upwardSpeed;
    }

    public double getVerticalOffset() {
        return this.verticalOffset;
    }

    public boolean isRandomOffsetEnabled() {
        return this.randomOffsetEnabled;
    }

    public double getRandomOffsetX() {
        return this.randomOffsetX;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getRandomOffsetZ() {
        return this.randomOffsetZ;
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public Set<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public boolean isEntityFilterWhitelist() {
        return this.entityFilterWhitelist;
    }

    public Set<EntityType> getEntityFilter() {
        return this.entityFilter;
    }

    public boolean isWorldDisabled(String worldName) {
        return this.disabledWorlds.contains(worldName);
    }

    public boolean shouldShowForEntity(EntityType type) {
        if (this.entityFilter.isEmpty()) {
            return true;
        }
        if (this.entityFilterWhitelist) {
            return this.entityFilter.contains(type);
        }
        return !this.entityFilter.contains(type);
    }

    public boolean isShowOnPlayers() {
        return this.showOnPlayers;
    }

    public float getIndicatorScale() {
        return this.indicatorScale;
    }

    public static enum DisplayMode {
        ALL,
        PLAYER_ONLY,
        NO_SELF;

    }
}

