/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.eneryleen.attackIndicator.AttackIndicator;
import org.eneryleen.attackIndicator.ConfigManager;

public class DamageListener
implements Listener {
    private final AttackIndicator plugin;

    public DamageListener(AttackIndicator plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity victim = (LivingEntity)entity;
        ConfigManager config = this.plugin.getConfigManager();
        if (entity instanceof Player && !config.isShowOnPlayers()) {
            return;
        }
        if (config.isWorldDisabled(victim.getWorld().getName())) {
            return;
        }
        if (!config.shouldShowForEntity(victim.getType())) {
            return;
        }
        ConfigManager.DisplayMode mode = config.getDisplayMode();
        Player attacker = null;
        switch (mode) {
            case PLAYER_ONLY: {
                if (!(event instanceof EntityDamageByEntityEvent)) {
                    return;
                }
                EntityDamageByEntityEvent playerDamageEvent = (EntityDamageByEntityEvent)event;
                Entity damager = this.getDamager(playerDamageEvent.getDamager());
                if (!(damager instanceof Player)) {
                    return;
                }
                attacker = (Player)damager;
                break;
            }
            case NO_SELF: {
                if (!(event instanceof EntityDamageByEntityEvent)) break;
                EntityDamageByEntityEvent selfDamageEvent = (EntityDamageByEntityEvent)event;
                Entity actualDamager = this.getDamager(selfDamageEvent.getDamager());
                if (actualDamager != null && actualDamager.equals((Object)victim)) {
                    return;
                }
                if (!(actualDamager instanceof Player)) break;
                attacker = (Player)actualDamager;
                break;
            }
            case ALL: {
                EntityDamageByEntityEvent allDamageEvent;
                Entity allDamager;
                if (!(event instanceof EntityDamageByEntityEvent) || !((allDamager = this.getDamager((allDamageEvent = (EntityDamageByEntityEvent)event).getDamager())) instanceof Player)) break;
                attacker = (Player)allDamager;
            }
        }
        if (attacker != null && !this.plugin.getToggleManager().isEnabled(attacker.getUniqueId())) {
            return;
        }
        double damage = event.getFinalDamage();
        if (damage <= 0.0) {
            return;
        }
        this.plugin.getIndicatorManager().spawnIndicator(victim, damage);
    }

    private Entity getDamager(Entity damager) {
        if (damager instanceof Projectile) {
            Projectile projectile = (Projectile)damager;
            if (projectile.getShooter() instanceof Entity) {
                return (Entity)projectile.getShooter();
            }
            return null;
        }
        return damager;
    }
}

