/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eneryleen.attackIndicator.AttackIndicator;
import org.eneryleen.attackIndicator.indicator.legacy.TextFormatter;

public class LangManager {
    private final AttackIndicator plugin;
    private final Map<String, String> messages;
    private String language;

    public LangManager(AttackIndicator plugin) {
        this.plugin = plugin;
        this.messages = new HashMap<String, String>();
    }

    public void loadLanguage(String lang) {
        YamlConfiguration config;
        File langFile;
        this.language = lang;
        this.messages.clear();
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(langFile = new File(langFolder, lang + ".yml")).exists()) {
            this.plugin.saveResource("lang/" + lang + ".yml", false);
        }
        try {
            config = YamlConfiguration.loadConfiguration((File)langFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load language file: " + lang + ".yml, using English");
            InputStream defaultStream = this.plugin.getResource("lang/en.yml");
            if (defaultStream != null) {
                config = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            }
            return;
        }
        this.loadMessages((ConfigurationSection)config, "");
    }

    private void loadMessages(ConfigurationSection config, String path) {
        for (String key : config.getKeys(false)) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (config.isConfigurationSection(key)) {
                this.loadMessages(config.getConfigurationSection(key), fullPath);
                continue;
            }
            this.messages.put(fullPath, config.getString(key, ""));
        }
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, key);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    public String getFormatted(String key) {
        String message = this.getMessage(key);
        return TextFormatter.format(message);
    }

    public String getFormatted(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key, placeholders);
        return TextFormatter.format(message);
    }

    public String getLanguage() {
        return this.language;
    }
}

