/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.eneryleen.attackIndicator.AttackIndicator;

public class PlayerToggleManager {
    private final AttackIndicator plugin;
    private final Set<UUID> disabledPlayers;
    private final File dataFile;

    public PlayerToggleManager(AttackIndicator plugin) {
        this.plugin = plugin;
        this.disabledPlayers = new HashSet<UUID>();
        this.dataFile = new File(plugin.getDataFolder(), "disabled_players.yml");
        this.loadData();
    }

    public boolean isEnabled(UUID playerId) {
        return !this.disabledPlayers.contains(playerId);
    }

    public boolean toggle(UUID playerId) {
        if (this.disabledPlayers.contains(playerId)) {
            this.disabledPlayers.remove(playerId);
            this.saveData();
            return true;
        }
        this.disabledPlayers.add(playerId);
        this.saveData();
        return false;
    }

    public void setEnabled(UUID playerId, boolean enabled) {
        if (enabled) {
            this.disabledPlayers.remove(playerId);
        } else {
            this.disabledPlayers.add(playerId);
        }
        this.saveData();
    }

    private void loadData() {
        if (!this.dataFile.exists()) {
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.dataFile);
        for (String uuidString : config.getStringList("disabled")) {
            try {
                this.disabledPlayers.add(UUID.fromString(uuidString));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void saveData() {
        YamlConfiguration config = new YamlConfiguration();
        ArrayList<String> uuidList = new ArrayList<String>();
        for (UUID uuid : this.disabledPlayers) {
            uuidList.add(uuid.toString());
        }
        config.set("disabled", uuidList);
        try {
            config.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save disabled players data: " + e.getMessage());
        }
    }
}

