/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.eneryleen.attackIndicator.AttackIndicator;
import org.eneryleen.attackIndicator.LangManager;

public class ReloadCommand
implements CommandExecutor,
TabCompleter {
    private final AttackIndicator plugin;

    public ReloadCommand(AttackIndicator plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        LangManager lang = this.plugin.getLangManager();
        if (args.length == 0) {
            sender.sendMessage(lang.getFormatted("command.usage"));
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("attackindicator.reload")) {
                sender.sendMessage(lang.getFormatted("command.no-permission"));
                return true;
            }
            try {
                this.plugin.getConfigManager().loadConfig();
                this.plugin.getLangManager().loadLanguage(this.plugin.getConfigManager().getLanguage());
                sender.sendMessage(lang.getFormatted("command.reload-success"));
            }
            catch (Exception e) {
                HashMap<String, String> placeholders = new HashMap<String, String>();
                placeholders.put("error", e.getMessage());
                sender.sendMessage(lang.getFormatted("command.reload-error", placeholders));
                this.plugin.getLogger().severe("Failed to reload configuration: " + e.getMessage());
                e.printStackTrace();
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("toggle")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(lang.getFormatted("command.player-only"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("attackindicator.toggle")) {
                sender.sendMessage(lang.getFormatted("command.no-permission"));
                return true;
            }
            boolean enabled = this.plugin.getToggleManager().toggle(player.getUniqueId());
            if (enabled) {
                sender.sendMessage(lang.getFormatted("command.toggle-enabled"));
            } else {
                sender.sendMessage(lang.getFormatted("command.toggle-disabled"));
            }
            return true;
        }
        sender.sendMessage(lang.getFormatted("command.unknown-subcommand"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String input = args[0].toLowerCase();
            if (sender.hasPermission("attackindicator.reload") && "reload".startsWith(input)) {
                completions.add("reload");
            }
            if (sender.hasPermission("attackindicator.toggle") && "toggle".startsWith(input)) {
                completions.add("toggle");
            }
        }
        return completions;
    }
}

