/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.eneryleen.attackIndicator.gson.JsonArray;
import org.eneryleen.attackIndicator.gson.JsonElement;
import org.eneryleen.attackIndicator.gson.JsonParser;

public class UpdateChecker {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/%s/version";
    private static final String PROJECT_ID = "attack-indicator";
    private static final String USER_AGENT = "AttackIndicator/2.1 (github.com/eneryleen/attack-indicator)";
    private final JavaPlugin plugin;
    private final Logger logger;
    private final String currentVersion;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void checkForUpdates() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HttpURLConnection connection = null;
            BufferedReader reader = null;
            try {
                String line;
                String apiUrl = String.format(MODRINTH_API_URL, PROJECT_ID);
                URL url = new URL(apiUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", USER_AGENT);
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.logger.warning("Failed to check for updates: HTTP " + responseCode);
                    return;
                }
                reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JsonArray versions = JsonParser.parseString(response.toString()).getAsJsonArray();
                if (versions.size() == 0) {
                    return;
                }
                JsonElement latestVersionElement = versions.get(0).getAsJsonObject().get("version_number");
                String latestVersion = latestVersionElement.getAsString();
                if (!this.currentVersion.equals(latestVersion)) {
                    this.logger.warning("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                    this.logger.warning("\u2551                                                      \u2551");
                    this.logger.warning("\u2551   A new version of AttackIndicator is available!     \u2551");
                    this.logger.warning("\u2551                                                      \u2551");
                    this.logger.warning("\u2551   Current version: " + String.format("%-27s", this.currentVersion) + "       \u2551");
                    this.logger.warning("\u2551   Latest version:  " + String.format("%-27s", latestVersion) + "       \u2551");
                    this.logger.warning("\u2551                                                      \u2551");
                    this.logger.warning("\u2551   https://modrinth.com/plugin/attack-indicator       \u2551");
                    this.logger.warning("\u2551                                                      \u2551");
                    this.logger.warning("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                } else {
                    this.logger.info("AttackIndicator is up to date!");
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed to check for updates: " + e.getMessage());
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        });
    }
}

