/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator.indicator.legacy;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.eneryleen.attackIndicator.AttackIndicator;
import org.eneryleen.attackIndicator.ConfigManager;
import org.eneryleen.attackIndicator.indicator.IndicatorSpawner;
import org.eneryleen.attackIndicator.indicator.legacy.TextFormatter;

public class LegacyIndicatorManager
implements IndicatorSpawner {
    private final AttackIndicator plugin;
    private final DecimalFormat damageFormat;
    private final Random random;
    private final Set<ArmorStand> activeIndicators;

    public LegacyIndicatorManager(AttackIndicator plugin) {
        this.plugin = plugin;
        this.damageFormat = new DecimalFormat("0.#");
        this.random = new Random();
        this.activeIndicators = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void spawnIndicator(LivingEntity entity, double damage) {
        ConfigManager config = this.plugin.getConfigManager();
        Location location = entity.getLocation().clone();
        double entityHeight = this.getEntityHeight(entity);
        location.add(0.0, entityHeight + config.getVerticalOffset(), 0.0);
        if (config.isRandomOffsetEnabled()) {
            double offsetX = (this.random.nextDouble() - 0.5) * config.getRandomOffsetX();
            double offsetY = (this.random.nextDouble() - 0.5) * config.getYOffset();
            double offsetZ = (this.random.nextDouble() - 0.5) * config.getRandomOffsetZ();
            location.add(offsetX, offsetY, offsetZ);
        }
        String damageText = this.damageFormat.format(damage);
        String formattedText = config.getIndicatorFormat().replace("{damage}", damageText);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            String displayText = TextFormatter.format(formattedText);
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location, ArmorStand.class);
            armorStand.setCustomName(displayText);
            armorStand.setCustomNameVisible(true);
            armorStand.setVisible(false);
            armorStand.setGravity(false);
            try {
                armorStand.setMarker(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                armorStand.setInvulnerable(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                armorStand.setSmall(true);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                armorStand.setBasePlate(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            try {
                armorStand.setArms(false);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.activeIndicators.add(armorStand);
            this.animateIndicator(armorStand, config.getUpwardSpeed(), config.getDisplayDuration());
        });
    }

    private void animateIndicator(final ArmorStand armorStand, final double speed, final int duration) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!armorStand.isValid() || this.ticks >= duration) {
                    armorStand.remove();
                    LegacyIndicatorManager.this.activeIndicators.remove(armorStand);
                    this.cancel();
                    return;
                }
                Location newLocation = armorStand.getLocation().add(0.0, speed, 0.0);
                armorStand.teleport(newLocation);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private double getEntityHeight(LivingEntity entity) {
        try {
            return entity.getHeight();
        }
        catch (NoSuchMethodError e) {
            return 1.5;
        }
    }

    @Override
    public void cleanup() {
        for (ArmorStand armorStand : this.activeIndicators) {
            if (!armorStand.isValid()) continue;
            armorStand.remove();
        }
        this.activeIndicators.clear();
    }
}

