/*
 * Decompiled with CFR 0.152.
 */
package org.eneryleen.attackIndicator.indicator.modern;

import java.text.DecimalFormat;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Location;
import org.bukkit.entity.Display;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.eneryleen.attackIndicator.AttackIndicator;
import org.eneryleen.attackIndicator.ConfigManager;
import org.eneryleen.attackIndicator.indicator.IndicatorSpawner;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModernIndicatorManager
implements IndicatorSpawner {
    private final AttackIndicator plugin;
    private final MiniMessage miniMessage;
    private final DecimalFormat damageFormat;
    private final Random random;
    private final Set<TextDisplay> activeIndicators;

    public ModernIndicatorManager(AttackIndicator plugin) {
        this.plugin = plugin;
        this.miniMessage = MiniMessage.miniMessage();
        this.damageFormat = new DecimalFormat("0.#");
        this.random = new Random();
        this.activeIndicators = ConcurrentHashMap.newKeySet();
    }

    @Override
    public void spawnIndicator(LivingEntity entity, double damage) {
        ConfigManager config = this.plugin.getConfigManager();
        Location location = entity.getLocation().clone();
        double entityHeight = entity.getHeight();
        location.add(0.0, entityHeight + config.getVerticalOffset(), 0.0);
        if (config.isRandomOffsetEnabled()) {
            double offsetX = (this.random.nextDouble() - 0.5) * config.getRandomOffsetX();
            double offsetY = (this.random.nextDouble() - 0.5) * config.getYOffset();
            double offsetZ = (this.random.nextDouble() - 0.5) * config.getRandomOffsetZ();
            location.add(offsetX, offsetY, offsetZ);
        }
        String damageText = this.damageFormat.format(damage);
        String formattedText = config.getIndicatorFormat().replace("{damage}", damageText);
        Component textComponent = this.miniMessage.deserialize((Object)formattedText);
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
            TextDisplay display = (TextDisplay)location.getWorld().spawn(location, TextDisplay.class, textDisplay -> {
                textDisplay.text(textComponent);
                textDisplay.setBillboard(Display.Billboard.CENTER);
                textDisplay.setAlignment(TextDisplay.TextAlignment.CENTER);
                textDisplay.setSeeThrough(true);
                float scale = config.getIndicatorScale();
                Transformation transformation = textDisplay.getTransformation();
                transformation.getScale().set((Vector3fc)new Vector3f(scale, scale, scale));
                textDisplay.setTransformation(transformation);
            });
            this.activeIndicators.add(display);
            this.animateIndicator(display, config.getUpwardSpeed(), config.getDisplayDuration());
        });
    }

    private void animateIndicator(final TextDisplay display, final double speed, final int duration) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (!display.isValid() || this.ticks >= duration) {
                    display.remove();
                    ModernIndicatorManager.this.activeIndicators.remove(display);
                    this.cancel();
                    return;
                }
                Location newLocation = display.getLocation().add(0.0, speed, 0.0);
                display.teleport(newLocation);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @Override
    public void cleanup() {
        for (TextDisplay display : this.activeIndicators) {
            if (!display.isValid()) continue;
            display.remove();
        }
        this.activeIndicators.clear();
    }
}

