package qouteall.imm_ptl.peripheral;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.commands.PortalCommand;
import qouteall.q_misc_util.MiscHelper;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CommandStickItem extends class_1792 {
    public record Data(
        String command, String nameTranslationKey, List<String> descriptionTranslationKeys
    ) {
        public void serialize(class_2487 tag) {
            tag.method_10582("command", command);
            tag.method_10582("nameTranslationKey", nameTranslationKey);
            class_2499 listTag = new class_2499();
            for (String descriptionTK : descriptionTranslationKeys) {
                listTag.add(class_2519.method_23256(descriptionTK));
            }
            tag.method_10566("descriptionTranslationKeys", listTag);
        }
        
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            serialize(tag);
            return tag;
        }
        
        public static Data deserialize(class_2487 tag) {
            return new Data(
                tag.method_10558("command"),
                tag.method_10558("nameTranslationKey"),
                tag.method_10554(
                        "descriptionTranslationKeys",
                        class_2519.method_23256("").method_10711()
                    )
                    .stream()
                    .map(tag1 -> ((class_2519) tag1).method_10714())
                    .collect(Collectors.toList())
            );
        }
    }
    
    public static final LinkedHashMap<String, Data> BUILT_IN_COMMAND_STICK_TYPES = new LinkedHashMap<>();
    
    public static void registerBuiltInCommandStick(Data data) {
        BUILT_IN_COMMAND_STICK_TYPES.put(data.command, data);
    }
    
    public static final CommandStickItem instance = new CommandStickItem(
        new class_1792.class_1793()
    );
    
    public CommandStickItem(class_1793 settings) {
        super(settings);
    }
    
    // display enchantment glint
    @Override
    public boolean method_7886(class_1799 stack) {
        return true;
    }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        doUse(player, player.method_5998(hand));
        return super.method_7836(world, player, hand);
    }
    
    private void doUse(class_1657 player, class_1799 stack) {
        if (player.method_37908().method_8608()) {
            return;
        }
        
        if (canUseCommand(player)) {
            Data data = Data.deserialize(stack.method_7948());
            
            class_2168 commandSource = player.method_5671().method_9206(2);
            
            class_2170 commandManager = MiscHelper.getServer().method_3734();
            
            String command = data.command;
            
            if (command.startsWith("/")) {
                // it seems not accepting "/" in the beginning
                command = command.substring(1);
            }
            
            commandManager.method_44252(commandSource, command);
        }
        else {
            sendMessage(player, class_2561.method_43470("No Permission"));
        }
    }
    
    private static boolean canUseCommand(class_1657 player) {
        if (IPGlobal.easeCommandStickPermission) {
            return true;// any player regardless of gamemode can use
        }
        else {
            return player.method_5687(2) || player.method_7337();
        }
    }
    
    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        
        Data data = Data.deserialize(stack.method_7948());
        
        Iterable<String> splitCommand = Splitter.fixedLength(40).split(data.command);
        
        for (String commandPortion : splitCommand) {
            tooltip.add(class_2561.method_43470(commandPortion).method_27692(class_124.field_1065));
        }
        
        for (String descriptionTranslationKey : data.descriptionTranslationKeys) {
            tooltip.add(class_2561.method_43471(descriptionTranslationKey).method_27692(class_124.field_1075));
        }
        
        tooltip.add(class_2561.method_43471("imm_ptl.command_stick").method_27692(class_124.field_1080));
    }
    
    @Override
    public String method_7866(class_1799 stack) {
        Data data = Data.deserialize(stack.method_7948());
        return data.nameTranslationKey;
    }
    
    public static void sendMessage(class_1657 player, class_2561 message) {
        ((class_3222) player).method_43496(message);
    }
    
    public static void init() {
        PortalCommand.createCommandStickCommandSignal.connect((player, command) -> {
            class_1799 itemStack = new class_1799(instance, 1);
            Data data = new Data(
                command, command, new ArrayList<>()
            );
            data.serialize(itemStack.method_7948());
            
            player.method_31548().method_7394(itemStack);
            player.field_7498.method_7623();
        });
        
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(
            groupEntries -> {
                for (Data data : BUILT_IN_COMMAND_STICK_TYPES.values()) {
                    class_1799 stack = new class_1799(instance);
                    data.serialize(stack.method_7948());
                    groupEntries.method_45420(stack);
                }
            }
        );
    }
    
    public static void registerCommandStickTypes() {
        registerPortalSubCommandStick("delete_portal");
        registerPortalSubCommandStick("remove_connected_portals");
        registerPortalSubCommandStick("eradicate_portal_cluster");
        registerPortalSubCommandStick("complete_bi_way_bi_faced_portal");
        registerPortalSubCommandStick("complete_bi_way_portal");
        registerPortalSubCommandStick("move_portal_front", "move_portal 0.5");
        registerPortalSubCommandStick("move_portal_back", "move_portal -0.5");
        registerPortalSubCommandStick(
            "move_portal_destination_front", "move_portal_destination 0.5"
        );
        registerPortalSubCommandStick(
            "move_portal_destination_back", "move_portal_destination -0.5"
        );
        registerPortalSubCommandStick(
            "rotate_x", "rotate_portal_rotation_along x 15"
        );
        registerPortalSubCommandStick(
            "rotate_y", "rotate_portal_rotation_along y 15"
        );
        registerPortalSubCommandStick(
            "rotate_z", "rotate_portal_rotation_along z 15"
        );
        registerPortalSubCommandStick(
            "make_unbreakable", "nbt {unbreakable:true}"
        );
        registerPortalSubCommandStick(
            "make_fuse_view", "nbt {fuseView:true}"
        );
        registerPortalSubCommandStick(
            "enable_pos_adjust", "nbt {adjustPositionAfterTeleport:true}"
        );
        registerPortalSubCommandStick(
            "disable_rendering_yourself", "nbt {doRenderPlayer:false}"
        );
        registerPortalSubCommandStick(
            "enable_isometric", "debug isometric_enable 50"
        );
        registerPortalSubCommandStick(
            "disable_isometric", "debug isometric_disable"
        );
        registerPortalSubCommandStick(
            "create_5_connected_rooms", "create_connected_rooms roomSize 6 4 6 roomNumber 5"
        );
        registerPortalSubCommandStick(
            "accelerate50", "debug accelerate 50"
        );
        registerPortalSubCommandStick(
            "accelerate200", "debug accelerate 200"
        );
        registerPortalSubCommandStick(
            "reverse_accelerate50", "debug accelerate -50"
        );
        registerPortalSubCommandStick(
            "enable_gravity_change", "nbt {teleportChangesGravity:true}"
        );
        registerPortalSubCommandStick(
            "make_invisible", "nbt {isVisible:false}"
        );
        registerPortalSubCommandStick(
            "make_visible", "nbt {isVisible:true}"
        );
        registerPortalSubCommandStick(
            "disable_default_animation", "nbt {defaultAnimation:{durationTicks:0}}"
        );
        
        registerPortalSubCommandStick(
            "pause_animation", "animation pause"
        );
        registerPortalSubCommandStick(
            "resume_animation", "animation resume"
        );
        
        registerPortalSubCommandStick(
            "rotate_around_y", "animation rotate_infinitely @s 0 1 0 1.0"
        );
        registerPortalSubCommandStick(
            "rotate_randomly", "animation rotate_infinitely_random"
        );
        registerBuiltInCommandStick(
            new Data(
                "execute positioned 0.0 0.0 0.0 run portal animation rotate_infinitely @p ^0.0 ^0.0 ^1.0 1.7",
                "imm_ptl.command.rotate_around_view",
                Lists.newArrayList("imm_ptl.command_dest.rotate_around_view")
            )
        );
        registerPortalSubCommandStick(
            "expand_from_center", "animation expand_from_center 20"
        );
        registerPortalSubCommandStick(
            "clear_animation", "animation clear"
        );
        
        registerPortalSubCommandStick(
            "sculpt", "shape sculpt"
        );
        registerPortalSubCommandStick(
            "reset_shape", "shape reset"
        );
        
        registerBuiltInCommandStick(new Data(
            "/scale set pehkui:base 1",
            "imm_ptl.command.reset_scale",
            Lists.newArrayList("imm_ptl.command_desc.reset_scale")
        ));
        registerBuiltInCommandStick(new Data(
            "/scale set pehkui:reach 5",
            "imm_ptl.command.long_reach",
            Lists.newArrayList("imm_ptl.command_desc.long_reach")
        ));
        registerBuiltInCommandStick(new Data(
            "/effect give @s minecraft:night_vision 9999 1 true",
            "imm_ptl.command.night_vision",
            List.of()
        ));
        
        registerPortalSubCommandStick(
            "goback"
        );
        registerPortalSubCommandStick(
            "show_wiki", "wiki"
        );
    }
    
    private static Data registerPortalSubCommandStick(String name) {
        return registerPortalSubCommandStick(name, name);
    }
    
    private static Data registerPortalSubCommandStick(String name, String subCommand) {
        Data data = new Data(
            "/portal " + subCommand,
            "imm_ptl.command." + name,
            Lists.newArrayList("imm_ptl.command_desc." + name)
        );
        registerBuiltInCommandStick(data);
        return data;
    }
    
}
