package qouteall.imm_ptl.peripheral;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5489;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

import java.util.TreeMap;

/**
 * Make this because {@link class_329#method_1758(class_2561, boolean)} does not support multi-line
 */
@Environment(EnvType.CLIENT)
public class ImmPtlCustomOverlay {
    
    public static record Entry(
        class_2561 component,
        long clearingTime
    ) {}
    
    private static final TreeMap<String, Entry> ENTRIES = new TreeMap<>();
    
    @Nullable
    private static class_5489 multiLineLabelCache;
    
    public static void putText(class_2561 component, double durationSeconds, String key) {
        ENTRIES.put(
            key,
            new Entry(
                component,
                System.nanoTime() + Helper.secondToNano(durationSeconds)
            )
        );
        multiLineLabelCache = null;
    }
    
    public static void putText(class_2561 component, double durationSeconds) {
        putText(component, durationSeconds, "5_defaultKey");
    }
    
    public static void putText(class_2561 component, String key) {
        putText(component, 0.2, key);
    }
    
    public static void putText(class_2561 component) {
        putText(component, 0.2, "5_defaultKey");
    }
    
    public static boolean remove(String key) {
        return ENTRIES.remove(key) != null;
    }
    
    /**
     * {@link class_329#method_1753(class_332, float)}
     * {@link net.minecraft.class_403}
     */
    public static void render(class_332 guiGraphics, float partialTick) {
        long currTime = System.nanoTime();
        
        boolean removes = ENTRIES.entrySet().removeIf(e -> e.getValue().clearingTime < currTime);
        if (removes) {
            multiLineLabelCache = null;
        }
        
        if (ENTRIES.isEmpty()) {
            return;
        }
        
        if (multiLineLabelCache == null) {
            // don't make the first component the base component
            // to avoid style override
            class_5250 component = class_2561.method_43473();
            boolean isBeginning = true;
            for (Entry entry : ENTRIES.values()) {
                if (isBeginning) {
                    isBeginning = false;
                }
                else {
                    component.method_27693("\n");
                }
                component.method_10852(entry.component());
            }
            
            multiLineLabelCache = class_5489.method_30890(
                class_310.method_1551().field_1772,
                component,
                (class_310.method_1551().method_22683().method_4486() - 20)
            );
            assert multiLineLabelCache != null;
        }
        
        class_310 minecraft = class_310.method_1551();
        
        guiGraphics.method_51448().method_22903();
        
        int guiScaledWidth = minecraft.method_22683().method_4486();
        int guiScaledHeight = minecraft.method_22683().method_4502();
        
        class_327 font = minecraft.field_1705.method_1756();
        
        minecraft.method_16011().method_15396("imm_ptl_custom_overlay");
        // Note: the parchment names are incorrect
        multiLineLabelCache.method_30888(
            guiGraphics,
            guiScaledWidth / 2, (int) (guiScaledHeight * 0.75)
        );
        guiGraphics.method_51448().method_22909();
        
        minecraft.method_16011().method_15407();
    }
}
