package qouteall.imm_ptl.peripheral.alternate_dimension;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7059;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEWorld;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;

import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.Optional;

public class AlternateDimensions {
//    public static final HolderLookup.Provider vanillaRegistriesLookup = VanillaRegistries.createLookup();
    
    public static void init() {
        DimensionAPI.serverDimensionsLoadEvent.register(AlternateDimensions::initializeAlternateDimensions);
        
        IPGlobal.postServerTickSignal.connect(AlternateDimensions::tick);
    }
    
    private static void initializeAlternateDimensions(
        class_5285 worldOptions, class_5455 registryManager
    ) {
        class_2378<class_5363> registry = registryManager.method_30530(class_7924.field_41224);
        
        long seed = worldOptions.method_28028();
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        
        class_6880<class_2874> surfaceTypeHolder = registryManager
            .method_30530(class_7924.field_41241)
            .method_40264(class_5321.method_29179(
                class_7924.field_41241,
                new class_2960("immersive_portals:surface_type")
            ))
            .orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type"));
        
        class_6880<class_2874> surfaceTypeBrightHolder = registryManager
            .method_30530(class_7924.field_41241)
            .method_40264(class_5321.method_29179(
                class_7924.field_41241,
                new class_2960("immersive_portals:surface_type_bright")
            ))
            .orElseThrow(() -> new RuntimeException("Missing immersive_portals:surface_type_bright"));
        
        DimensionAPI.addDimension(
            registry,
            alternate1.method_29177(),
            surfaceTypeBrightHolder,
            createSkylandGenerator(registryManager, seed)
        );
        
        DimensionAPI.addDimension(
            registry,
            alternate2.method_29177(),
            surfaceTypeHolder,
            createSkylandGenerator(registryManager, seed + 1) // different seed
        );
        
        DimensionAPI.addDimension(
            registry,
            alternate3.method_29177(),
            surfaceTypeHolder,
            createErrorTerrainGenerator(seed + 1, registryManager)
        );
        
        DimensionAPI.addDimension(
            registry,
            alternate4.method_29177(),
            surfaceTypeHolder,
            createErrorTerrainGenerator(seed, registryManager)
        );
        
        DimensionAPI.addDimension(
            registry,
            alternate5.method_29177(),
            surfaceTypeHolder,
            createVoidGenerator(registryManager)
        );
    }
    
    
    public static final class_5321<class_2874> surfaceType = class_5321.method_29179(
        class_7924.field_41241,
        new class_2960("immersive_portals:surface_type")
    );
    public static final class_5321<class_1937> alternate1 = class_5321.method_29179(
        class_7924.field_41223,
        new class_2960("immersive_portals:alternate1")
    );
    public static final class_5321<class_1937> alternate2 = class_5321.method_29179(
        class_7924.field_41223,
        new class_2960("immersive_portals:alternate2")
    );
    public static final class_5321<class_1937> alternate3 = class_5321.method_29179(
        class_7924.field_41223,
        new class_2960("immersive_portals:alternate3")
    );
    public static final class_5321<class_1937> alternate4 = class_5321.method_29179(
        class_7924.field_41223,
        new class_2960("immersive_portals:alternate4")
    );
    public static final class_5321<class_1937> alternate5 = class_5321.method_29179(
        class_7924.field_41223,
        new class_2960("immersive_portals:alternate5")
    );
    
    public static boolean isAlternateDimension(class_1937 world) {
        final class_5321<class_1937> key = world.method_27983();
        return key == alternate1 ||
            key == alternate2 ||
            key == alternate3 ||
            key == alternate4 ||
            key == alternate5;
    }
    
    private static void syncWithOverworldTimeWeather(@Nullable class_3218 world, class_3218 overworld) {
        if (world == null) {
            return;
        }
        ((IEWorld) world).portal_setWeather(
            overworld.method_8430(1), overworld.method_8430(1),
            overworld.method_8478(1), overworld.method_8478(1)
        );
    }
    
    public static class_2794 createSkylandGenerator(class_5455 rm, long seed) {
        return NormalSkylandGenerator.create(
            rm.method_30530(class_7924.field_41236).method_46771(),
            rm.method_30530(class_7924.field_41240).method_46771(),
            rm.method_30530(class_7924.field_41244).method_46771(),
            rm.method_30530(class_7924.field_41243).method_46771(),
            rm.method_30530(class_7924.field_43089).method_46771(),
            seed
        );
    }
    
    public static class_2794 createErrorTerrainGenerator(long seed, class_5455 rm) {
        return ErrorTerrainGenerator.create(
            rm.method_30530(class_7924.field_41236).method_46771(),
            rm.method_30530(class_7924.field_41243).method_46771()
        );
    }
    
    public static class_2794 createVoidGenerator(class_5455 rm) {
        class_2378<class_1959> biomeRegistry = rm.method_30530(class_7924.field_41236);
        
        class_2378<class_7059> structureSets = rm.method_30530(class_7924.field_41248);
        
        class_6880.class_6883<class_1959> plainsHolder = biomeRegistry.method_40290(class_1972.field_9451);
        
        class_3232 flatChunkGeneratorConfig =
            new class_3232(
                Optional.of(class_6885.method_40246()),
                plainsHolder,
                List.of()
            );
        flatChunkGeneratorConfig.method_14327().add(new class_3229(1, class_2246.field_10124));
        flatChunkGeneratorConfig.method_14330();
        
        return new class_2897(flatChunkGeneratorConfig);
    }
    
    
    private static void tick() {
        if (!IPGlobal.enableAlternateDimensions) {
            return;
        }
        
        class_3218 overworld = McHelper.getServerWorld(class_1937.field_25179);
        
        MinecraftServer server = MiscHelper.getServer();
        
        syncWithOverworldTimeWeather(server.method_3847(alternate1), overworld);
        syncWithOverworldTimeWeather(server.method_3847(alternate2), overworld);
        syncWithOverworldTimeWeather(server.method_3847(alternate3), overworld);
        syncWithOverworldTimeWeather(server.method_3847(alternate4), overworld);
        syncWithOverworldTimeWeather(server.method_3847(alternate5), overworld);
    }
}
