package qouteall.imm_ptl.peripheral.alternate_dimension;

import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class ErrorTerrainComposition {
    
    
    public static final class_2680 air = class_2246.field_10124.method_9564();
    public static final class_2680 stone = class_2246.field_10340.method_9564();
    public static final class_2680 water = class_2246.field_10382.method_9564();
    
    public static final RegionErrorTerrainGenerator.Composition mountain = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        if (funcValue > middle) {
            if (funcValue > middle * middle) {
                return air;
            }
            else {
                return stone;
            }
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition classicalSolid = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint = getSplitPointClassical(worldY, middle, 32.0);
        
        if (funcValue > splitPoint) {
            return stone;
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition classicalHollow = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint = getSplitPointClassical(worldY, middle, 32.0);
        
        if (funcValue > splitPoint) {
            if (funcValue > splitPoint + 2) {
                return air;
            }
            else {
                return stone;
            }
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition classicalWatery = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint = getSplitPointClassical(worldY, middle, 16.0);
        
        if (funcValue > splitPoint) {
            if (((int) funcValue) % 23 == 0) {
                return water;
            }
            else {
                return stone;
            }
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition newSolid = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint1 = Math.abs(middle);
        splitPoint1 *= Math.exp(Math.abs(worldY - ErrorTerrainGenerator.averageY) / 32.0 - 1);
        
        splitPoint1 *= Math.max(
            1.0,
            100.0 / Math.max(1, Math.min(worldY, ErrorTerrainGenerator.maxY - worldY))
        );
        double splitPoint = splitPoint1;
        
        if (funcValue > splitPoint) {
            return stone;
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition floatingSea = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint = getSplitPointClassical(worldY, middle, 16.0);
        
        if (funcValue > splitPoint) {
            if (worldY > 63) {
                return water;
            }
            else {
                return stone;
            }
        }
        else {
            return air;
        }
    };
    
    public static final RegionErrorTerrainGenerator.Composition treasured = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        if (worldY > 32) {
            return air;
        }
        
        double upPoint = Math.max(middle, Math.max(upMiddle, downMiddle));
        double splitPoint = class_3532.method_16436(
            Math.abs(worldY - 32) / 32.0,
            middle,
            worldY > 32 ? upMiddle : downMiddle
        );
        if (funcValue > splitPoint) {
            if (((int) funcValue) % 37 == 0) {
                class_2248 randomBlock = class_7923.field_41175.method_10240(class_5819.method_43047()).get().comp_349();
                //player should not get beacon so easily
                if (randomBlock == class_2246.field_10327) {
                    randomBlock = class_2246.field_10124;
                }
                return randomBlock.method_9564();
            }
        }
        return air;
    };
    
    public static final RegionErrorTerrainGenerator.Composition layeredHollow = (
        worldY, funcValue, middle, upMiddle, downMiddle, worldX, worldZ
    ) -> {
        double splitPoint = getSplitPointClassical(worldY, middle, 32.0);
        
        
        if (funcValue > splitPoint) {
            double v = (funcValue - splitPoint) / 4;
            
            if (v > Math.floor(v) + 0.5) {
                return air;
            }
            else {
                return stone;
            }
        }
        else {
            return air;
        }
    };
    
    private static double getSplitPointClassical(int worldY, double middle, double unitFactor) {
        double splitPoint = middle;
        splitPoint *= Math.exp(Math.abs(worldY - ErrorTerrainGenerator.averageY) / unitFactor);
        
        splitPoint *= Math.max(
            0.7,
            30.0 / Math.max(1, Math.min(worldY, ErrorTerrainGenerator.maxY - worldY))
        );
        return splitPoint;
    }
    
    public static final RandomSelector<RegionErrorTerrainGenerator.Composition> selector =
        new RandomSelector.Builder<RegionErrorTerrainGenerator.Composition>()
            .add(25, mountain)
            .add(40, classicalSolid)
            .add(50, classicalHollow)
            .add(10, classicalWatery)
            .add(10, newSolid)
            .add(30, floatingSea)
            .add(1, treasured)
            .add(15, layeredHollow)
            .build();
}
