package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import qouteall.q_misc_util.Helper;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class ErrorTerrainGenerator extends DelegatedChunkGenerator {
    
    public static final Codec<ErrorTerrainGenerator> codec = RecordCodecBuilder.create(
        instance -> instance.group(
                class_6903.method_46636(class_7924.field_41236),
                class_6903.method_46636(class_7924.field_41243)
            )
            .apply(instance, ErrorTerrainGenerator::create)
    );
    
    public static ErrorTerrainGenerator create(
        class_7871<class_1959> biomeHolderGetter,
        class_7871<class_5284> noiseGeneratorSettingsHolderGetter
    ) {
        ChaosBiomeSource chaosBiomeSource = ChaosBiomeSource.createChaosBiomeSource(biomeHolderGetter);
        
        class_5284 skylandSetting = noiseGeneratorSettingsHolderGetter
            .method_46747(class_5284.field_26360).comp_349();
        
        class_3754 islandChunkGenerator = new class_3754(
            chaosBiomeSource, class_6880.method_40223(skylandSetting)
        );
        
        return new ErrorTerrainGenerator(
            chaosBiomeSource, islandChunkGenerator
        );
    }
    
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    
    private final class_2680 air = class_2246.field_10124.method_9564();
    private final class_2680 defaultBlock = class_2246.field_10340.method_9564();
    private final class_2680 defaultFluid = class_2246.field_10382.method_9564();
    
    private final LoadingCache<class_1923, RegionErrorTerrainGenerator> cache;
    
    
    public ErrorTerrainGenerator(
        class_1966 biomeSource, class_2794 delegate
    ) {
        super(biomeSource, delegate);
        
        cache = CacheBuilder.newBuilder()
            .maximumSize(10000)
            .expireAfterWrite(30, TimeUnit.SECONDS)
            .build(
                new CacheLoader<class_1923, RegionErrorTerrainGenerator>() {
                    public RegionErrorTerrainGenerator load(class_1923 key) {
                        return new RegionErrorTerrainGenerator(
                            key.field_9181, key.field_9180,
                            System.nanoTime()
                            // use the system time as seed
                            // there is no need to keep the error terrain generation consistent
                        );
                    }
                });
    }
    
    @Override
    protected Codec<? extends class_2794> method_28506() {
        return codec;
    }
    
    @Override
    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_2826[] sectionArray = chunkAccess.method_12006();
        ArrayList<class_2826> locked = new ArrayList<>();
        for (class_2826 chunkSection : sectionArray) {
            if (chunkSection != null) {
                chunkSection.method_16676();
                locked.add(chunkSection);
            }
        }
        return CompletableFuture.supplyAsync(() -> {
            doPopulateNoise(chunkAccess);
            return chunkAccess;
        }, executor).thenApplyAsync((chunkx) -> {
            for (class_2826 chunkSection : locked) {
                chunkSection.method_16677();
            }
            
            return chunkx;
        }, executor);
    }
    
    public void doPopulateNoise(class_2791 chunk) {
        class_2839 protoChunk = (class_2839) chunk;
        class_1923 pos = chunk.method_12004();
        class_2902 oceanFloorHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        
        int regionX = Math.floorDiv(pos.field_9181, regionChunkNum);
        int regionZ = Math.floorDiv(pos.field_9180, regionChunkNum);
        RegionErrorTerrainGenerator generator = Helper.noError(() ->
            cache.get(new class_1923(regionX, regionZ))
        );
        
        for (int sectionY = 0; sectionY < 16; sectionY++) {
            class_2826 section = protoChunk.method_38259(sectionY);
            
            for (int localX = 0; localX < 16; localX++) {
                for (int localZ = 0; localZ < 16; localZ++) {
                    for (int localY = 0; localY < 16; localY++) {
                        int worldX = pos.field_9181 * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.field_9180 * 16 + localZ;
                        
                        class_2680 currBlockState = generator.getBlockComposition(
                            worldX, worldY, worldZ
                        );
                        
                        if (currBlockState != air) {
                            section.method_12256(localX, localY, localZ, currBlockState, false);
                            oceanFloorHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                            surfaceHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                        }
                    }
                }
            }
        }
    }
    
}
