package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.logging.LogUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.my_util.DQuaternion;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6379;

// extending EntryListWidget.Entry is also fine
public class DimEntryWidget extends class_4265.class_4266<DimEntryWidget> {
    private static final Logger LOGGER = LogUtils.getLogger();
    
    public static enum ArrowType {
        none, enabled, conflicting
    }
    
    public final class_5321<class_1937> dimension;
    public final DimListWidget parent;
    private final Consumer<DimEntryWidget> selectCallback;
    @Nullable
    private final class_2960 dimIconPath;
    private final class_2561 dimensionName;
    
    // if null, it's in select dimension screen
    // if not null, it's in dim stack screen
    @Nullable
    public final DimStackEntry entry;
    
    public int entryIndex;
    
    ArrowType arrowToPrevious = ArrowType.none;
    ArrowType arrowToNext = ArrowType.none;
    
    public final static int widgetHeight = 50;
    
    @Override
    public List<? extends class_6379> method_37025() {
        return List.of();
    }
    
    public DimEntryWidget(
        class_5321<class_1937> dimension,
        DimListWidget parent,
        Consumer<DimEntryWidget> selectCallback,
        @Nullable DimStackEntry entry
    ) {
        this.dimension = dimension;
        this.parent = parent;
        this.selectCallback = selectCallback;
        
        this.dimIconPath = CHelper.getDimensionIconPath(this.dimension);
        
        this.dimensionName = McHelper.getDimensionName(dimension);
        
        this.entry = entry;
    }
    
    private final List<class_364> children = new ArrayList<>();
    
    @Override
    public List<? extends class_364> method_25396() {
        return children;
    }
    
    @Override
    public void method_25343(
        @NotNull class_332 guiGraphics,
        int index,
        int y,
        int x,
        int rowWidth,
        int itemHeight,
        int mouseX,
        int mouseY,
        boolean bl,
        float delta
    ) {
        class_310 client = class_310.method_1551();
        
        guiGraphics.method_25303(
            client.field_1772, dimensionName.getString(),
            x + widgetHeight + 3, (int) (y),
            0xFFFFFFFF
        );
        
        guiGraphics.method_25303(
            client.field_1772, dimension.method_29177().toString(),
            x + widgetHeight + 3, (int) (y + 10),
            0xFF999999
        );
        
        if (dimIconPath != null) {
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(x, y, 0);
            
            int iconLen = widgetHeight - 4;
            
            if (entry != null && entry.flipped) {
                guiGraphics.method_51448().method_49278(
                    DQuaternion.rotationByDegrees(new class_243(0, 0, 1), 180).toMcQuaternion(),
                    iconLen / 2.0f, iconLen / 2.0f, 0
                );
            }
            
            guiGraphics.method_25290(
                dimIconPath, 0, 0, 0.0F, 0.0F,
                iconLen, iconLen,
                iconLen, iconLen
            );
            
            guiGraphics.method_51448().method_22909();
        }
        
        if (entry != null) {
            guiGraphics.method_27535(
                client.field_1772, getText1(),
                x + widgetHeight + 3, (int) (y + 20),
                0xFF999999
            );
            guiGraphics.method_27535(
                client.field_1772, getText2(),
                x + widgetHeight + 3, (int) (y + 30),
                0xFF999999
            );
            
            if (arrowToPrevious != ArrowType.none) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(x + rowWidth - 13, y, 0);
                guiGraphics.method_51448().method_22905(1.5f, 1.5f, 1.5f);
                guiGraphics.method_27535(
                    client.field_1772, class_2561.method_43470("↑"),
                    0, 0,
                    arrowToPrevious == ArrowType.enabled ? 0xFF999999 : 0xFFFF0000
                );
                guiGraphics.method_51448().method_22909();
            }
            
            if (arrowToNext != ArrowType.none) {
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(x + rowWidth - 13, y + widgetHeight - 14.5f, 0);
                guiGraphics.method_51448().method_22905(1.5f, 1.5f, 1.5f);
                guiGraphics.method_27535(
                    client.field_1772, class_2561.method_43470("↓"),
                    0, 0,
                    arrowToNext == ArrowType.enabled ? 0xFF999999 : 0xFFFF0000
                );
                guiGraphics.method_51448().method_22909();
            }
        }
    }
    
    private class_2561 getText1() {
        class_5250 scaleText = entry.scale != 1.0 ?
            class_2561.method_43471("imm_ptl.scale")
                .method_10852(class_2561.method_43470(":" + Double.toString(entry.scale)))
            : class_2561.method_43470("");
        
        return scaleText;
    }
    
    private class_2561 getText2() {
        class_5250 horizontalRotationText = entry.horizontalRotation != 0 ?
            class_2561.method_43471("imm_ptl.horizontal_rotation")
                .method_10852(class_2561.method_43470(":" + Double.toString(entry.horizontalRotation)))
                .method_10852(class_2561.method_43470(" "))
            : class_2561.method_43470("");
        
        return horizontalRotationText;
    }
    
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        selectCallback.accept(this);
        super.method_25402(mouseX, mouseY, button);
        return true;//allow outer dragging
    }
    
}
