package qouteall.imm_ptl.peripheral.dim_stack;

import qouteall.q_misc_util.Helper;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class DimListWidget extends class_350<DimEntryWidget> {
    
    public static final int ROW_WIDTH = 300;
    
    public static interface DraggingCallback {
        void run(int selectedIndex, int mouseOnIndex);
    }
    
    public final class_437 parent;
    private final Type type;
    @Nullable
    private final DraggingCallback draggingCallback;
    
    @Override
    public void method_37020(class_6382 builder) {
    
    }
    
    public static enum Type {
        mainDimensionList, addDimensionList
    }
    
    public DimListWidget(
        int width,
        int height,
        int top,
        int bottom,
        int itemHeight,
        class_437 parent,
        Type type,
        @Nullable DraggingCallback draggingCallback
    ) {
        super(class_310.method_1551(), width, height, top, bottom, itemHeight);
        this.parent = parent;
        this.type = type;
        this.draggingCallback = draggingCallback;
        method_31322(false);
        method_31323(false);
    }
    
    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (type == Type.mainDimensionList && draggingCallback != null) {
            DimEntryWidget selected = method_25334();
        
            if (selected != null) {
                DimEntryWidget mouseOn = method_25308(mouseX, mouseY);
                if (mouseOn != null) {
                    if (mouseOn != selected) {
                        int selectedIndex = method_25396().indexOf(selected);
                        int mouseOnIndex = method_25396().indexOf(mouseOn);
                        if (selectedIndex != -1 && mouseOnIndex != -1) {
                            draggingCallback.run(selectedIndex, mouseOnIndex);
                        }
                        else {
                            Helper.err("Invalid dragging");
                        }
                    }
                }
            }
        }
        
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }
    
    // make it wider
    @Override
    public int method_25322() {
        return ROW_WIDTH;
    }
    
    @Override
    protected int method_25329() {
        return (field_22742 - ROW_WIDTH) / 2 + ROW_WIDTH;
    }
}
