package qouteall.imm_ptl.peripheral.dim_stack;

import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.GuiHelper;

import java.util.OptionalInt;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class DimStackEntryEditScreen extends class_437 {
    
    
    private final DimStackScreen parent;
    private final DimEntryWidget editing;
    
    private final class_342 scaleField;
    private final class_4185 flipButton;
    private final class_342 horizontalRotationField;
    private final class_342 topYField;
    private final class_342 bottomYField;
    private final class_342 bedrockBlockField;
    private final class_4185 connectsPreviousButton;
    private final class_4185 connectsNextButton;
    
    private final class_4185 finishButton;
    
    private final GuiHelper.Rect scaleLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect flipLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect horizontalRotationLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect topYLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect bottomYLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect bedrockLabelRect = new GuiHelper.Rect();
    private final GuiHelper.Rect connectsPreviousRect = new GuiHelper.Rect();
    private final GuiHelper.Rect connectsNextRect = new GuiHelper.Rect();
    
    private final class_4185 helpButton;
    
    protected DimStackEntryEditScreen(
        DimStackScreen parent,
        DimEntryWidget editing,
        Runnable callback
    ) {
        super(class_2561.method_43471("imm_ptl.dim_stack_edit_screen"));
        
        this.parent = parent;
        this.editing = editing;
        
        scaleField = new class_342(
            class_310.method_1551().field_1772,
            0, 0, 0, 20, class_2561.method_43470("you cannot see me")
        );
        scaleField.method_1852(Double.toString(editing.entry.scale));
        scaleField.method_1884(0);//without this the text won't render. mc gui is bugged
        scaleField.method_1875(0);
        
        flipButton =
            class_4185.method_46430(
                    class_2561.method_43471(editing.entry.flipped ? "imm_ptl.enabled" : "imm_ptl.disabled"),
                    button -> {
                        editing.entry.flipped = !editing.entry.flipped;
                        button.method_25355(
                            class_2561.method_43471(editing.entry.flipped ? "imm_ptl.enabled" : "imm_ptl.disabled")
                        );
                    }
                )
                .method_46431();
        
        horizontalRotationField = new class_342(
            class_310.method_1551().field_1772,
            0, 0, 0, 20,
            class_2561.method_43470("you cannot see me")
        );
        horizontalRotationField.method_1852(Double.toString(editing.entry.horizontalRotation));
        horizontalRotationField.method_1875(0);
        horizontalRotationField.method_1884(0);
        
        topYField = new class_342(
            class_310.method_1551().field_1772,
            0, 0, 0, 20,
            class_2561.method_43470("you cannot see me")
        );
        if (editing.entry.topY != null) {
            topYField.method_1852(Integer.toString(editing.entry.topY));
        }
        topYField.method_1875(0);
        topYField.method_1884(0);
        
        bottomYField = new class_342(
            class_310.method_1551().field_1772,
            0, 0, 0, 20,
            class_2561.method_43470("you cannot see me")
        );
        if (editing.entry.bottomY != null) {
            bottomYField.method_1852(Integer.toString(editing.entry.bottomY));
        }
        bottomYField.method_1875(0);
        bottomYField.method_1884(0);
        
        bedrockBlockField = new class_342(
            class_310.method_1551().field_1772,
            0, 0, 0, 20,
            class_2561.method_43470("you cannot see me")
        );
        bedrockBlockField.method_1880(200);
        if (editing.entry.bedrockReplacementStr != null) {
            bedrockBlockField.method_1852(editing.entry.bedrockReplacementStr);
        }
        bedrockBlockField.method_1875(0);
        bedrockBlockField.method_1884(0);
        
        connectsPreviousButton = class_4185.method_46430(
            class_2561.method_43471(editing.entry.connectsPrevious ? "imm_ptl.enabled" : "imm_ptl.disabled"),
            button -> {
                editing.entry.connectsPrevious = !editing.entry.connectsPrevious;
                button.method_25355(
                    class_2561.method_43471(editing.entry.connectsPrevious ? "imm_ptl.enabled" : "imm_ptl.disabled")
                );
            }
        ).method_46431();
        
        connectsNextButton = class_4185.method_46430(
            class_2561.method_43471(editing.entry.connectsNext ? "imm_ptl.enabled" : "imm_ptl.disabled"),
            button -> {
                editing.entry.connectsNext = !editing.entry.connectsNext;
                button.method_25355(
                    class_2561.method_43471(editing.entry.connectsNext ? "imm_ptl.enabled" : "imm_ptl.disabled")
                );
            }
        ).method_46431();
        
        finishButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.finish"),
            button -> {
                editing.entry.horizontalRotation =
                    Helper.parseDouble(horizontalRotationField.method_1882()).orElse(0);
                
                editing.entry.scale =
                    Helper.parseDouble(scaleField.method_1882()).orElse(1);
                
                OptionalInt topY = Helper.parseInt(topYField.method_1882());
                editing.entry.topY = topY.isPresent() ? topY.getAsInt() : null;
                
                OptionalInt bottomY = Helper.parseInt(bottomYField.method_1882());
                editing.entry.bottomY = bottomY.isPresent() ? bottomY.getAsInt() : null;
                
                editing.entry.bedrockReplacementStr = bedrockBlockField.method_1882();
                
                class_310.method_1551().method_1507(parent);
                callback.run();
            }
        ).method_46431();
        
        this.helpButton = DimStackScreen.createHelpButton(this);
    }
    
    
    @Override
    public void method_25393() {
        super.method_25393();
        scaleField.method_1865();
        horizontalRotationField.method_1865();
    }
    
    @Override
    protected void method_25426() {
        method_25429(scaleField);
        method_37063(flipButton);
        method_25429(horizontalRotationField);
        method_25429(topYField);
        method_25429(bottomYField);
        method_25429(bedrockBlockField);
        method_25429(connectsPreviousButton);
        method_25429(connectsNextButton);
        method_37063(finishButton);
        method_37063(helpButton);
        
        GuiHelper.layout(
            0, field_22790,
            GuiHelper.blankSpace(5),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(scaleLabelRect),
                    GuiHelper.layoutButtonVertically(scaleField)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(flipLabelRect),
                    GuiHelper.layoutButtonVertically(flipButton)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(horizontalRotationLabelRect),
                    GuiHelper.layoutButtonVertically(horizontalRotationField)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(topYLabelRect),
                    GuiHelper.layoutButtonVertically(topYField)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(bottomYLabelRect),
                    GuiHelper.layoutButtonVertically(bottomYField)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(bedrockLabelRect),
                    GuiHelper.layoutButtonVertically(bedrockBlockField)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(connectsPreviousRect),
                    GuiHelper.layoutButtonVertically(connectsPreviousButton)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20,
                GuiHelper.combine(
                    GuiHelper.layoutRectVertically(connectsNextRect),
                    GuiHelper.layoutButtonVertically(connectsNextButton)
                )
            ),
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(20, GuiHelper.layoutButtonVertically(finishButton)),
            GuiHelper.blankSpace(5)
        );
        
        GuiHelper.layout(
            0, field_22789,
            GuiHelper.elasticBlankSpace(),
            GuiHelper.fixedLength(150,
                GuiHelper.combine(
                    GuiHelper.layoutRectHorizontally(scaleLabelRect),
                    GuiHelper.layoutRectHorizontally(flipLabelRect),
                    GuiHelper.layoutRectHorizontally(horizontalRotationLabelRect),
                    GuiHelper.layoutRectHorizontally(topYLabelRect),
                    GuiHelper.layoutRectHorizontally(bottomYLabelRect),
                    GuiHelper.layoutRectHorizontally(bedrockLabelRect),
                    GuiHelper.layoutRectHorizontally(connectsPreviousRect),
                    GuiHelper.layoutRectHorizontally(connectsNextRect)
                )
            ),
            GuiHelper.blankSpace(20),
            GuiHelper.fixedLength(100,
                GuiHelper.combine(
                    GuiHelper.layoutButtonHorizontally(scaleField),
                    GuiHelper.layoutButtonHorizontally(flipButton),
                    GuiHelper.layoutButtonHorizontally(horizontalRotationField),
                    GuiHelper.layoutButtonHorizontally(topYField),
                    GuiHelper.layoutButtonHorizontally(bottomYField),
                    GuiHelper.layoutButtonHorizontally(bedrockBlockField),
                    GuiHelper.layoutButtonHorizontally(connectsPreviousButton),
                    GuiHelper.layoutButtonHorizontally(connectsNextButton)
                )
            ),
            GuiHelper.elasticBlankSpace()
        );
        
        GuiHelper.layout(
            0, field_22789,
            GuiHelper.blankSpace(20),
            new GuiHelper.LayoutElement(
                true, 100,
                GuiHelper.layoutButtonHorizontally(finishButton)
            ),
            GuiHelper.elasticBlankSpace()
        );
        
        helpButton.method_46421(field_22789 - 50);
        helpButton.method_46419(5);
        helpButton.method_25358(20);
    }
    
    @Override
    public void method_25419() {
        class_310.method_1551().method_1507(parent);
    }
    
    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        
        scaleField.method_25394(guiGraphics, mouseX, mouseY, delta);
        horizontalRotationField.method_25394(guiGraphics, mouseX, mouseY, delta);
        topYField.method_25394(guiGraphics, mouseX, mouseY, delta);
        bottomYField.method_25394(guiGraphics, mouseX, mouseY, delta);
        bedrockBlockField.method_25394(guiGraphics, mouseX, mouseY, delta);
        connectsPreviousButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        connectsNextButton.method_25394(guiGraphics, mouseX, mouseY, delta);
        
        scaleLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.scale"), guiGraphics);
        flipLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.flipped"), guiGraphics);
        horizontalRotationLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.horizontal_rotation"), guiGraphics);
        topYLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.top_y"), guiGraphics);
        bottomYLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.bottom_y"), guiGraphics);
        bedrockLabelRect.renderTextLeft(class_2561.method_43471("imm_ptl.bedrock_replacement"), guiGraphics);
        connectsPreviousRect.renderTextLeft(class_2561.method_43471("imm_ptl.connects_previous"), guiGraphics);
        connectsNextRect.renderTextLeft(class_2561.method_43471("imm_ptl.connects_next"), guiGraphics);
    }
}
