package qouteall.imm_ptl.peripheral.dim_stack;

import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

// will be serialized by GSON
public class DimStackInfo {
    
    public boolean loop;
    public boolean gravityTransform;
    public List<DimStackEntry> entries;
    
    public DimStackInfo() {
        entries = new ArrayList<>();
        loop = false;
        gravityTransform = false;
    }
    
    public DimStackInfo(List<DimStackEntry> entries, boolean loop, boolean gravityTransform) {
        this.entries = entries;
        this.loop = loop;
        this.gravityTransform = gravityTransform;
    }
    
    public static void initializeFuseViewProperty(Portal portal) {
        if (portal.getNormal().field_1351 < 0) {
            portal.fuseView = true;
        }
    }
    
    public static void createConnectionBetween(
        DimStackEntry a, DimStackEntry b, boolean gravityChange
    ) {
        class_3218 fromWorld = McHelper.getServerWorld(a.getDimension());
        class_3218 toWorld = McHelper.getServerWorld(b.getDimension());
        
        boolean xorFlipped = a.flipped ^ b.flipped;
        
        int fromWorldMinY = McHelper.getMinY(fromWorld);
        if (a.bottomY != null) {
            fromWorldMinY = a.bottomY;
        }
        int fromWorldMaxY = McHelper.getMaxContentYExclusive(fromWorld);
        if (a.topY != null) {
            fromWorldMaxY = a.topY;
        }
        int toWorldMinY = McHelper.getMinY(toWorld);
        if (b.bottomY != null) {
            toWorldMinY = b.bottomY;
        }
        int toWorldMaxY = McHelper.getMaxContentYExclusive(toWorld);
        if (b.topY != null) {
            toWorldMaxY = b.topY;
        }
        
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(
            fromWorld,
            a.flipped ? VerticalConnectingPortal.ConnectorType.ceil :
                VerticalConnectingPortal.ConnectorType.floor,
            toWorld,
            b.scale / a.scale,
            xorFlipped,
            b.horizontalRotation - a.horizontalRotation,
            fromWorldMinY, fromWorldMaxY,
            toWorldMinY, toWorldMaxY
        );
        
        VerticalConnectingPortal reverse = PortalAPI.createReversePortal(connectingPortal);
        
        initializeFuseViewProperty(connectingPortal);
        initializeFuseViewProperty(reverse);
        
        if (gravityChange) {
            connectingPortal.setTeleportChangesGravity(true);
            reverse.setTeleportChangesGravity(true);
        }
        
        if (a.connectsNext) {
            PortalAPI.addGlobalPortal(fromWorld, connectingPortal);
        }
        
        if (b.connectsPrevious) {
            PortalAPI.addGlobalPortal(toWorld, reverse);
        }
    }
    
    public void apply() {
        
        if (entries.isEmpty()) {
            McHelper.sendMessageToFirstLoggedPlayer(class_2561.method_43470(
                "Error: No dimension for dimension stack"
            ));
            return;
        }
        
        MinecraftServer server = MiscHelper.getServer();
        for (DimStackEntry entry : entries) {
            if (server.method_3847(entry.getDimension()) == null) {
                McHelper.sendMessageToFirstLoggedPlayer(class_2561.method_43470(
                    "Failed to apply dimension stack. Missing dimension " + entry.dimensionIdStr
                ).method_27692(class_124.field_1061));
                return;
            }
        }
        
        if (!GlobalPortalStorage.getGlobalPortals(McHelper.getServerWorld(entries.get(0).getDimension())).isEmpty()) {
            Helper.err("There are already global portals when initializing dimension stack");
            McHelper.sendMessageToFirstLoggedPlayer(class_2561.method_43470(
                "Failed to apply dimension stack because there are already global portals when initializing dimension stack"
            ).method_27692(class_124.field_1061));
            return;
        }
        
        // check connection conflict
        Map<PortalInfo, List<DimStackEntry>> portalInfoMap = getPortalInfoMap();
        for (Map.Entry<PortalInfo, List<DimStackEntry>> entry : portalInfoMap.entrySet()) {
            PortalInfo key = entry.getKey();
            List<DimStackEntry> value = entry.getValue();
            if (value != null && value.size() > 1) {
                McHelper.sendMessageToFirstLoggedPlayer(class_2561.method_43470(
                    "Failed to apply dimension stack because of connection conflict. There are multiple connections in the %s of %s"
                        .formatted(key.connectorType, key.dimension.method_29177())
                ).method_27692(class_124.field_1061));
                return;
            }
        }
        
        Helper.wrapAdjacentAndMap(
            entries.stream(),
            Pair::of
        ).forEach(pair -> {
            DimStackEntry before = pair.getFirst();
            DimStackEntry after = pair.getSecond();
            createConnectionBetween(before, after, gravityTransform);
        });
        
        if (loop) {
            createConnectionBetween(entries.get(entries.size() - 1), entries.get(0), gravityTransform);
        }
        
        Map<class_5321<class_1937>, class_2680> bedrockReplacementMap = new HashMap<>();
        for (DimStackEntry entry : entries) {
            String bedrockReplacementStr = entry.bedrockReplacementStr;
            
            class_2680 bedrockReplacement = parseBlockString(bedrockReplacementStr);
            
            if (bedrockReplacement != null) {
                bedrockReplacementMap.put(entry.getDimension(), bedrockReplacement);
            }
            GlobalPortalStorage gps = GlobalPortalStorage.get(McHelper.getServerWorld(entry.getDimension()));
            gps.bedrockReplacement = bedrockReplacement;
            gps.onDataChanged();
        }
        DimStackManagement.bedrockReplacementMap = bedrockReplacementMap;
        
        McHelper.sendMessageToFirstLoggedPlayer(
            class_2561.method_43471("imm_ptl.dim_stack_initialized")
        );
    }
    
    public boolean isEffectivelyConnectingPrevious(int index) {
        DimStackEntry entry = entries.get(index);
        if (!entry.connectsPrevious) {
            return false;
        }
        
        if (index == 0) {
            return loop;
        }
        return true;
    }
    
    public boolean isEffectivelyConnectionNext(int index) {
        DimStackEntry entry = entries.get(index);
        if (!entry.connectsNext) {
            return false;
        }
        
        if (index == entries.size() - 1) {
            return loop;
        }
        return true;
    }
    
    public boolean isEffectivelyConnectingCeil(int index) {
        DimStackEntry entry = entries.get(index);
        
        if (!entry.flipped) {
            return isEffectivelyConnectingPrevious(index);
        }
        else {
            return isEffectivelyConnectionNext(index);
        }
    }
    
    public boolean isEffectivelyConnectingFloor(int index) {
        DimStackEntry entry = entries.get(index);
        
        if (!entry.flipped) {
            return isEffectivelyConnectionNext(index);
        }
        else {
            return isEffectivelyConnectingPrevious(index);
        }
    }
    
    public static record PortalInfo(
        class_5321<class_1937> dimension,
        VerticalConnectingPortal.ConnectorType connectorType
    ) {}
    
    public Map<PortalInfo, List<DimStackEntry>> getPortalInfoMap() {
        Map<PortalInfo, List<DimStackEntry>> map = new HashMap<>();
        
        for (int i = 0; i < entries.size(); i++) {
            DimStackEntry entry = entries.get(i);
            
            if (isEffectivelyConnectingCeil(i)) {
                PortalInfo portalInfo = new PortalInfo(
                    entry.getDimension(),
                    VerticalConnectingPortal.ConnectorType.ceil
                );
                map.computeIfAbsent(portalInfo, k -> new ArrayList<>()).add(entry);
            }
            
            if (isEffectivelyConnectingFloor(i)) {
                PortalInfo portalInfo = new PortalInfo(
                    entry.getDimension(),
                    VerticalConnectingPortal.ConnectorType.floor
                );
                map.computeIfAbsent(portalInfo, k -> new ArrayList<>()).add(entry);
            }
        }
        
        return map;
    }
    
    @Nullable
    public static class_2680 parseBlockString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        
        try {
            Optional<class_2248> block = class_7923.field_41175.method_17966(new class_2960(str));
            return block.map(class_2248::method_9564).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
