package qouteall.imm_ptl.peripheral.dim_stack;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qouteall.imm_ptl.core.CHelper;
import qouteall.q_misc_util.my_util.GuiHelper;

import java.util.function.Consumer;

@Environment(EnvType.CLIENT)
public class DimStackScreen extends class_437 {
    private static final Logger LOGGER = LoggerFactory.getLogger(DimStackScreen.class);
    
    private final DimStackGuiController controller;
    
    @org.jetbrains.annotations.Nullable
    public final class_437 parent;
    private final class_4185 finishButton;
    private final class_4185 toggleButton;
    private final class_4185 addDimensionButton;
    private final class_4185 removeDimensionButton;
    private final class_4185 editButton;
    
    private final class_4185 helpButton;
    private final class_4185 setAsPresetButton;
    
    private final class_4185 loopButton;
    private final class_4185 gravityModeButton;
    
    private int titleY;
    
    public final DimListWidget dimListWidget;
    
    private boolean isEnabled = false;
    
    public DimStackScreen(
        @Nullable class_437 parent,
        DimStackGuiController controller
    ) {
        super(class_2561.method_43471("imm_ptl.altius_screen"));
        this.parent = parent;
        
        toggleButton = class_4185.method_46430(
            class_2561.method_43470("..."),
            (buttonWidget) -> {
                controller.toggleEnabled();
            }
        ).method_46431();
        
        loopButton = class_4185.method_46430(
            class_2561.method_43470("..."),
            (buttonWidget) -> {
                controller.toggleLoop();
            }
        ).method_46431();
        
        gravityModeButton = class_4185.method_46430(
            class_2561.method_43470("..."),
            (gravityModeButton) -> {
                controller.toggleGravityMode();
            }
        ).method_46431();
        
        finishButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.finish"),
            (buttonWidget) -> {
                controller.onFinish();
            }
        ).method_46431();
        this.controller = controller;
        addDimensionButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.dim_stack_add"),
            (buttonWidget) -> {
                onAddEntry();
            }
        ).method_46431();
        removeDimensionButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.dim_stack_remove"),
            (buttonWidget) -> {
                onRemoveEntry();
            }
        ).method_46431();
        
        editButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.dim_stack_edit"),
            (buttonWidget) -> {
                onEditEntry();
            }
        ).method_46431();
        
        dimListWidget = new DimListWidget(
            field_22789,
            field_22790,
            100,
            200,
            DimEntryWidget.widgetHeight,
            this,
            DimListWidget.Type.mainDimensionList,
            controller::onDragged
        );
        
        helpButton = createHelpButton(this);
        
        this.setAsPresetButton = class_4185.method_46430(
            class_2561.method_43471("imm_ptl.set_as_dim_stack_default"),
            button -> {
                this.controller.setAsDefault();
            }
        ).method_46431();
    }
    
    public void setLoopEnabled(boolean loopEnabled) {
        loopButton.method_25355(class_2561.method_43471(
            loopEnabled ? "imm_ptl.loop_enabled" : "imm_ptl.loop_disabled"
        ));
    }
    
    public void setGravityTransformEnabled(boolean gravityTransformEnabled) {
        gravityModeButton.method_25355(class_2561.method_43471(
            gravityTransformEnabled ? "imm_ptl.dim_stack.gravity_transform_enabled" :
                "imm_ptl.dim_stack.gravity_transform_disabled"
        ));
    }
    
    public static class_4185 createHelpButton(class_437 parent) {
        return class_4185.method_46430(
            class_2561.method_43470("?"),
            button -> {
                CHelper.openLinkConfirmScreen(
                    parent, "https://qouteall.fun/immptl/wiki/Dimension-Stack"
                );
            }
        ).method_46431();
    }
    
    public DimEntryWidget createDimEntryWidget(DimStackEntry entry) {
        return new DimEntryWidget(
            entry.getDimension(),
            dimListWidget,
            getElementSelectCallback(),
            entry
        );
    }
    
    @Override
    protected void method_25426() {
        
        method_37063(toggleButton);
        method_37063(finishButton);
        method_37063(addDimensionButton);
        method_37063(removeDimensionButton);
        
        method_37063(editButton);
        method_37063(helpButton);
        method_37063(setAsPresetButton);
        method_37063(loopButton);
        method_37063(gravityModeButton);
        
        method_25429(dimListWidget);
        
        GuiHelper.layout(
            0, field_22790,
            GuiHelper.blankSpace(5),
            new GuiHelper.LayoutElement(true, 20, (from, to) -> {
                helpButton.method_46421(field_22789 - 30);
                helpButton.method_46419(from);
                helpButton.method_25358(20);
                
                setAsPresetButton.method_46421(field_22789 - 125);
                setAsPresetButton.method_46419(from);
                setAsPresetButton.method_25358(90);
            }),
            new GuiHelper.LayoutElement(
                true, 20,
                GuiHelper.combine(
                    GuiHelper.layoutButtonVertically(toggleButton),
                    GuiHelper.layoutButtonVertically(loopButton),
                    GuiHelper.layoutButtonVertically(gravityModeButton)
                )
            ),
            GuiHelper.blankSpace(5),
            new GuiHelper.LayoutElement(false, 1, (from, to) -> {
                dimListWidget.method_25323(
                    field_22789, field_22790,
                    from, to
                );
            }),
            GuiHelper.blankSpace(5),
            new GuiHelper.LayoutElement(true, 20, (from, to) -> {
                finishButton.method_46419(from);
                addDimensionButton.method_46419(from);
                removeDimensionButton.method_46419(from);
                editButton.method_46419(from);
                GuiHelper.layout(
                    0, field_22789,
                    GuiHelper.blankSpace(10),
                    new GuiHelper.LayoutElement(
                        false, 1,
                        GuiHelper.layoutButtonHorizontally(finishButton)
                    ),
                    GuiHelper.blankSpace(5),
                    new GuiHelper.LayoutElement(
                        false, 1,
                        GuiHelper.layoutButtonHorizontally(addDimensionButton)
                    ),
                    GuiHelper.blankSpace(5),
                    new GuiHelper.LayoutElement(
                        false, 1,
                        GuiHelper.layoutButtonHorizontally(removeDimensionButton)
                    ),
                    GuiHelper.blankSpace(5),
                    new GuiHelper.LayoutElement(
                        false, 1,
                        GuiHelper.layoutButtonHorizontally(editButton)
                    ),
                    GuiHelper.blankSpace(10)
                );
            }),
            GuiHelper.blankSpace(5)
        );
        
        GuiHelper.layout(
            0, field_22789,
            GuiHelper.blankSpace(10),
            new GuiHelper.LayoutElement(
                false, 10, GuiHelper.layoutButtonHorizontally(toggleButton)
            ),
            GuiHelper.blankSpace(5),
            new GuiHelper.LayoutElement(
                false, 8, GuiHelper.layoutButtonHorizontally(loopButton)
            ),
            GuiHelper.blankSpace(5),
            new GuiHelper.LayoutElement(
                false, 10, GuiHelper.layoutButtonHorizontally(gravityModeButton)
            ),
            GuiHelper.blankSpace(10)
        );
    }
    
    @Override
    public void method_25419() {
        // When `esc` is pressed, it's the same as pressing "Finish".
        // Don't return to the main menu.
        controller.onFinish();
    }
    
    private Consumer<DimEntryWidget> getElementSelectCallback() {
        return w -> dimListWidget.method_25313(w);
    }
    
    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        
        if (isEnabled) {
            dimListWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        
        class_327 font = class_310.method_1551().field_1772;
        guiGraphics.method_27535(
            font, this.field_22785,
            20, 10, -1
        );
    }
    
    public void setEnabled(boolean cond) {
        isEnabled = cond;
        if (isEnabled) {
            toggleButton.method_25355(class_2561.method_43471("imm_ptl.altius_toggle_true"));
        }
        else {
            toggleButton.method_25355(class_2561.method_43471("imm_ptl.altius_toggle_false"));
        }
        addDimensionButton.field_22764 = isEnabled;
        removeDimensionButton.field_22764 = isEnabled;
        editButton.field_22764 = isEnabled;
        loopButton.field_22764 = isEnabled;
        gravityModeButton.field_22764 = isEnabled;
    }
    
    private void onAddEntry() {
        DimEntryWidget selected = dimListWidget.method_25334();
        
        int position;
        if (selected == null) {
            position = 0;
        }
        else {
            position = dimListWidget.method_25396().indexOf(selected);
        }
        
        if (position < 0 || position > dimListWidget.method_25396().size()) {
            position = -1;
        }
        
        int insertingPosition = position + 1;
        
        class_310.method_1551().method_1507(
            new SelectDimensionScreen(
                this,
                dimensionType -> {
                    controller.addEntry(insertingPosition, new DimStackEntry(dimensionType));
                },
                controller.getDimensionList()
            )
        );
    }
    
    private void onRemoveEntry() {
        DimEntryWidget selected = dimListWidget.method_25334();
        if (selected == null) {
            return;
        }
        
        int position = dimListWidget.method_25396().indexOf(selected);
        
        if (position == -1) {
            return;
        }
        
        controller.removeEntry(position);
    }
    
    private void onEditEntry() {
        DimEntryWidget selected = dimListWidget.method_25334();
        if (selected == null) {
            return;
        }
        
        class_310.method_1551().method_1507(new DimStackEntryEditScreen(
            this, selected,
            () -> {
                int newlyChangingEntryIndex = dimListWidget.method_25396().indexOf(selected);
                if (newlyChangingEntryIndex == -1) {
                    LOGGER.error("The edited entry is missing in the list");
                    return;
                }
                controller.editEntry(newlyChangingEntryIndex, selected.entry);
            }
        ));
    }
    
}
