package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5321;

public class SelectDimensionScreen extends class_437 {
    public final DimStackScreen parent;
    private DimListWidget dimListWidget;
    private class_4185 confirmButton;
    private final Consumer<class_5321<class_1937>> outerCallback;
    private final List<class_5321<class_1937>> dimensionList;
    
    protected SelectDimensionScreen(
        DimStackScreen parent,
        Consumer<class_5321<class_1937>> callback,
        List<class_5321<class_1937>> dimensionList
    ) {
        super(class_2561.method_43471("imm_ptl.select_dimension"));
        this.parent = parent;
        this.outerCallback = callback;
        this.dimensionList = dimensionList;
    }
    
    @Override
    protected void method_25426() {
        dimListWidget = new DimListWidget(
            field_22789,
            field_22790,
            20,
            field_22790 - 30,
            DimEntryWidget.widgetHeight,
            this,
            DimListWidget.Type.addDimensionList,
            null
        );
        method_25429(dimListWidget);
        
        Consumer<DimEntryWidget> callback = w -> dimListWidget.method_25313(w);
        
        for (class_5321<class_1937> dim : dimensionList) {
            dimListWidget.method_25396().add(new DimEntryWidget(dim, dimListWidget, callback, new DimStackEntry(dim)));
        }
    
        confirmButton = (class_4185) method_37063(class_4185
            .method_46430(
                class_2561.method_43471("imm_ptl.confirm_select_dimension"),
                (buttonWidget) -> {
                    DimEntryWidget selected = dimListWidget.method_25334();
                    if (selected == null) {
                        return;
                    }
                    class_310.method_1551().method_1507(parent);
                    outerCallback.accept(selected.dimension);
                }
            )
            .method_46433(this.field_22789 / 2 - 75, this.field_22790 - 28)
            .method_46437(150, 20)
            .method_46431());
    }
    
    @Override
    public void method_25419() {
        // When `esc` is pressed return to the parent screen rather than setting screen to `null` which returns to the main menu.
        this.field_22787.method_1507(this.parent);
    }
    
    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.method_25420(guiGraphics);
        
        dimListWidget.method_25394(guiGraphics, mouseX, mouseY, delta);
        
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
        
        guiGraphics.method_25300(
            this.field_22793, this.field_22785.getString(), this.field_22789 / 2, 10, -1
        );
    }
}
