package qouteall.imm_ptl.peripheral.mixin.client.dim_stack;

import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackGuiController;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.imm_ptl.peripheral.ducks.IECreateWorldScreen;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimId;

import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7145;
import net.minecraft.class_7193;
import net.minecraft.class_7723;
import net.minecraft.class_8100;

@Mixin(class_525.class)
public abstract class MixinCreateWorldScreen extends class_437 implements IECreateWorldScreen {
    
    @Shadow
    @Final
    private static Logger LOGGER;
    
    @Shadow
    @Final
    private class_8100 uiState;
    
    @Nullable
    private DimStackGuiController ip_dimStackController;
    
    protected MixinCreateWorldScreen(class_2561 title) {
        super(title);
        throw new RuntimeException();
    }
    
    @Inject(
        method = "<init>",
        at = @At("RETURN")
    )
    private void onInitEnd(
        class_310 minecraft, class_437 screen, class_7193 worldCreationContext,
        Optional<class_5321<class_7145>> optional, OptionalLong optionalLong, CallbackInfo ci
    ) {
        DimStackManagement.dimStackToApply = DimStackManagement.getDimStackPreset();
        if (DimStackManagement.dimStackToApply != null) {
            LOGGER.info("[ImmPtl] Applying dimension stack preset");
        }
    }
    
    @Override
    public void ip_openDimStackScreen() {
        if (ip_dimStackController == null) {
            class_525 this_ = (class_525) (Object) this;
            ip_dimStackController = new DimStackGuiController(
                this_,
                () -> portal_getDimensionList(),
                info -> {
                    DimStackManagement.dimStackToApply = info;
                    class_310.method_1551().method_1507(this_);
                }
            );
            ip_dimStackController.initializeAsDefault();
        }
        
        class_310.method_1551().method_1507(ip_dimStackController.view);
    }
    
    private List<class_5321<class_1937>> portal_getDimensionList() {
        Helper.log("Getting the dimension list");
        
        List<class_5321<class_1937>> result = new ArrayList<>();
        
        try {
            class_7193 settings = uiState.method_48728();
            
            class_5455.class_6890 registryAccess = settings.method_45689();
            
            class_7723 selectedDimensions = settings.comp_1028();
            
            // add vanilla dimensions
            for (Map.Entry<class_5321<class_5363>, class_5363> entry : selectedDimensions.comp_1014().method_29722()) {
                result.add(DimId.idToKey(entry.getKey().method_29177()));
            }
            
            // add ImmPtl API custom dimensions
            class_2370<class_5363> customDims = DimensionAPI.collectCustomDimensions(
                settings.method_45689(),
                settings.comp_616()
            );
            for (Map.Entry<class_5321<class_5363>, class_5363> entry : customDims.method_29722()) {
                result.add(DimId.idToKey(entry.getKey().method_29177()));
            }
            
            // add datapack dimensions
            for (Map.Entry<class_5321<class_5363>, class_5363> entry : settings.comp_1027().method_29722()) {
                result.add(DimId.idToKey(entry.getKey().method_29177()));
            }
        }
        catch (Exception e) {
            LOGGER.error("ImmPtl getting dimension list", e);
            if (result.isEmpty()) {
                result.add(DimId.idToKey("error:error"));
            }
        }
        
        return result;
    }
}
