package qouteall.imm_ptl.peripheral.mixin.common.nether_portal;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.peripheral.portal_generation.IntrinsicPortalGeneration;

import java.util.Optional;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_3218;
import net.minecraft.class_4770;

@Mixin(class_4770.class)
public class MixinAbstractFireBlock {
    @Redirect(
        method = "Lnet/minecraft/world/level/block/BaseFireBlock;onPlace(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/world/level/portal/PortalShape;findEmptyPortalShape(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction$Axis;)Ljava/util/Optional;"
        )
    )
    Optional<class_2424> redirectCreateAreaHelper(class_1936 worldAccess, class_2338 blockPos, class_2350.class_2351 axis) {
        if (IPGlobal.netherPortalMode == IPGlobal.NetherPortalMode.disabled) {
            return Optional.empty();
        }
        
        if (IPGlobal.netherPortalMode == IPGlobal.NetherPortalMode.vanilla) {
            return class_2424.method_30485(worldAccess, blockPos, axis);
        }
        
        if (isNearObsidian(worldAccess, blockPos)) {
            IntrinsicPortalGeneration.onFireLitOnObsidian(
                ((class_3218) worldAccess),
                blockPos,
                null
            );
        }
        
        return Optional.empty();
    }
    
    private static boolean isNearObsidian(class_1936 access, class_2338 blockPos) {
        for (class_2350 value : class_2350.values()) {
            if (O_O.isObsidian(access.method_8320(blockPos.method_10093(value)))) {
                return true;
            }
        }
        return false;
    }
    
    // allow lighting fire on the side of obsidian
    // for lighting horizontal portals
    @Redirect(
        method = "Lnet/minecraft/world/level/block/BaseFireBlock;isPortal(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)Z",
        at = @At(
            value = "INVOKE",
            target = "Ljava/util/Optional;isPresent()Z"
        )
    )
    private static boolean redirectIsPresent(Optional optional) {
        if (IPGlobal.netherPortalMode != IPGlobal.NetherPortalMode.vanilla) {
            return true;
        }
        else {
            return optional.isPresent();
        }
    }
}
