package qouteall.imm_ptl.peripheral.portal_generation;

import com.mojang.serialization.Codec;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.NetherPortalLikeForm;
import qouteall.imm_ptl.core.portal.custom_portal_gen.form.PortalGenForm;
import qouteall.imm_ptl.core.portal.nether_portal.BlockPortalShape;
import qouteall.imm_ptl.core.portal.nether_portal.BreakablePortalEntity;
import qouteall.imm_ptl.core.portal.nether_portal.NetherPortalEntity;

import org.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4970;

public class IntrinsicNetherPortalForm extends NetherPortalLikeForm {
    public IntrinsicNetherPortalForm() {
        super(true);
    }
    
    @Override
    public void generateNewFrame(class_3218 fromWorld, BlockPortalShape fromShape, class_3218 toWorld, BlockPortalShape toShape) {
        for (class_2338 blockPos : toShape.frameAreaWithCorner) {
            toWorld.method_8501(blockPos, class_2246.field_10540.method_9564());
        }
    }
    
    @Override
    public PortalGenInfo getNewPortalPlacement(
        class_3218 toWorld, class_2338 toPos,
        class_3218 fromWorld, BlockPortalShape fromShape,
        @Nullable class_1297 triggeringEntity
    ) {
        if (encounteredVanillaPortalBlock) {
            encounteredVanillaPortalBlock = false;
            if (IPGlobal.enableWarning) {
                if(triggeringEntity instanceof class_3222 player){
                    player.method_7353(
                        class_2561.method_43471("imm_ptl.cannot_connect_to_vanilla_portal"),
                        false
                    );
                }
            }
        }
        
        return super.getNewPortalPlacement(toWorld, toPos, fromWorld, fromShape, triggeringEntity);
    }
    
    @Override
    public BreakablePortalEntity[] generatePortalEntitiesAndPlaceholder(PortalGenInfo info) {
        info.generatePlaceholderBlocks();
        BreakablePortalEntity[] portals = info.generateBiWayBiFacedPortal(NetherPortalEntity.entityType);
        
        return portals;
    }
    
    // not per-player, but mostly fine
    private static volatile boolean encounteredVanillaPortalBlock = false;
    
    @Override
    public Predicate<class_2680> getOtherSideFramePredicate() {
        return blockState -> {
            if (O_O.isObsidian(blockState)) {
                return true;
            }
            class_2248 block = blockState.method_26204();
            if (block == class_2246.field_10316) {
                encounteredVanillaPortalBlock = true;
            }
            return false;
        };
    }
    
    @Override
    public Predicate<class_2680> getThisSideFramePredicate() {
        return O_O::isObsidian;
    }
    
    @Override
    public Predicate<class_2680> getAreaPredicate() {
        return class_4970.class_4971::method_26215;
    }
    
    @Override
    public Codec<? extends PortalGenForm> getCodec() {
        throw new RuntimeException();
    }
    
    @Override
    public PortalGenForm getReverse() {
        return this;
    }
}
