package qouteall.imm_ptl.peripheral.wand;

import com.mojang.datafixers.util.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.render.TransformationManager;
import qouteall.imm_ptl.core.render.context_management.PortalRendering;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.AARotation;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPoint;

import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;

@Environment(EnvType.CLIENT)
public class ClientPortalWandPortalCopy {
    
    private static sealed interface Status permits Status_SelectPortal, Status_PlacingPortal {}
    
    private static final class Status_SelectPortal implements Status {
        public @Nullable UUID selectedPortalId;
    }
    
    private static final class Status_PlacingPortal implements Status {
        public final @NotNull PlacementRequirement placementRequirement;
        public final boolean isCut;
        
        public @Nullable UnilateralPortalState pendingPlacement;
        
        private Status_PlacingPortal(@NotNull PlacementRequirement placementRequirement, boolean isCut) {
            this.placementRequirement = placementRequirement;
            this.isCut = isCut;
        }
    }
    
    private static @NotNull Status status = new Status_SelectPortal();
    
    public static record PlacementRequirement(
        double width, double height
    ) {}
    
    public static Animated<RenderedPoint> cursor = new Animated<>(
        Animated.RENDERED_POINT_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.sine::mapProgress,
        RenderedPoint.EMPTY
    );
    
    public static Animated<UnilateralPortalState> selection = new Animated<>(
        UnilateralPortalState.ANIMATION_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.sine::mapProgress,
        null
    );
    
    public static Animated<DQuaternion> placementOrientation = new Animated<>(
        Animated.QUATERNION_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.sine::mapProgress,
        DQuaternion.identity
    );
    
    public static Animated<Double> placementOffsetLen = new Animated<>(
        Animated.DOUBLE_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.sine::mapProgress,
        0.0
    );
    
    public static void reset() {
        status = new Status_SelectPortal();
        cursor.clearTarget();
        selection.clearTarget();
        placementOrientation.clearTarget();
        placementOffsetLen.clearTarget();
    }
    
    public static void updateDisplay() {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        
        if (player == null) {
            return;
        }
        
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5720();
        
        if (status instanceof Status_SelectPortal statusSelectPortal) {
            cursor.clearTarget();
            
            Pair<Portal, class_243> rayTraceResult = PortalUtils.lenientRayTracePortals(
                player.method_37908(),
                eyePos,
                eyePos.method_1019(viewVec.method_1021(64)),
                false,
                p -> true,
                1.0
            ).orElse(null);
            
            if (rayTraceResult != null) {
                Portal portal = rayTraceResult.getFirst();
                
                selection.setTarget(portal.getThisSideState(), Helper.secondToNano(0.5));
                statusSelectPortal.selectedPortalId = portal.method_5667();
                
                ImmPtlCustomOverlay.putText(
                    class_2561.method_43469(
                        "imm_ptl.wand.copy.prompt.copy_or_cut",
                        class_310.method_1551().field_1690.field_1904.method_16007(),
                        class_310.method_1551().field_1690.field_1886.method_16007()
                    )
                );
            }
            else {
                selection.clearTarget();
                statusSelectPortal.selectedPortalId = null;
                
                ImmPtlCustomOverlay.putText(
                    class_2561.method_43471("imm_ptl.wand.copy.prompt.select_portal")
                );
            }
        }
        else if (status instanceof Status_PlacingPortal statusPlacingPortal) {
            selection.clearTarget();
            
            class_239 hitResult = player.method_5745(64, RenderStates.getPartialTick(), false);
            int alignment = IPConfig.getConfig().portalWandCursorAlignment;
            
            class_243 preCursorPos;
            if (hitResult.method_17783() == class_239.class_240.field_1332 && (hitResult instanceof class_3965 blockHitResult)) {
                preCursorPos = blockHitResult.method_17784();
            }
            else {
                preCursorPos = eyePos.method_1019(viewVec.method_1021(5));
            }
            
            class_243 cursorPointing = WandUtil.alignOnBlocks(
                player.method_37908(), preCursorPos, alignment
            );
            
            cursor.setTarget(
                new RenderedPoint(
                    new WithDim<>(player.method_37908().method_27983(), cursorPointing), 1.0
                ),
                Helper.secondToNano(0.5)
            );
            
            // the camera rotation is used for rotating the world onto local camera,
            // the conjugated rotation is for rotating local camera onto camera in world
            DQuaternion camRotInverse = TransformationManager.getPlayerCameraRotation().getConjugated();
            
            AARotation orientationRot = Arrays.stream(AARotation.values())
                .min(Comparator.comparingDouble(
                    r -> DQuaternion.distance(r.quaternion, camRotInverse)
                ))
                .orElseThrow();
            DQuaternion orientation = orientationRot.quaternion;
            
            PlacementRequirement req = statusPlacingPortal.placementRequirement;
            
            boolean isFacingUpOrDown = player.method_36455() > 45 || player.method_36455() < -45;
            double offsetLen = isFacingUpOrDown ? 0 : req.height() / 2;
            class_243 offset = orientation.rotate(new class_243(0, offsetLen, 0));
            class_243 placementOrigin = cursorPointing.method_1019(offset);
            
            UnilateralPortalState placement = new UnilateralPortalState(
                player.method_37908().method_27983(),
                placementOrigin,
                orientation,
                req.width(), req.height()
            );
            
            statusPlacingPortal.pendingPlacement = placement;
            
            placementOrientation.setTarget(orientation, Helper.secondToNano(0.5));
            placementOffsetLen.setTarget(offsetLen, Helper.secondToNano(0.5));
            
            ImmPtlCustomOverlay.putText(
                class_2561.method_43469(
                    "imm_ptl.wand.copy.prompt.place_portal",
                    class_310.method_1551().field_1690.field_1904.method_16007(),
                    class_310.method_1551().field_1690.field_1886.method_16007()
                )
            );
        }
        else {
            throw new RuntimeException();
        }
    }
    
    public static void onLeftClick() {
        if (status instanceof Status_SelectPortal statusSelectPortal) {
            // cut the portal
            if (statusSelectPortal.selectedPortalId != null) {
                Portal portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId);
                if (portal != null) {
                    status = new Status_PlacingPortal(
                        new PlacementRequirement(portal.width, portal.height),
                        true
                    );
                    McRemoteProcedureCall.tellServerToInvoke(
                        "qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal",
                        statusSelectPortal.selectedPortalId,
                        true
                    );
                }
            }
        }
        else if (status instanceof Status_PlacingPortal statusPlacingPortal) {
            // discard
            McRemoteProcedureCall.tellServerToInvoke(
                "qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.clearPortalClipboard"
            );
            status = new Status_SelectPortal();
        }
    }
    
    public static void onRightClick() {
        if (status instanceof Status_SelectPortal statusSelectPortal) {
            // copy the portal
            if (statusSelectPortal.selectedPortalId != null) {
                Portal portal = WandUtil.getClientPortalByUUID(statusSelectPortal.selectedPortalId);
                if (portal != null) {
                    status = new Status_PlacingPortal(
                        new PlacementRequirement(portal.width, portal.height),
                        false
                    );
                    McRemoteProcedureCall.tellServerToInvoke(
                        "qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.copyCutPortal",
                        statusSelectPortal.selectedPortalId,
                        false
                    );
                }
            }
        }
        else if (status instanceof Status_PlacingPortal statusPlacingPortal) {
            // confirm placing
            if (statusPlacingPortal.pendingPlacement != null) {
                McRemoteProcedureCall.tellServerToInvoke(
                    "qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.confirmCopyCut",
                    statusPlacingPortal.pendingPlacement.position(),
                    statusPlacingPortal.pendingPlacement.orientation()
                );
                status = new Status_SelectPortal();
            }
        }
    }
    
    private static final int colorOfCursor = 0xff03fcfc;
    private static final int colorOfSelection1 = 0xff52FF92;
    private static final int colorOfSelection2 = 0xffFC933D;
    private static final int colorOfPendingPlacement1 = 0xff00ffff;
    private static final int colorOfPendingPlacement2 = 0xffDC4BFF;
    
    public static void render(
        class_4587 matrixStack,
        class_4597.class_4598 bufferSource,
        double camX, double camY, double camZ
    ) {
        class_746 player = class_310.method_1551().field_1724;
        
        if (player == null) {
            return;
        }
        
        if (PortalRendering.isRendering()) {
            return;
        }
        
        class_5321<class_1937> currDim = player.method_37908().method_27983();
        class_243 cameraPos = new class_243(camX, camY, camZ);
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        
        class_243 cursorPos = null;
        RenderedPoint currentCursor = cursor.getCurrent();
        if (currentCursor != null) {
            WithDim<class_243> posWithDim = currentCursor.pos();
            if (posWithDim != null) {
                if (posWithDim.dimension() == currDim) {
                    cursorPos = posWithDim.value();
                }
            }
        }
        
        if (cursorPos != null) {
            WireRenderingHelper.renderSmallCubeFrame(
                vertexConsumer, cameraPos, cursorPos,
                colorOfCursor, cursor.getCurrent().scale(), matrixStack
            );
        }
        
        UnilateralPortalState rect = selection.getCurrent();
        
        if (rect != null) {
            if (rect.dimension() == currDim) {
                WireRenderingHelper.renderRectFrameFlow(
                    matrixStack, cameraPos,
                    vertexConsumer, rect,
                    colorOfSelection1,
                    colorOfSelection2
                );
            }
        }
        
        if (status instanceof Status_PlacingPortal statusPlacingPortal) {
            DQuaternion orientation = placementOrientation.getCurrent();
            Double offsetLen = placementOffsetLen.getCurrent();
            Validate.isTrue(orientation != null);
            Validate.isTrue(offsetLen != null);
            
            class_243 offset = orientation.rotate(new class_243(0, offsetLen, 0));
            
            if (cursorPos != null) {
                PlacementRequirement req = statusPlacingPortal.placementRequirement;
                UnilateralPortalState placement = new UnilateralPortalState(
                    currDim,
                    cursorPos.method_1019(offset),
                    orientation,
                    req.width(), req.height()
                );
                
                WireRenderingHelper.renderRectFrameFlow(
                    matrixStack, cameraPos,
                    vertexConsumer, placement,
                    colorOfPendingPlacement1,
                    colorOfPendingPlacement2
                );
            }
        }
        
    }
}
