package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.portal.animation.TimingFunction;
import qouteall.imm_ptl.core.render.context_management.RenderStates;
import qouteall.imm_ptl.peripheral.ImmPtlCustomOverlay;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;
import qouteall.q_misc_util.my_util.animation.Animated;
import qouteall.q_misc_util.my_util.animation.RenderedPlane;

/**
 * The process and relevant marking rendering is handled purely on client side.
 * When it finishes, it performs a remote procedure call to create the portal.
 */
@Environment(EnvType.CLIENT)
public class ClientPortalWandPortalCreation {
    
    private static final Logger LOGGER = LogUtils.getLogger();
    
    public static final Animated<class_243> cursor = new Animated<>(
        Animated.VEC3_NULLABLE_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.circle::mapProgress,
        null
    );
    
    public static final Animated<RenderedPlane> renderedPlane = new Animated<>(
        Animated.RENDERED_PLANE_TYPE_INFO,
        () -> RenderStates.renderStartNanoTime,
        TimingFunction.sine::mapProgress,
        RenderedPlane.NONE
    );
    
    // the proto-portal determined by placed anchors
    @NotNull
    public static ProtoPortal protoPortal = new ProtoPortal();
    
    public static void reset() {
        protoPortal.reset();
        renderedPlane.clearTarget();
    }
    
    public static void onLeftClick() {
        undo();
    }
    
    private static void undo() {
        protoPortal.undo();
    }
    
    public static void onRightClick() {
        class_243 cursorTarget = cursor.getTarget();
        
        if (cursorTarget == null) {
            return;
        }
        
        class_638 world = class_310.method_1551().field_1687;
        
        if (world == null) {
            return;
        }
        
        protoPortal.tryPlaceCursor(
            world.method_27983(),
            cursorTarget
        );
        
        if (protoPortal.isComplete()) {
            finish();
        }
    }
    
    public static void clearCursorPointing() {
        cursor.clearTarget();
    }
    
    public static void updateDisplay() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        
        class_5321<class_1937> cursorLimitingDim = protoPortal.getCursorConstraintDim();
        
        if (cursorLimitingDim != null && player.method_37908().method_27983() != cursorLimitingDim) {
            cursor.clearTarget();
            renderedPlane.clearTarget();
            return;
        }
        
        WithDim<Plane> limitingPlane = protoPortal.getCursorConstraintPlane();
        WithDim<Circle> limitingCircle = protoPortal.getCursorConstraintCircle();
        
        class_243 eyePos = player.method_5836(RenderStates.getPartialTick());
        class_243 viewVec = player.method_5828(RenderStates.getPartialTick());
        
        // update cursor
        class_243 cursorPointing = null;
        int alignment = IPConfig.getConfig().portalWandCursorAlignment;
        if (limitingPlane != null) {
            cursorPointing = limitingPlane.value().rayTrace(eyePos, viewVec);
            
            if (cursorPointing != null) {
                // align it and then project onto plane
                // aligning may cause it to be out of the plane
                cursorPointing = WandUtil.alignOnBlocks(player.method_37908(), cursorPointing, alignment);
                cursorPointing = limitingPlane.value().getProjection(cursorPointing);
                
                if (limitingCircle != null) {
                    // align it into the circle
                    cursorPointing = limitingCircle.value().projectToCircle(cursorPointing);
                }
            }
        }
        else {
            class_239 hitResult = player.method_5745(64, RenderStates.getPartialTick(), false);
            
            if (hitResult.method_17783() == class_239.class_240.field_1332 && (hitResult instanceof class_3965 blockHitResult)) {
                // if pointing at a block, use the aligned position on block
                cursorPointing = WandUtil.alignOnBlocks(player.method_37908(), blockHitResult.method_17784(), alignment);
            }
        }
        
        if (limitingPlane != null && limitingCircle == null) {
            renderedPlane.setTarget(
                new RenderedPlane(limitingPlane, 1.0),
                Helper.secondToNano(3.0)
            );
        }
        else {
            renderedPlane.setTarget(
                RenderedPlane.NONE, Helper.secondToNano(0.5)
            );
        }
        
        // remove cursor if the placement is invalid
        
        if (cursorPointing != null) {
            ProtoPortal pendingState = protoPortal.copy();
            boolean canPlace = pendingState.tryPlaceCursor(player.method_37908().method_27983(), cursorPointing);
            if (!canPlace || !pendingState.isValidPlacement()) {
                cursorPointing = null;
                pendingState = null;
            }
            
            class_5250 promptMessage = protoPortal.getPromptMessage(pendingState);
            if (promptMessage != null) {
                ImmPtlCustomOverlay.putText(
                    promptMessage
                );
            }
        }
        
        if (cursorPointing != null) {
            cursor.setTarget(cursorPointing, Helper.secondToNano(0.5));
        }
        else {
            cursor.clearTarget();
        }
    }
    
    /**
     * {@link PortalWandInteraction.RemoteCallables#finishPortalCreation(class_3222, ProtoPortal)}
     */
    public static void finish() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        
        McRemoteProcedureCall.tellServerToInvoke(
            "qouteall.imm_ptl.peripheral.wand.PortalWandInteraction.RemoteCallables.finishPortalCreation",
            protoPortal
        );
        
        reset();
    }
    
    // ARGB
    private static final int colorOfFirstSideLeftBottom = 0xfffb00ff;
    private static final int colorOfFirstSideRightBottom = 0xffe63262;
    private static final int colorOfFirstSideLeftUp = 0xfffcef60;
    
    private static final int colorOfSecondSideLeftBottom = 0xffaeff57;
    private static final int colorOfSecondSideRightBottom = 0xff57ffd2;
    private static final int colorOfSecondSideLeftUp = 0xffbdb3ff;
    
    private static final int colorOfPlane = 0xffafd3fa;
    private static final int colorOfCircle = 0xff03fce3;
    private static final int colorOfFirstPortalArea = 0xfffc9003;
    private static final int colorOfFirstPortalArea2 = 0xffFF7D98;
    private static final int colorOfSecondPortalArea = 0xff60f2fc;
    private static final int colorOfSecondPortalArea2 = 0xff60f2fc;
    
    public static void render(
        class_4587 matrixStack,
        class_4597.class_4598 bufferSource,
        double camX, double camY, double camZ
    ) {
        class_746 player = class_310.method_1551().field_1724;
        
        if (player == null) {
            return;
        }
        
        class_5321<class_1937> currDim = player.method_37908().method_27983();
        
        class_4588 vertexConsumer = bufferSource.getBuffer(class_1921.method_23594());
        class_243 cameraPos = new class_243(camX, camY, camZ);
        
        WithDim<Circle> circle = protoPortal.getCursorConstraintCircle();
        
        class_243 renderedCursor = ClientPortalWandPortalCreation.cursor.getCurrent();
        
        if (circle != null && renderedCursor != null) {
            // the cursor interpolates along line
            // it may not always be on the circle
            renderedCursor = circle.value().projectToCircle(renderedCursor);
        }
        
        ProtoPortal renderedProtoPortal = protoPortal;
        
        if (renderedCursor != null) {
            ProtoPortal pending = protoPortal.copy();
            boolean canPlace = pending.tryPlaceCursor(currDim, renderedCursor);
            
            if (canPlace) {
                renderedProtoPortal = pending;
            }
        }
        
        if (circle == null) {
            circle = protoPortal.getCursorConstraintCircle();
        }
        
        // render the proto-portal
        if (renderedProtoPortal.firstSide != null && currDim == renderedProtoPortal.firstSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame(
                vertexConsumer, cameraPos, renderedProtoPortal.firstSide.leftBottom,
                colorOfFirstSideLeftBottom, 1.0, matrixStack
            );
            
            if (renderedProtoPortal.firstSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame(
                    vertexConsumer, cameraPos, renderedProtoPortal.firstSide.rightBottom,
                    colorOfFirstSideRightBottom, 1.0, matrixStack
                );
            }
            if (renderedProtoPortal.firstSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame(
                    vertexConsumer, cameraPos, renderedProtoPortal.firstSide.leftTop,
                    colorOfFirstSideLeftUp, 1.0, matrixStack
                );
                
                WandUtil.renderPortalAreaGrid(
                    vertexConsumer,
                    cameraPos,
                    renderedProtoPortal.firstSide,
                    colorOfFirstPortalArea,
                    matrixStack
                );
            }
        }
        
        if (renderedProtoPortal.secondSide != null && currDim == renderedProtoPortal.secondSide.dimension) {
            WireRenderingHelper.renderSmallCubeFrame(
                vertexConsumer, cameraPos, renderedProtoPortal.secondSide.leftBottom,
                colorOfSecondSideLeftBottom, 1.0, matrixStack
            );
            
            if (renderedProtoPortal.secondSide.rightBottom != null) {
                WireRenderingHelper.renderSmallCubeFrame(
                    vertexConsumer, cameraPos, renderedProtoPortal.secondSide.rightBottom,
                    colorOfSecondSideRightBottom, 1.0, matrixStack
                );
            }
            if (renderedProtoPortal.secondSide.leftTop != null) {
                WireRenderingHelper.renderSmallCubeFrame(
                    vertexConsumer, cameraPos, renderedProtoPortal.secondSide.leftTop,
                    colorOfSecondSideLeftUp, 1.0, matrixStack
                );
                
                WandUtil.renderPortalAreaGrid(
                    vertexConsumer,
                    cameraPos,
                    renderedProtoPortal.secondSide,
                    colorOfSecondPortalArea,
                    matrixStack
                );
            }
        }
        
        class_4588 debugLineStripConsumer = bufferSource.getBuffer(class_1921.method_49043(1));
        
        // render the circle
        WithDim<Circle> renderedCircle = circle != null ?
            circle : renderedProtoPortal.getCursorConstraintCircle();
        if (renderedCircle != null && renderedCircle.dimension() == currDim) {
            WireRenderingHelper.renderCircle(
                debugLineStripConsumer, cameraPos,
                renderedCircle.value(),
                colorOfCircle,
                matrixStack
            );
        }
        
        // render the plane (don't render the plane if renders circle)
        RenderedPlane currRenderedPlane = renderedPlane.getCurrent();
        if (currRenderedPlane != null &&
            currRenderedPlane.plane() != null &&
            currRenderedPlane.plane().dimension() == currDim
        ) {
            double scale = currRenderedPlane.scale();
            if (scale > 0.01) {
                WireRenderingHelper.renderPlane(
                    debugLineStripConsumer,
                    cameraPos, currRenderedPlane.plane().value(),
                    scale,
                    colorOfPlane,
                    matrixStack
                );
            }
        }
    }
    
}
