package qouteall.imm_ptl.peripheral.wand;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7706;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;

import java.util.ArrayList;
import java.util.List;

public class PortalWandItem extends class_1792 {
    public static final PortalWandItem instance = new PortalWandItem(new class_1793());
    
    public static void init() {
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register(
            groupEntries -> {
                class_1799 s1 = new class_1799(instance);
                s1.method_7980(Mode.CREATE_PORTAL.toTag());
                groupEntries.method_45420(s1);
                
                class_1799 s2 = new class_1799(instance);
                s2.method_7980(Mode.DRAG_PORTAL.toTag());
                groupEntries.method_45420(s2);
                
                class_1799 s3 = new class_1799(instance);
                s3.method_7980(Mode.COPY_PORTAL.toTag());
                groupEntries.method_45420(s3);
            }
        );
        
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (player.method_6047().method_7909() == instance) {
                // cannot break block using the wand
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        
        BlockManipulationServer.canDoCrossPortalInteractionEvent.register(p -> {
            return p.method_6047().method_7909() != instance;
        });
    }
    
    public static void initClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                class_1799 itemStack = client.field_1724.method_6047();
                if (itemStack.method_7909() == instance) {
                    updateDisplay(itemStack);
                }
                else {
                    ClientPortalWandPortalCreation.clearCursorPointing();
                }
            }
            ClientPortalWandPortalDrag.tick();
        });
        
        
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCreation::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalDrag::reset);
        IPGlobal.clientCleanupSignal.connect(ClientPortalWandPortalCopy::reset);
    }
    
    public static enum Mode {
        CREATE_PORTAL,
        DRAG_PORTAL,
        COPY_PORTAL;
        
        public static Mode fromTag(class_2487 tag) {
            String mode = tag.method_10558("mode");
            
            return switch (mode) {
                case "create_portal" -> CREATE_PORTAL;
                case "drag_portal" -> DRAG_PORTAL;
                case "copy_portal" -> COPY_PORTAL;
                default -> CREATE_PORTAL;
            };
        }
        
        public Mode next() {
            return switch (this) {
                case CREATE_PORTAL -> DRAG_PORTAL;
                case DRAG_PORTAL -> COPY_PORTAL;
                case COPY_PORTAL -> CREATE_PORTAL;
            };
        }
        
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            String modeString = switch (this) {
                case CREATE_PORTAL -> "create_portal";
                case DRAG_PORTAL -> "drag_portal";
                case COPY_PORTAL -> "copy_portal";
            };
            tag.method_10582("mode", modeString);
            return tag;
        }
        
        public class_5250 getText() {
            return switch (this) {
                case CREATE_PORTAL -> class_2561.method_43471("imm_ptl.wand.mode.create_portal");
                case DRAG_PORTAL -> class_2561.method_43471("imm_ptl.wand.mode.drag_portal");
                case COPY_PORTAL -> class_2561.method_43471("imm_ptl.wand.mode.copy_portal");
            };
        }
        
    }
    
    public PortalWandItem(class_1793 properties) {
        super(properties);
    }
    
    @Environment(EnvType.CLIENT)
    public static void onClientLeftClick(class_746 player, class_1799 itemStack) {
        if (player.method_5715()) {
            showSettings(player);
        }
        else {
            Mode mode = Mode.fromTag(itemStack.method_7948());
            
            switch (mode) {
                case CREATE_PORTAL -> {
                    ClientPortalWandPortalCreation.onLeftClick();
                }
                case DRAG_PORTAL -> {
                    ClientPortalWandPortalDrag.onLeftClick();
                }
                case COPY_PORTAL -> {
                    ClientPortalWandPortalCopy.onLeftClick();
                }
            }
        }
    }
    
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        Mode mode = Mode.fromTag(itemStack.method_7948());
        
        if (player.method_5715()) {
            if (!world.method_8608()) {
                if (!PortalWandInteraction.isDragging(((class_3222) player))) {
                    Mode nextMode = mode.next();
                    itemStack.method_7980(nextMode.toTag());
                    return new class_1271<>(class_1269.field_5812, itemStack);
                }
            }
        }
        
        if (!player.method_5715()) {
            if (world.method_8608()) {
                onUseClient(mode);
            }
        }
        
        return super.method_7836(world, player, hand);
    }
    
    @Environment(EnvType.CLIENT)
    private void onUseClient(Mode mode) {
        switch (mode) {
            case CREATE_PORTAL -> {
                ClientPortalWandPortalCreation.onRightClick();
            }
            case DRAG_PORTAL -> {
                ClientPortalWandPortalDrag.onRightClick();
            }
            case COPY_PORTAL -> {
                ClientPortalWandPortalCopy.onRightClick();
            }
        }
    }
    
    @Environment(EnvType.CLIENT)
    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        
        tooltip.add(class_2561.method_43469(
            "imm_ptl.wand.item_desc_1",
            class_310.method_1551().field_1690.field_1832.method_16007(),
            class_310.method_1551().field_1690.field_1904.method_16007()
        ));
        tooltip.add(class_2561.method_43469(
            "imm_ptl.wand.item_desc_2",
            class_310.method_1551().field_1690.field_1832.method_16007(),
            class_310.method_1551().field_1690.field_1886.method_16007()
        ));
    }
    
    @Override
    public class_2561 method_7864(class_1799 stack) {
        Mode mode = Mode.fromTag(stack.method_7948());
        
        class_5250 baseText = class_2561.method_43471("item.immersive_portals.portal_wand");
        
        return baseText
            .method_10852(class_2561.method_43470(" : "))
            .method_10852(mode.getText().method_27692(class_124.field_1065));
    }
    
    public static void showSettings(class_1657 player) {
        player.method_43496(class_2561.method_43471("imm_ptl.wand.settings_1"));
        player.method_43496(class_2561.method_43471("imm_ptl.wand.settings_alignment"));
        
        int[] alignments = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 16, 32, 64};
        
        List<class_5250> alignmentSettingTexts = new ArrayList<>();
        for (int alignment : alignments) {
            class_5250 textWithCommand = IPMcHelper.getTextWithCommand(
                class_2561.method_43470("1/" + alignment),
                "/imm_ptl_client_debug wand set_cursor_alignment " + alignment
            );
            alignmentSettingTexts.add(textWithCommand);
        }
        
        alignmentSettingTexts.add(IPMcHelper.getTextWithCommand(
            class_2561.method_43471("imm_ptl.wand.no_alignment"),
            "/imm_ptl_client_debug wand set_cursor_alignment 0"
        ));
        
        player.method_43496(
            alignmentSettingTexts.stream().reduce(class_2561.method_43470(""), (a, b) -> a.method_27693(" ").method_10852(b))
        );
        
        player.method_43496(class_2561.method_43469(
            "imm_ptl.wand.settings_2", class_310.method_1551().field_1690.field_1890.method_16007()
        ));
    }
    
    private static boolean instructionInformed = false;
    
    @Environment(EnvType.CLIENT)
    private static void updateDisplay(class_1799 itemStack) {
        Mode mode = Mode.fromTag(itemStack.method_7948());
        
        switch (mode) {
            case CREATE_PORTAL -> ClientPortalWandPortalCreation.updateDisplay();
            case DRAG_PORTAL -> ClientPortalWandPortalDrag.updateDisplay();
            case COPY_PORTAL -> ClientPortalWandPortalCopy.updateDisplay();
        }
    }
    
    @Environment(EnvType.CLIENT)
    public static void clientRender(
        class_746 player, class_1799 itemStack, class_4587 poseStack, class_4597.class_4598 bufferSource,
        double camX, double camY, double camZ
    ) {
        if (!instructionInformed) {
            instructionInformed = true;
//            player.sendSystemMessage(
//                IPMcHelper.getTextWithCommand(
//                    Component.translatable("imm_ptl.show_portal_wand_instruction"),
//                    "/imm_ptl_client_debug wand show_instruction"
//                )
//            );
        }
        
        class_2487 tag = itemStack.method_7948();
        Mode mode = Mode.fromTag(tag);
        
        switch (mode) {
            case CREATE_PORTAL -> ClientPortalWandPortalCreation.render(
                poseStack, bufferSource, camX, camY, camZ
            );
            case DRAG_PORTAL -> ClientPortalWandPortalDrag.render(
                poseStack, bufferSource, camX, camY, camZ
            );
            case COPY_PORTAL -> ClientPortalWandPortalCopy.render(
                poseStack, bufferSource, camX, camY, camZ
            );
        }
    }
    
}
