package qouteall.imm_ptl.peripheral.wand;

import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5321;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.WithDim;

/**
 * The proto-portal's one-side when using portal wand to create new portal.
 * Will be serialized to JSON (require type adapter for dimension id).
 */
public class ProtoPortalSide {
    @NotNull
    public class_5321<class_1937> dimension;
    
    @NotNull
    public class_243 leftBottom;
    
    @Nullable
    public class_243 rightBottom;
    
    @Nullable
    public class_243 leftTop;
    
    public ProtoPortalSide(@NotNull class_5321<class_1937> dimension, @NotNull class_243 leftBottom) {
        this.leftBottom = leftBottom;
        this.dimension = dimension;
    }
    
    public ProtoPortalSide copy() {
        ProtoPortalSide newPortal = new ProtoPortalSide(dimension, leftBottom);
        newPortal.rightBottom = rightBottom;
        newPortal.leftTop = leftTop;
        return newPortal;
    }
    
    public class_243 getHorizontalAxis() {
        assert rightBottom != null;
        return rightBottom.method_1020(leftBottom);
    }
    
    public class_243 getVerticalAxis() {
        assert leftTop != null;
        return leftTop.method_1020(leftBottom);
    }
    
    public class_243 getNormal() {
        return getHorizontalAxis().method_1036(getVerticalAxis()).method_1029();
    }
    
    public double getWidth() {
        return getHorizontalAxis().method_1033();
    }
    
    public double getHeight() {
        return getVerticalAxis().method_1033();
    }
    
    public double getHeightDivWidth() {
        double width = getWidth();
        double height = getHeight();
        
        if (width == 0) {
            return 0;
        }
        
        return height / width;
    }
    
    @Nullable
    public ProtoPortalSide undo() {
        if (leftTop != null) {
            leftTop = null;
            return this;
        }
        if (rightBottom != null) {
            rightBottom = null;
            return this;
        }
        return null;
    }
    
    public boolean isComplete() {
        return leftTop != null;
    }
    
    @Nullable
    public WithDim<Plane> getCursorConstraintPlane() {
        if (isComplete()) {
            return null;
        }
        if (rightBottom == null) {
            return null;
        }
        return new WithDim<>(dimension, new Plane(leftBottom, getHorizontalAxis()));
    }
    
    @Nullable
    public WithDim<Circle> getCursorConstraintCircle(double heightDivWidth) {
        if (isComplete()) {
            return null;
        }
        
        if (rightBottom == null) {
            return null;
        }
        
        WithDim<Plane> plane = getCursorConstraintPlane();
        Validate.notNull(plane);
        
        class_243 horizontalAxis = getHorizontalAxis();
        double width = horizontalAxis.method_1033();
        
        double constraintHeight = width * heightDivWidth;
        
        return new WithDim<>(dimension, new Circle(plane.value(), leftBottom, constraintHeight));
    }
    
    public boolean isValidPlacement(@Nullable Double heightDivWidth) {
        if (rightBottom != null) {
            double width = getHorizontalAxis().method_1033();
            
            if (width < 0.001 || width > 64.001) {
                return false;
            }
            
            if (leftTop != null) {
                double height = getVerticalAxis().method_1033();
                
                if (height < 0.001 || height > 64.001) {
                    return false;
                }
            }
            else if (heightDivWidth != null) {
                double height = width * heightDivWidth;
                
                if (height < 0.001 || height > 64.001) {
                    return false;
                }
            }
        }
        
        return true;
    }
    
    public void placeCursor(class_243 pos) {
        if (rightBottom == null) {
            rightBottom = pos;
        }
        else if (leftTop == null) {
            leftTop = pos;
        }
        else {
            throw new IllegalStateException();
        }
    }
    
    public UnilateralPortalState toUnilateralPortalState() {
        Validate.isTrue(isComplete());
        
        class_243 horizontalAxis = getHorizontalAxis();
        class_243 verticalAxis = getVerticalAxis();
        
        return new UnilateralPortalState(
            dimension,
            leftBottom.method_1019(horizontalAxis.method_1021(0.5)).method_1019(verticalAxis.method_1021(0.5)),
            DQuaternion.fromFacingVecs(
                horizontalAxis.method_1029(),
                verticalAxis.method_1029()
            ),
            horizontalAxis.method_1033(),
            verticalAxis.method_1033()
        );
    }
}
